/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
class OperationTimer {
    private static final ThreadMXBean THREAD_MX_BEAN = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    private final boolean trackOverallCpuTime;
    private final boolean trackOperationCpuTime;
    private final boolean trackOverallAllocation;
    private final boolean trackOperationAllocation;
    private final long wallStart;
    private final long cpuStart;
    private final long allocationStart;
    private long intervalWallStart;
    private long intervalCpuStart;
    private long intervalAllocationStart;
    private boolean finished;

    OperationTimer(boolean trackOverallCpuTime) {
        this(trackOverallCpuTime, false, false, false);
    }

    OperationTimer(boolean trackOverallCpuTime, boolean trackOperationCpuTime, boolean trackOverallAllocation, boolean trackOperationAllocation) {
        this.trackOverallCpuTime = trackOverallCpuTime;
        this.trackOperationCpuTime = trackOperationCpuTime;
        Preconditions.checkArgument((trackOverallCpuTime || !trackOperationCpuTime ? 1 : 0) != 0, (Object)"tracking operation cpu time without tracking overall cpu time is not supported");
        this.trackOverallAllocation = trackOverallAllocation;
        this.trackOperationAllocation = trackOperationAllocation;
        Preconditions.checkArgument((trackOverallAllocation || !trackOperationAllocation ? 1 : 0) != 0, (Object)"tracking operation allocation without tracking overall allocation is not supported");
        this.wallStart = System.nanoTime();
        this.cpuStart = trackOverallCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        this.allocationStart = trackOverallAllocation ? OperationTimer.currentThreadAllocation() : 0L;
        this.intervalWallStart = this.wallStart;
        this.intervalCpuStart = this.cpuStart;
        this.intervalAllocationStart = this.allocationStart;
    }

    void recordOperationComplete(OperationTiming operationTiming) {
        Objects.requireNonNull(operationTiming, "operationTiming is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"timer is finished");
        long intervalCpuEnd = this.trackOperationCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        long intervalWallEnd = System.nanoTime();
        long intervalAllocationEnd = this.trackOperationAllocation ? OperationTimer.currentThreadAllocation() : 0L;
        long operationWallNanos = OperationTimer.nanosBetween(this.intervalWallStart, intervalWallEnd);
        long operationCpuNanos = this.trackOperationCpuTime ? OperationTimer.nanosBetween(this.intervalCpuStart, intervalCpuEnd) : 0L;
        long operationAllocation = this.trackOperationAllocation ? OperationTimer.bytesBetween(this.intervalAllocationStart, intervalAllocationEnd) : 0L;
        operationTiming.record(operationWallNanos, operationCpuNanos, operationAllocation);
        this.intervalWallStart = intervalWallEnd;
        this.intervalCpuStart = intervalCpuEnd;
        this.intervalAllocationStart = intervalAllocationEnd;
    }

    void end(OperationTiming overallTiming) {
        Objects.requireNonNull(overallTiming, "overallTiming is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"timer is finished");
        this.finished = true;
        long cpuEnd = this.trackOverallCpuTime ? OperationTimer.currentThreadCpuTime() : 0L;
        long wallEnd = System.nanoTime();
        long allocationEnd = this.trackOverallAllocation ? OperationTimer.currentThreadAllocation() : 0L;
        overallTiming.record(OperationTimer.nanosBetween(this.wallStart, wallEnd), OperationTimer.nanosBetween(this.cpuStart, cpuEnd), OperationTimer.bytesBetween(this.allocationStart, allocationEnd));
    }

    private static long currentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long currentThreadAllocation() {
        return THREAD_MX_BEAN.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    private static long bytesBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    @ThreadSafe
    static class OperationTiming {
        private final AtomicLong calls = new AtomicLong();
        private final AtomicLong wallNanos = new AtomicLong();
        private final AtomicLong cpuNanos = new AtomicLong();
        private final AtomicLong allocationBytes = new AtomicLong();

        OperationTiming() {
        }

        long getCalls() {
            return this.calls.get();
        }

        long getWallNanos() {
            return this.wallNanos.get();
        }

        long getCpuNanos() {
            return this.cpuNanos.get();
        }

        long getAllocationBytes() {
            return this.allocationBytes.get();
        }

        void record(long wallNanos, long cpuNanos, long allocationBytes) {
            this.calls.incrementAndGet();
            this.wallNanos.addAndGet(wallNanos);
            this.cpuNanos.addAndGet(cpuNanos);
            this.allocationBytes.addAndGet(allocationBytes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("calls", (Object)this.calls).add("wallNanos", (Object)this.wallNanos).add("cpuNanos", (Object)this.cpuNanos).add("allocationBytes", (Object)this.allocationBytes).toString();
        }
    }
}

