/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.multimapagg;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationStateFactory;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationStateSerializer;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MultimapAggregationFunction
extends SqlAggregationFunction {
    public static final String NAME = "multimap_agg";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "output", Type.class, Type.class, MultimapAggregationState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "combine", MultimapAggregationState.class, MultimapAggregationState.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "input", MultimapAggregationState.class, Block.class, Block.class, Integer.TYPE);
    private static final int EXPECTED_ENTRY_SIZE = 100;
    private final MultimapAggGroupImplementation groupMode;

    public MultimapAggregationFunction(MultimapAggGroupImplementation groupMode) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"K"), (Object)Signature.typeVariable((String)"V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,array(V))"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"K"), (Object)TypeSignature.parseTypeSignature((String)"V")));
        this.groupMode = groupMode;
    }

    public String getDescription() {
        return "Aggregates all the rows (key/value pairs) into a single multimap";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        Type outputType = functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)new ArrayType(valueType).getTypeSignature())));
        return this.generateAggregation(keyType, valueType, outputType);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(Type keyType, Type valueType, Type outputType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MultimapAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)keyType, (Object)valueType);
        MultimapAggregationStateSerializer stateSerializer = new MultimapAggregationStateSerializer(keyType, valueType);
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), MultimapAggregationFunction.createInputParameterMetadata(keyType, valueType), INPUT_FUNCTION, COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(keyType).bindTo(valueType), (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(MultimapAggregationState.class, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new MultimapAggregationStateFactory(keyType, valueType, this.groupMode))), outputType);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, true, true, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type keyType, Type valueType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, keyType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, valueType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(MultimapAggregationState state, Block key, Block value, int position) {
        state.add(key, value, position);
    }

    public static void combine(MultimapAggregationState state, MultimapAggregationState otherState) {
        state.merge(otherState);
    }

    public static void output(Type keyType, Type valueType, MultimapAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ObjectBigArray valueArrayBlockBuilders = new ObjectBigArray();
            valueArrayBlockBuilders.ensureCapacity((long)state.getEntryCount());
            BlockBuilder distinctKeyBlockBuilder = keyType.createBlockBuilder(null, state.getEntryCount(), TypeUtils.expectedValueSize(keyType, 100));
            TypedSet keySet = new TypedSet(keyType, state.getEntryCount(), NAME);
            state.forEach((key, value, keyValueIndex) -> {
                if (keySet.add(key, keyValueIndex)) {
                    keyType.appendTo(key, keyValueIndex, distinctKeyBlockBuilder);
                    BlockBuilder valueArrayBuilder = valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(valueType, 100));
                    valueArrayBlockBuilders.set((long)keySet.positionOf(key, keyValueIndex), (Object)valueArrayBuilder);
                }
                valueType.appendTo(value, keyValueIndex, (BlockBuilder)valueArrayBlockBuilders.get((long)keySet.positionOf(key, keyValueIndex)));
            });
            ArrayType valueArrayType = new ArrayType(valueType);
            BlockBuilder multimapBlockBuilder = out.beginBlockEntry();
            for (int i = 0; i < distinctKeyBlockBuilder.getPositionCount(); ++i) {
                keyType.appendTo((Block)distinctKeyBlockBuilder, i, multimapBlockBuilder);
                valueArrayType.writeObject(multimapBlockBuilder, (Object)((BlockBuilder)valueArrayBlockBuilders.get((long)i)).build());
            }
            out.closeEntry();
        }
    }
}

