/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class DecodedBlockNode {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecodedBlockNode.class).instanceSize();
    private final Object decodedBlock;
    private final List<DecodedBlockNode> children;
    private final long retainedSizeInBytes;
    private final long estimatedSerializedSizeInBytes;

    public DecodedBlockNode(Object decodedBlock, List<DecodedBlockNode> children, long decodedBlockRetainedSizeInBytes, long estimatedSerializedSizeInBytes) {
        this.decodedBlock = Objects.requireNonNull(decodedBlock, "decodedBlock is null");
        this.children = Objects.requireNonNull(children, "children is null");
        this.retainedSizeInBytes = decodedBlockRetainedSizeInBytes + (long)INSTANCE_SIZE;
        this.estimatedSerializedSizeInBytes = estimatedSerializedSizeInBytes;
    }

    public Object getDecodedBlock() {
        return this.decodedBlock;
    }

    public List<DecodedBlockNode> getChildren() {
        return this.children;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getEstimatedSerializedSizeInBytes() {
        return this.estimatedSerializedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DecodedBlockNode{");
        sb.append("decodedBlock=").append(this.decodedBlock.toString()).append(",");
        sb.append("childrenCount=").append(this.children.size()).append(",");
        for (int i = 0; i < this.children.size(); ++i) {
            sb.append("fieldBuffer_").append(i).append("=").append(this.children.get(i).toString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

