/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.function.CodegenScalarFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;

public final class MapFilterFunction {
    private MapFilterFunction() {
    }

    @CodegenScalarFunction(value="map_filter", deterministic=false)
    @Description(value="return map containing entries that match the given predicate")
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,V)")
    public static MethodHandle mapFilter(@SqlType(value="map(K,V)") Type inputType, @SqlType(value="function(K,V,boolean)") Type filter) {
        MapType mapType = (MapType)inputType;
        CallSiteBinder binder = new CallSiteBinder();
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        Class keyJavaType = Primitives.wrap((Class)keyType.getJavaType());
        Class valueJavaType = Primitives.wrap((Class)valueType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("MapFilter"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", BinaryFunctionInterface.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "filter", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable mapBlockBuilder = scope.declareVariable(BlockBuilder.class, "mapBlockBuilder");
        Variable singleMapBlockWriter = scope.declareVariable(BlockBuilder.class, "singleMapBlockWriter");
        Variable keyElement = scope.declareVariable(keyJavaType, "keyElement");
        Variable valueElement = scope.declareVariable(valueJavaType, "valueElement");
        Variable keep = scope.declareVariable(Boolean.class, "keep");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)mapBlockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, (Type)mapType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)0)})));
        body.append((BytecodeNode)singleMapBlockWriter.set(mapBlockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock loadKeyElement = !keyType.equals(UnknownType.UNKNOWN) ? new BytecodeBlock().append((BytecodeNode)keyElement.set(keySqlType.getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(keyJavaType))) : new BytecodeBlock().append((BytecodeNode)keyElement.set(BytecodeExpressions.constantNull((Class)keyJavaType)));
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        Object loadValueElement = !valueType.equals(UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))})).ifTrue((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType))).ifFalse((BytecodeNode)valueElement.set(valueSqlType.getValue((BytecodeExpression)block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))).cast(valueJavaType))) : new BytecodeBlock().append((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType)));
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)2)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadKeyElement).append((BytecodeNode)loadValueElement).append((BytecodeNode)keep.set(function.invoke("apply", Object.class, new BytecodeExpression[]{keyElement.cast(Object.class), valueElement.cast(Object.class)}).cast(Boolean.class))).append((BytecodeNode)new IfStatement("if (keep != null && keep) ...", new Object[0]).condition((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.notEqual((BytecodeExpression)keep, (BytecodeExpression)BytecodeExpressions.constantNull(Boolean.class)), (BytecodeExpression)keep.cast(Boolean.TYPE))).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)keySqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, position, singleMapBlockWriter})).append((BytecodeNode)valueSqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1)), singleMapBlockWriter}))))));
        body.append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, (Type)mapType).invoke("getObject", Object.class, new BytecodeExpression[]{mapBlockBuilder.cast(Block.class), BytecodeExpressions.subtract((BytecodeExpression)mapBlockBuilder.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.constantInt((int)1))}).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), MapFilterFunction.class.getClassLoader());
        return Reflection.methodHandle(generatedClass, "filter", Block.class, BinaryFunctionInterface.class);
    }
}

