/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.discovery.client.Announcer;
import com.facebook.airlift.discovery.client.DiscoveryModule;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.event.client.HttpEventModule;
import com.facebook.airlift.event.client.JsonEventModule;
import com.facebook.airlift.http.server.HttpServerModule;
import com.facebook.airlift.jaxrs.JaxrsModule;
import com.facebook.airlift.jmx.JmxHttpModule;
import com.facebook.airlift.jmx.JmxModule;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.json.smile.SmileModule;
import com.facebook.airlift.log.LogJmxModule;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeModule;
import com.facebook.airlift.tracetoken.TraceTokenModule;
import com.facebook.drift.server.DriftServer;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.presto.dispatcher.QueryPrerequisitesManager;
import com.facebook.presto.dispatcher.QueryPrerequisitesManagerModule;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.eventlistener.EventListenerModule;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.warnings.WarningCollectorModule;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.StaticCatalogStore;
import com.facebook.presto.metadata.StaticFunctionNamespaceStore;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AccessControlModule;
import com.facebook.presto.server.GracefulShutdownModule;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoSystemRequirements;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ServerMainModule;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.ServerSecurityModule;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.storage.TempStorageModule;
import com.facebook.presto.tracing.TracerProviderManager;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManager;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManagerModule;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManagerModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    private final SqlParserOptions sqlParserOptions;

    public static void main(String[] args) {
        new PrestoServer().run();
    }

    public PrestoServer() {
        this(new SqlParserOptions());
    }

    public PrestoServer(SqlParserOptions sqlParserOptions) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
    }

    @Override
    public void run() {
        PrestoSystemRequirements.verifyJvmRequirements();
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        Logger log = Logger.get(PrestoServer.class);
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), ConditionalModule.installModuleIf(FeaturesConfig.class, FeaturesConfig::isJsonSerdeCodeGenerationEnabled, binder -> JsonBinder.jsonBinder((Binder)binder).addModuleBinding().to(AfterburnerModule.class)), new SmileModule(), new JaxrsModule(true), new MBeanModule(), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new JsonEventModule(), new HttpEventModule(), new ServerSecurityModule(), new AccessControlModule(), new EventListenerModule(), new ServerMainModule(this.sqlParserOptions), new GracefulShutdownModule(), new WarningCollectorModule(), new TempStorageModule(), new QueryPrerequisitesManagerModule(), new NodeTtlFetcherManagerModule(), new ClusterTtlProviderManagerModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.initialize();
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ServerConfig serverConfig = (ServerConfig)injector.getInstance(ServerConfig.class);
            if (!serverConfig.isResourceManager()) {
                ((StaticCatalogStore)injector.getInstance(StaticCatalogStore.class)).loadCatalogs();
            }
            PrestoServer.updateConnectorIds((Announcer)injector.getInstance(Announcer.class), (CatalogManager)injector.getInstance(CatalogManager.class), (ServerConfig)injector.getInstance(ServerConfig.class), (NodeSchedulerConfig)injector.getInstance(NodeSchedulerConfig.class));
            PrestoServer.updateThriftServerPort((Announcer)injector.getInstance(Announcer.class), (DriftServer)injector.getInstance(DriftServer.class));
            ((StaticFunctionNamespaceStore)injector.getInstance(StaticFunctionNamespaceStore.class)).loadFunctionNamespaceManagers();
            ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager();
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            if (!serverConfig.isResourceManager()) {
                ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
            }
            ((PasswordAuthenticatorManager)injector.getInstance(PasswordAuthenticatorManager.class)).loadPasswordAuthenticator();
            ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadConfiguredEventListener();
            ((TempStorageManager)injector.getInstance(TempStorageManager.class)).loadTempStorages();
            ((QueryPrerequisitesManager)injector.getInstance(QueryPrerequisitesManager.class)).loadQueryPrerequisites();
            ((NodeTtlFetcherManager)injector.getInstance(NodeTtlFetcherManager.class)).loadNodeTtlFetcher();
            ((ClusterTtlProviderManager)injector.getInstance(ClusterTtlProviderManager.class)).loadClusterTtlProvider();
            ((TracerProviderManager)injector.getInstance(TracerProviderManager.class)).loadTracerProvider();
            this.startAssociatedProcesses(injector);
            ((Announcer)injector.getInstance(Announcer.class)).start();
            log.info("======== SERVER STARTED ========");
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    protected void startAssociatedProcesses(Injector injector) {
    }

    private static void updateConnectorIds(Announcer announcer, CatalogManager metadata, ServerConfig serverConfig, NodeSchedulerConfig schedulerConfig) {
        ServiceAnnouncement announcement = PrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        String property = Strings.nullToEmpty((String)((String)announcement.getProperties().get("connectorIds")));
        List values = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property);
        LinkedHashSet connectorIds = new LinkedHashSet(values);
        if (connectorIds.isEmpty()) {
            List<Catalog> catalogs = metadata.getCatalogs();
            if (serverConfig.isCoordinator() && !schedulerConfig.isIncludeCoordinator()) {
                catalogs.stream().map(Catalog::getConnectorId).filter(connectorId -> connectorId.getCatalogName().equals("jmx")).map(Object::toString).forEach(connectorIds::add);
            } else {
                catalogs.stream().map(Catalog::getConnectorId).map(Object::toString).forEach(connectorIds::add);
            }
        }
        ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement((String)announcement.getType());
        for (Map.Entry entry : announcement.getProperties().entrySet()) {
            if (((String)entry.getKey()).equals("connectorIds")) continue;
            builder.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        builder.addProperty("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(builder.build());
    }

    private static void updateThriftServerPort(Announcer announcer, DriftServer driftServer) {
        ServiceAnnouncement announcement = PrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        driftServer.start();
        int thriftPort = ((DriftNettyServerTransport)driftServer.getServerTransport()).getPort();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        properties.put("thriftServerPort", String.valueOf(thriftPort));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new IllegalArgumentException("Presto announcement not found: " + announcements);
    }
}

