/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public final class QueryResourceUtil {
    private static final Logger log = Logger.get(QueryResourceUtil.class);
    private static final JsonCodec<SqlFunctionId> SQL_FUNCTION_ID_JSON_CODEC = JsonCodec.jsonCodec(SqlFunctionId.class);
    private static final JsonCodec<SqlInvokedFunction> SQL_INVOKED_FUNCTION_JSON_CODEC = JsonCodec.jsonCodec(SqlInvokedFunction.class);

    private QueryResourceUtil() {
    }

    public static Response toResponse(Query query, QueryResults queryResults, boolean compressionEnabled) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetCatalog().ifPresent(catalog -> response.header("X-Presto-Set-Catalog", catalog));
        query.getSetSchema().ifPresent(schema -> response.header("X-Presto-Set-Schema", schema));
        query.getSetSessionProperties().forEach((key, value) -> response.header("X-Presto-Set-Session", (Object)(key + '=' + QueryResourceUtil.urlEncode(value))));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getSetRoles().forEach((key, value) -> response.header("X-Presto-Set-Role", (Object)(key + '=' + QueryResourceUtil.urlEncode(value.toString()))));
        for (Map.Entry<String, String> entry : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = QueryResourceUtil.urlEncode(entry.getKey());
            String encodedValue = QueryResourceUtil.urlEncode(entry.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + '=' + encodedValue));
        }
        for (String string : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)QueryResourceUtil.urlEncode(string));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        if (!compressionEnabled) {
            response.encoding("identity");
        }
        for (Map.Entry entry : query.getAddedSessionFunctions().entrySet()) {
            response.header("X-Presto-Added-Session-Functions", (Object)String.format("%s=%s", QueryResourceUtil.urlEncode(SQL_FUNCTION_ID_JSON_CODEC.toJson(entry.getKey())), QueryResourceUtil.urlEncode(SQL_INVOKED_FUNCTION_JSON_CODEC.toJson(entry.getValue()))));
        }
        for (SqlFunctionId sqlFunctionId : query.getRemovedSessionFunctions()) {
            response.header("X-Presto-Removed-Session-Function", (Object)QueryResourceUtil.urlEncode(SQL_FUNCTION_ID_JSON_CODEC.toJson((Object)sqlFunctionId)));
        }
        return response.build();
    }

    public static Response toResponse(Query query, QueryResults queryResults, String xPrestoPrefixUri, boolean compressionEnabled) {
        QueryResults resultsClone = new QueryResults(queryResults.getId(), QueryResourceUtil.prependUri(queryResults.getInfoUri(), xPrestoPrefixUri), QueryResourceUtil.prependUri(queryResults.getPartialCancelUri(), xPrestoPrefixUri), QueryResourceUtil.prependUri(queryResults.getNextUri(), xPrestoPrefixUri), queryResults.getColumns(), queryResults.getData(), queryResults.getStats(), queryResults.getError(), queryResults.getWarnings(), queryResults.getUpdateType(), queryResults.getUpdateCount());
        return QueryResourceUtil.toResponse(query, resultsClone, compressionEnabled);
    }

    public static void abortIfPrefixUrlInvalid(String xPrestoPrefixUrl) {
        if (xPrestoPrefixUrl != null) {
            try {
                URL uRL = new URL(xPrestoPrefixUrl);
            }
            catch (MalformedURLException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"X-Presto-Prefix-Url is not a valid URL").build());
            }
        }
    }

    public static URI prependUri(URI backendUri, String xPrestoPrefixUrl) {
        if (!Strings.isNullOrEmpty((String)xPrestoPrefixUrl) && backendUri != null) {
            String encodedBackendUri = Base64.getUrlEncoder().encodeToString(backendUri.toASCIIString().getBytes());
            try {
                return new URI(xPrestoPrefixUrl + encodedBackendUri);
            }
            catch (URISyntaxException e) {
                log.error((Throwable)e, "Unable to add Proxy Prefix to URL");
            }
        }
        return backendUri;
    }

    public static StatementStats toStatementStats(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
        HashSet<String> globalUniqueNodes = new HashSet<String>();
        StageStats rootStageStats = QueryResourceUtil.toStageStats(outputStage, globalUniqueNodes);
        return StatementStats.builder().setState(queryInfo.getState().toString()).setWaitingForPrerequisites(queryInfo.getState() == QueryState.WAITING_FOR_PREREQUISITES).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(globalUniqueNodes.size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setWaitingForPrerequisitesTimeMillis(queryStats.getWaitingForPrerequisitesTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setPeakMemoryBytes(queryStats.getPeakUserMemoryReservation().toBytes()).setPeakTotalMemoryBytes(queryStats.getPeakTotalMemoryReservation().toBytes()).setPeakTaskTotalMemoryBytes(queryStats.getPeakTaskTotalMemory().toBytes()).setSpilledBytes(queryStats.getSpilledDataSize().toBytes()).setRootStage(rootStageStats).setRuntimeStats(queryStats.getRuntimeStats()).build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static StageStats toStageStats(StageInfo stageInfo, Set<String> globalUniqueNodeIds) {
        if (stageInfo == null) {
            return null;
        }
        StageExecutionInfo currentStageExecutionInfo = stageInfo.getLatestAttemptExecutionInfo();
        StageExecutionStats stageExecutionStats = currentStageExecutionInfo.getStats();
        StageStats.Builder builder = StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(currentStageExecutionInfo.getState().toString()).setDone(currentStageExecutionInfo.getState().isDone()).setTotalSplits(stageExecutionStats.getTotalDrivers()).setQueuedSplits(stageExecutionStats.getQueuedDrivers()).setRunningSplits(stageExecutionStats.getRunningDrivers() + stageExecutionStats.getBlockedDrivers()).setCompletedSplits(stageExecutionStats.getCompletedDrivers()).setCpuTimeMillis(stageExecutionStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageExecutionStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageExecutionStats.getRawInputPositions()).setProcessedBytes(stageExecutionStats.getRawInputDataSize().toBytes()).setNodes(QueryResourceUtil.countStageAndAddGlobalUniqueNodes(currentStageExecutionInfo.getTasks(), globalUniqueNodeIds));
        List<StageInfo> subStages = stageInfo.getSubStages();
        if (subStages.isEmpty()) {
            builder.setSubStages((List)ImmutableList.of());
        } else {
            ImmutableList.Builder subStagesBuilder = ImmutableList.builderWithExpectedSize((int)subStages.size());
            for (StageInfo subStage : subStages) {
                subStagesBuilder.add((Object)QueryResourceUtil.toStageStats(subStage, globalUniqueNodeIds));
            }
            builder.setSubStages((List)subStagesBuilder.build());
        }
        return builder.build();
    }

    private static int countStageAndAddGlobalUniqueNodes(List<TaskInfo> tasks, Set<String> globalUniqueNodes) {
        HashSet stageUniqueNodes = Sets.newHashSetWithExpectedSize((int)tasks.size());
        for (TaskInfo task : tasks) {
            String nodeId = task.getNodeId();
            stageUniqueNodes.add(nodeId);
            globalUniqueNodes.add(nodeId);
        }
        return stageUniqueNodes.size();
    }
}

