/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Optimizer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanChecker planChecker;
    private final Session session;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final VariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final WarningCollector warningCollector;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final boolean explain;

    public Optimizer(Session session, Metadata metadata, List<PlanOptimizer> planOptimizers, PlanChecker planChecker, SqlParser sqlParser, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, StatsCalculator statsCalculator, CostCalculator costCalculator, boolean explain) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.explain = explain;
    }

    public Plan validateAndOptimizePlan(PlanNode root, PlanStage stage) {
        this.planChecker.validateIntermediatePlan(root, this.session, this.metadata, this.sqlParser, TypeProvider.viewOf(this.variableAllocator.getVariables()), this.warningCollector);
        boolean enableVerboseRuntimeStats = SystemSessionProperties.isVerboseRuntimeStatsEnabled(this.session);
        if (stage.ordinal() >= PlanStage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_PLANNING_TIMEOUT, String.format("The query optimizer exceeded the timeout of %s.", SystemSessionProperties.getQueryAnalyzerTimeout(this.session).toString()));
                }
                long start = System.nanoTime();
                root = optimizer.optimize(root, this.session, TypeProvider.viewOf(this.variableAllocator.getVariables()), this.variableAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
                if (!enableVerboseRuntimeStats) continue;
                this.session.getRuntimeStats().addMetricValue(String.format("optimizer%sTimeNanos", optimizer.getClass().getSimpleName()), RuntimeUnit.NANO, System.nanoTime() - start);
            }
        }
        if (stage.ordinal() >= PlanStage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planChecker.validateFinalPlan(root, this.session, this.metadata, this.sqlParser, TypeProvider.viewOf(this.variableAllocator.getVariables()), this.warningCollector);
        }
        TypeProvider types = TypeProvider.viewOf(this.variableAllocator.getVariables());
        return new Plan(root, types, this.computeStats(root, types));
    }

    private StatsAndCosts computeStats(PlanNode root, TypeProvider types) {
        if (this.explain || SystemSessionProperties.isPrintStatsForNonJoinQuery(this.session) || PlanNodeSearcher.searchFrom(root).where(node -> node instanceof JoinNode || node instanceof SemiJoinNode).matches()) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session);
            return StatsAndCosts.create(root, statsProvider, costProvider);
        }
        return StatsAndCosts.empty();
    }

    public static enum PlanStage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

