/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.analyzer.AnalyzerContext;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.QueryAnalysis;
import com.facebook.presto.spi.analyzer.QueryAnalyzer;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.BuiltInAnalyzerContext;
import com.facebook.presto.sql.analyzer.BuiltInQueryAnalysis;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.analyzer.ForMetadataExtractor;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class BuiltInQueryAnalyzer
implements QueryAnalyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final Optional<QueryExplainer> queryExplainer;
    private final ExecutorService metadataExtractorExecutor;

    @Inject
    public BuiltInQueryAnalyzer(Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, @ForMetadataExtractor ExecutorService metadataExtractorExecutor) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.metadataExtractorExecutor = Objects.requireNonNull(metadataExtractorExecutor, "metadataExtractorExecutor is null");
    }

    public static BuiltInAnalyzerContext getBuiltInAnalyzerContext(MetadataResolver metadataResolver, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, Session session) {
        return new BuiltInAnalyzerContext(metadataResolver, idAllocator, variableAllocator, session);
    }

    public QueryAnalysis analyze(AnalyzerContext analyzerContext, PreparedQuery preparedQuery) {
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Preconditions.checkState((boolean)(analyzerContext instanceof BuiltInAnalyzerContext), (Object)"analyzerContext should be an instance of BuiltInAnalyzerContext");
        Preconditions.checkState((boolean)(preparedQuery instanceof BuiltInQueryPreparer.BuiltInPreparedQuery), (String)"Unsupported prepared query type: %s", (Object)preparedQuery.getClass().getSimpleName());
        BuiltInQueryPreparer.BuiltInPreparedQuery builtInPreparedQuery = (BuiltInQueryPreparer.BuiltInPreparedQuery)preparedQuery;
        Session session = ((BuiltInAnalyzerContext)analyzerContext).getSession();
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, this.queryExplainer, builtInPreparedQuery.getParameters(), ParameterUtils.parameterExtractor((Statement)builtInPreparedQuery.getStatement(), (List)builtInPreparedQuery.getParameters()), session.getWarningCollector(), Optional.of(this.metadataExtractorExecutor));
        Analysis analysis = analyzer.analyzeSemantic(((BuiltInQueryPreparer.BuiltInPreparedQuery)preparedQuery).getStatement(), false);
        return new BuiltInQueryAnalysis(analysis);
    }

    public PlanNode plan(AnalyzerContext analyzerContext, QueryAnalysis queryAnalysis) {
        Preconditions.checkState((boolean)(analyzerContext instanceof BuiltInAnalyzerContext), (Object)"analyzerContext should be an instance of BuiltInAnalyzerContext");
        return new LogicalPlanner(((BuiltInAnalyzerContext)analyzerContext).getSession(), analyzerContext.getIdAllocator(), this.metadata, analyzerContext.getVariableAllocator(), this.sqlParser).plan(((BuiltInQueryAnalysis)queryAnalysis).getAnalysis());
    }
}

