/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CachingPlanCanonicalInfoProvider
implements PlanCanonicalInfoProvider {
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final ObjectMapper objectMapper;
    private final Metadata metadata;

    public CachingPlanCanonicalInfoProvider(HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager, ObjectMapper objectMapper, Metadata metadata) {
        this.historyBasedStatisticsCacheManager = Objects.requireNonNull(historyBasedStatisticsCacheManager, "historyBasedStatisticsCacheManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Optional<String> hash(Session session, PlanNode planNode, PlanCanonicalizationStrategy strategy) {
        CacheKey key = new CacheKey(planNode, strategy);
        return this.loadValue(session, key).map(PlanNodeCanonicalInfo::getHash);
    }

    @Override
    public Optional<List<PlanStatistics>> getInputTableStatistics(Session session, PlanNode planNode) {
        CacheKey key = new CacheKey(planNode, (PlanCanonicalizationStrategy)PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList().get(0));
        return this.loadValue(session, key).map(PlanNodeCanonicalInfo::getInputTableStatistics);
    }

    private Optional<PlanNodeCanonicalInfo> loadValue(Session session, CacheKey key) {
        Map<CacheKey, PlanNodeCanonicalInfo> cache = this.historyBasedStatisticsCacheManager.getCanonicalInfoCache(session.getQueryId());
        PlanNodeCanonicalInfo result = cache.get(key);
        if (result != null) {
            return Optional.of(result);
        }
        CanonicalPlanGenerator.Context context = new CanonicalPlanGenerator.Context();
        key.getNode().accept((PlanVisitor)new CanonicalPlanGenerator(key.getStrategy(), this.objectMapper, session), (Object)context);
        context.getCanonicalPlans().forEach((plan, canonicalPlan) -> {
            String hashValue = this.hashCanonicalPlan((CanonicalPlan)canonicalPlan, this.objectMapper);
            List inputTableStatistics = (List)context.getInputTables().get(plan).stream().map(table -> this.metadata.getTableStatistics(session, new TableHandle(table.getTable().getConnectorId(), table.getTable().getConnectorHandle(), table.getTable().getTransaction(), Optional.empty()), (List<ColumnHandle>)ImmutableList.copyOf(table.getAssignments().values()), (Constraint<ColumnHandle>)new Constraint(table.getCurrentConstraint()))).map(tableStatistics -> new PlanStatistics(tableStatistics.getRowCount(), tableStatistics.getTotalSize(), 1.0)).collect(ImmutableList.toImmutableList());
            cache.put(new CacheKey((PlanNode)plan, key.getStrategy()), new PlanNodeCanonicalInfo(hashValue, inputTableStatistics));
        });
        return Optional.ofNullable(cache.get(key));
    }

    @VisibleForTesting
    public long getCacheSize() {
        return this.historyBasedStatisticsCacheManager.getCanonicalInfoCache().values().stream().mapToLong(cache -> cache.size()).sum();
    }

    @VisibleForTesting
    public HistoryBasedStatisticsCacheManager getHistoryBasedStatisticsCacheManager() {
        return this.historyBasedStatisticsCacheManager;
    }

    private String hashCanonicalPlan(CanonicalPlan plan, ObjectMapper objectMapper) {
        return Hashing.sha256().hashString((CharSequence)plan.toString(objectMapper), StandardCharsets.UTF_8).toString();
    }

    public static class CacheKey {
        private final PlanNode node;
        private final PlanCanonicalizationStrategy strategy;

        public CacheKey(PlanNode node, PlanCanonicalizationStrategy strategy) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public PlanCanonicalizationStrategy getStrategy() {
            return this.strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.node == cacheKey.node && this.strategy.equals((Object)cacheKey.strategy);
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.node), this.strategy);
        }
    }
}

