/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CanonicalJoinNode
extends PlanNode {
    private final List<PlanNode> sources;
    private final JoinNode.Type type;
    private final Set<JoinNode.EquiJoinClause> criteria;
    private final Set<RowExpression> filters;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public CanonicalJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="type") JoinNode.Type type, @JsonProperty(value="criteria") Set<JoinNode.EquiJoinClause> criteria, @JsonProperty(value="filter") Set<RowExpression> filters, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables) {
        super(Optional.empty(), id, Optional.empty());
        this.sources = Objects.requireNonNull(sources, "sources is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.criteria = Objects.requireNonNull(criteria, "criteria is null");
        this.filters = Objects.requireNonNull(filters, "filters is null");
        this.outputVariables = Objects.requireNonNull(outputVariables, "outputVariables is null");
    }

    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @JsonProperty
    public JoinNode.Type getType() {
        return this.type;
    }

    @JsonProperty
    public Set<JoinNode.EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty
    public Set<RowExpression> getFilters() {
        return this.filters;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new CanonicalJoinNode(this.getId(), newChildren, this.type, this.criteria, this.filters, this.outputVariables);
    }

    @JsonProperty
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot assign canonical plan id to Canonical join node: %s", new Object[]{this}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CanonicalJoinNode that = (CanonicalJoinNode)((Object)o);
        return Objects.equals(this.sources, that.sources) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.criteria, that.criteria) && Objects.equals(this.filters, that.filters) && Objects.equals(this.outputVariables, that.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sources, this.type, this.criteria, this.filters, this.outputVariables});
    }
}

