/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.NativeExecutionNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extractInputs(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept((PlanVisitor)visitor, (Object)new Context());
        return ImmutableList.copyOf(visitor.getInputs());
    }

    private static Column createColumn(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString());
    }

    private Input createInput(TableMetadata table, TableHandle tableHandle, Set<Column> columns, Optional<TableStatistics> statistics) {
        SchemaTableName schemaTable = table.getTable();
        Optional<Object> inputMetadata = this.metadata.getInfo(this.session, tableHandle);
        return new Input(table.getConnectorId(), schemaTable.getSchemaName(), schemaTable.getTableName(), inputMetadata, (List<Column>)ImmutableList.copyOf(columns), statistics, "");
    }

    private static class Context {
        private boolean extractStatistics;

        public boolean isExtractStatistics() {
            return this.extractStatistics;
        }

        public void setExtractStatistics(boolean extractStatistics) {
            this.extractStatistics = extractStatistics;
        }
    }

    private class Visitor
    extends InternalPlanVisitor<Void, Context> {
        private final ImmutableSet.Builder<Input> inputs = ImmutableSet.builder();

        private Visitor() {
        }

        public Set<Input> getInputs() {
            return this.inputs.build();
        }

        @Override
        public Void visitJoin(JoinNode node, Context context) {
            context.setExtractStatistics(true);
            this.visitPlan((PlanNode)node, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Context context) {
            context.setExtractStatistics(true);
            this.visitPlan((PlanNode)node, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Context context) {
            context.setExtractStatistics(true);
            this.visitPlan((PlanNode)node, context);
            return null;
        }

        public Void visitTableScan(TableScanNode node, Context context) {
            TableHandle tableHandle = node.getTable();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            List desiredColumns = (List)node.getAssignments().values().stream().collect(ImmutableList.toImmutableList());
            Optional<Object> statistics = Optional.empty();
            if (context.isExtractStatistics()) {
                Constraint constraint = new Constraint(node.getCurrentConstraint());
                statistics = Optional.of(InputExtractor.this.metadata.getTableStatistics(InputExtractor.this.session, tableHandle, desiredColumns, (Constraint<ColumnHandle>)constraint));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle), tableHandle, columns, statistics));
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Context context) {
            TableHandle tableHandle = node.getTableHandle();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            List desiredColumns = (List)node.getAssignments().values().stream().collect(ImmutableList.toImmutableList());
            Optional<Object> statistics = Optional.empty();
            if (context.isExtractStatistics()) {
                Constraint constraint = new Constraint(node.getCurrentConstraint());
                statistics = Optional.of(InputExtractor.this.metadata.getTableStatistics(InputExtractor.this.session, tableHandle, desiredColumns, (Constraint<ColumnHandle>)constraint));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle), tableHandle, columns, statistics));
            return null;
        }

        @Override
        public Void visitNativeExecution(NativeExecutionNode node, Context context) {
            node.getSubPlan().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        public Void visitPlan(PlanNode node, Context context) {
            for (PlanNode child : node.getSources()) {
                child.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }
    }
}

