/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.DenyAllAccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateExpressionsUtil {
    private TranslateExpressionsUtil() {
    }

    public static RowExpression toRowExpression(Expression expression, Metadata metadata, Session session, SqlParser sqlParser, VariableAllocator variableAllocator, Analysis analysis, SqlToRowExpressionTranslator.Context context) {
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build();
        ExpressionAnalyzer.analyzeExpression(session, metadata, (AccessControl)new DenyAllAccessControl(), sqlParser, scope, TypeProvider.viewOf(variableAllocator.getVariables()), analysis, expression, WarningCollector.NOOP, analysis.getTypes()).getExpressionTypes();
        return TranslateExpressionsUtil.toRowExpression(expression, metadata, session, analysis.getTypes(), context);
    }

    public static RowExpression toRowExpression(Expression expression, Metadata metadata, Session session, Map<NodeRef<Expression>, Type> types, SqlToRowExpressionTranslator.Context context) {
        return SqlToRowExpressionTranslator.translate(expression, types, (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver(), session, context);
    }

    public static Map<NodeRef<Expression>, Type> analyzeCallExpressionTypes(FunctionHandle functionHandle, List<Expression> arguments, Metadata metadata, SqlParser sqlParser, Session session, TypeProvider typeProvider) {
        List lambdaExpressions = (List)arguments.stream().filter(LambdaExpression.class::isInstance).map(LambdaExpression.class::cast).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!lambdaExpressions.isEmpty()) {
            List functionTypes = (List)metadata.getFunctionAndTypeManager().getFunctionMetadata(functionHandle).getArgumentTypes().stream().filter(typeSignature -> typeSignature.getBase().equals("function")).map(typeSignature -> (FunctionType)metadata.getFunctionAndTypeManager().getType((TypeSignature)typeSignature)).collect(ImmutableList.toImmutableList());
            JavaAggregationFunctionImplementation javaAggregateFunctionImplementation = metadata.getFunctionAndTypeManager().getJavaAggregateFunctionImplementation(functionHandle);
            if (javaAggregateFunctionImplementation instanceof BuiltInAggregationFunctionImplementation) {
                List<Class> lambdaInterfaces = ((BuiltInAggregationFunctionImplementation)javaAggregateFunctionImplementation).getLambdaInterfaces();
                Verify.verify((lambdaExpressions.size() == functionTypes.size() ? 1 : 0) != 0);
                Verify.verify((lambdaExpressions.size() == lambdaInterfaces.size() ? 1 : 0) != 0);
            }
            for (int i = 0; i < lambdaExpressions.size(); ++i) {
                LambdaExpression lambdaExpression = (LambdaExpression)lambdaExpressions.get(i);
                FunctionType functionType = (FunctionType)functionTypes.get(i);
                Verify.verify((lambdaExpression.getArguments().size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
                HashMap<NodeRef, Type> lambdaArgumentExpressionTypes = new HashMap<NodeRef, Type>();
                HashMap<String, Type> lambdaArgumentSymbolTypes = new HashMap<String, Type>();
                for (int j = 0; j < lambdaExpression.getArguments().size(); ++j) {
                    LambdaArgumentDeclaration argument = (LambdaArgumentDeclaration)lambdaExpression.getArguments().get(j);
                    Type type = (Type)functionType.getArgumentTypes().get(j);
                    lambdaArgumentExpressionTypes.put(NodeRef.of((Node)argument), type);
                    lambdaArgumentSymbolTypes.put(argument.getName().getValue(), type);
                }
                builder.put((Object)NodeRef.of((Node)lambdaExpression), (Object)functionType).putAll(lambdaArgumentExpressionTypes).putAll(ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, TypeProvider.copyOf(lambdaArgumentSymbolTypes), lambdaExpression.getBody(), Collections.emptyMap(), WarningCollector.NOOP));
            }
        }
        for (Expression argument : arguments) {
            if (argument instanceof LambdaExpression) continue;
            builder.putAll(TranslateExpressionsUtil.analyze(argument, metadata, sqlParser, session, typeProvider));
        }
        return builder.build();
    }

    private static Map<NodeRef<Expression>, Type> analyze(Expression expression, Metadata metadata, SqlParser sqlParser, Session session, TypeProvider typeProvider) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, typeProvider, expression, Collections.emptyMap(), WarningCollector.NOOP);
    }
}

