/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.NativeExecutionNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Plans {
    public static PlanNode resolveGroupReferences(PlanNode node, Lookup lookup) {
        Objects.requireNonNull(node, "node is null");
        return (PlanNode)node.accept((PlanVisitor)new ResolvingVisitor(lookup), null);
    }

    private Plans() {
    }

    private static class ResolvingVisitor
    extends InternalPlanVisitor<PlanNode, Void> {
        private final Lookup lookup;

        public ResolvingVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            List children = node.getSources().stream().map(child -> (PlanNode)child.accept((PlanVisitor)this, (Object)context)).collect(Collectors.toList());
            return node.replaceChildren(children);
        }

        @Override
        public PlanNode visitGroupReference(GroupReference node, Void context) {
            return (PlanNode)this.lookup.resolve(node).accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public PlanNode visitNativeExecution(NativeExecutionNode node, Void context) {
            node.getSubPlan().accept((PlanVisitor)this, (Object)context);
            return node;
        }
    }
}

