/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RowExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class InlineSqlFunctions
extends RowExpressionRewriteRuleSet {
    public InlineSqlFunctions(Metadata metadata, SqlParser sqlParser) {
        super(InlineSqlFunctions.createRewrite(metadata, sqlParser));
    }

    private static RowExpressionRewriteRuleSet.PlanRowExpressionRewriter createRewrite(Metadata metadata, SqlParser sqlParser) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        return (expression, context) -> InlineSqlFunctionsRewriter.rewrite(expression, context.getSession(), metadata);
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectRowExpressionRewriteRule(), this.filterRowExpressionRewriteRule(), this.joinRowExpressionRewriteRule(), this.valueRowExpressionRewriteRule());
    }

    public static class InlineSqlFunctionsRewriter {
        private InlineSqlFunctionsRewriter() {
        }

        public static RowExpression rewrite(RowExpression expression, Session session, Metadata metadata) {
            if (SystemSessionProperties.isInlineSqlFunctions(session)) {
                return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new Visitor(session, metadata), (RowExpression)expression);
            }
            return expression;
        }

        private static class Visitor
        extends RowExpressionRewriter<Void> {
            private final Session session;
            private final Metadata metadata;

            public Visitor(Session session, Metadata metadata) {
                this.session = Objects.requireNonNull(session, "session is null");
                this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            }

            public RowExpression rewriteCall(CallExpression expression, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
                ArrayList<RowExpression> rewrittenArguments = new ArrayList<RowExpression>();
                for (RowExpression argument : expression.getArguments()) {
                    rewrittenArguments.add(treeRewriter.rewrite(argument, (Object)context));
                }
                FunctionHandle functionHandle = expression.getFunctionHandle();
                FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(functionHandle);
                if (functionMetadata.getImplementationType() != FunctionImplementationType.SQL) {
                    return new CallExpression(expression.getSourceLocation(), expression.getDisplayName(), functionHandle, expression.getType(), rewrittenArguments);
                }
                return SqlFunctionUtils.getSqlFunctionRowExpression(functionMetadata, (SqlInvokedScalarFunctionImplementation)this.metadata.getFunctionAndTypeManager().getScalarFunctionImplementation(functionHandle), this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver(), this.session.getSqlFunctionProperties(), this.session.getSessionFunctions(), rewrittenArguments);
            }
        }
    }
}

