/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PruneOrderByInAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final FunctionAndTypeManager functionAndTypeManager;

    public PruneOrderByInAggregation(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!node.hasOrderings()) {
            return Rule.Result.empty();
        }
        boolean anyRewritten = false;
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
            if (!aggregation.getOrderBy().isPresent()) {
                aggregations.put(entry);
                continue;
            }
            if (this.functionAndTypeManager.getAggregateFunctionImplementation(aggregation.getFunctionHandle()).isOrderSensitive()) {
                aggregations.put(entry);
                continue;
            }
            anyRewritten = true;
            aggregations.put(entry.getKey(), (Object)new AggregationNode.Aggregation(aggregation.getCall(), aggregation.getFilter(), Optional.empty(), aggregation.isDistinct(), aggregation.getMask()));
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(node.getSourceLocation(), node.getId(), node.getSource(), (Map)aggregations.build(), node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable()));
    }
}

