/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.sql.planner.StatsEquivalentPlanNodeWithLimit;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HistoricalStatisticsEquivalentPlanMarkingOptimizer
implements PlanOptimizer {
    private static final Set<Class<? extends PlanNode>> LIMITING_NODES = ImmutableSet.of(TopNNode.class, LimitNode.class, DistinctLimitNode.class, TopNRowNumberNode.class);
    private final StatsCalculator statsCalculator;

    public HistoricalStatisticsEquivalentPlanMarkingOptimizer(StatsCalculator statsCalculator) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (!SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session) && !SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            return plan;
        }
        int historiesLimitingPlanNodeLimit = PlanNodeSearcher.searchFrom(plan).recurseOnlyWhen(node -> !LIMITING_NODES.contains(node.getClass())).where(node -> LIMITING_NODES.contains(node.getClass())).findAll().stream().mapToInt(node -> {
            int size = PlanNodeSearcher.searchFrom(node).count();
            return size * size;
        }).sum();
        if (historiesLimitingPlanNodeLimit > SystemSessionProperties.getHistoryCanonicalPlanNodeLimit(session)) {
            return plan;
        }
        plan = SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, new Context());
        this.statsCalculator.registerPlan(plan, session);
        return plan;
    }

    private static class Context {
        private final Deque<PlanNode> limits = new ArrayDeque<PlanNode>();

        private Context() {
        }

        public Deque<PlanNode> getLimits() {
            return this.limits;
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (!(node = context.defaultRewrite(node, context.get())).getStatsEquivalentPlanNode().isPresent()) {
                PlanNode nodeWithLimit = node;
                if (!context.get().getLimits().isEmpty()) {
                    nodeWithLimit = new StatsEquivalentPlanNodeWithLimit(this.idAllocator.getNextId(), node, context.get().getLimits().peekFirst());
                }
                node = node.assignStatsEquivalentPlanNode(Optional.of(nodeWithLimit));
            }
            return node;
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode(node, context);
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        private PlanNode visitLimitingNode(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().getLimits().addLast(node);
            PlanNode result = this.visitPlan(node, context);
            context.get().getLimits().removeLast();
            return result;
        }
    }
}

