/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RandomizeNullKeyInOuterJoin
implements PlanOptimizer {
    private final FunctionAndTypeManager functionAndTypeManager;

    public RandomizeNullKeyInOuterJoin(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (SystemSessionProperties.getJoinDistributionType(session).canPartition() && !SystemSessionProperties.getRandomizeOuterJoinNullKeyStrategy(session).equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.DISABLED)) {
            return SimplePlanRewriter.rewriteWith(new Rewriter(session, this.functionAndTypeManager, idAllocator, variableAllocator), plan, new HashSet());
        }
        return plan;
    }

    private static class Rewriter
    extends SimplePlanRewriter<Set<VariableReferenceExpression>> {
        private static final String LEFT_PREFIX = "l";
        private static final String RIGHT_PREFIX = "r";
        private final Session session;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final PlanNodeIdAllocator planNodeIdAllocator;
        private final VariableAllocator planVariableAllocator;
        private final Map<String, Map<VariableReferenceExpression, VariableReferenceExpression>> keyToRandomKeyMap;
        private final FeaturesConfig.RandomizeOuterJoinNullKeyStrategy strategy;

        private Rewriter(Session session, FunctionAndTypeManager functionAndTypeManager, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator planVariableAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
            this.planVariableAllocator = Objects.requireNonNull(planVariableAllocator, "planVariableAllocator is null");
            this.keyToRandomKeyMap = new HashMap<String, Map<VariableReferenceExpression, VariableReferenceExpression>>();
            this.strategy = SystemSessionProperties.getRandomizeOuterJoinNullKeyStrategy(session);
        }

        private static boolean isSupportedType(VariableReferenceExpression variable) {
            return Stream.of(BigintType.BIGINT, DateType.DATE).anyMatch(x -> x.equals((Object)variable.getType())) || variable.getType() instanceof VarcharType;
        }

        private static boolean isPartitionedJoin(JoinNode joinNode) {
            return joinNode.getDistributionType().isPresent() && joinNode.getDistributionType().get() == JoinNode.DistributionType.PARTITIONED;
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                ImmutableMultimap.Builder renameAssignmentBuilder = ImmutableMultimap.builder();
                node.getAssignments().getMap().forEach((k, v) -> {
                    if (v instanceof VariableReferenceExpression) {
                        renameAssignmentBuilder.put((Object)((VariableReferenceExpression)v), k);
                    }
                });
                ImmutableMultimap renameAssignment = renameAssignmentBuilder.build();
                context.get().addAll((Collection)context.get().stream().flatMap(x -> renameAssignment.get(x).stream()).collect(ImmutableSet.toImmutableSet()));
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitJoin(JoinNode joinNode, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (joinNode.isCrossJoin()) {
                PlanNode rewrittenLeft = context.rewrite(joinNode.getLeft(), context.get());
                PlanNode rewrittenRight = context.rewrite(joinNode.getRight(), context.get());
                ImmutableSet inputVariables = ImmutableSet.builder().addAll((Iterable)rewrittenLeft.getOutputVariables()).addAll((Iterable)rewrittenRight.getOutputVariables()).build();
                Preconditions.checkState((boolean)inputVariables.containsAll(joinNode.getOutputVariables()));
                return new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getStatsEquivalentPlanNode(), joinNode.getType(), rewrittenLeft, rewrittenRight, joinNode.getCriteria(), (List)inputVariables.stream().collect(ImmutableList.toImmutableList()), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters());
            }
            if (Stream.of(JoinNode.Type.LEFT, JoinNode.Type.RIGHT, JoinNode.Type.FULL).noneMatch(joinType -> joinType.equals((Object)joinNode.getType())) || !Rewriter.isPartitionedJoin(joinNode)) {
                PlanNode result = context.defaultRewrite(joinNode, context.get());
                return result;
            }
            PlanNode rewrittenLeft = context.rewrite(joinNode.getLeft(), context.get());
            PlanNode rewrittenRight = context.rewrite(joinNode.getRight(), context.get());
            List candidateEquiJoinClauses = (List)joinNode.getCriteria().stream().filter(x -> Rewriter.isSupportedType(x.getLeft()) && Rewriter.isSupportedType(x.getRight())).filter(x -> this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.ALWAYS) || this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN) && (((Set)context.get()).contains(x.getLeft()) || ((Set)context.get()).contains(x.getRight()))).collect(ImmutableList.toImmutableList());
            if (candidateEquiJoinClauses.isEmpty()) {
                PlanNode result = ChildReplacer.replaceChildren(joinNode, (List<PlanNode>)ImmutableList.of((Object)rewrittenLeft, (Object)rewrittenRight));
                if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                    Preconditions.checkState((boolean)(result instanceof JoinNode));
                    this.updateCandidates((JoinNode)result, context);
                }
                return result;
            }
            List leftJoinKeys = (List)candidateEquiJoinClauses.stream().map(x -> x.getLeft()).filter(x -> !this.isAlreadyRandomized(rewrittenLeft, (VariableReferenceExpression)x, LEFT_PREFIX)).collect(ImmutableList.toImmutableList());
            Map<VariableReferenceExpression, RowExpression> leftKeyRandomVariableMap = this.generateRandomKeyMap(leftJoinKeys, LEFT_PREFIX);
            List rightJoinKeys = (List)candidateEquiJoinClauses.stream().map(x -> x.getRight()).filter(x -> !this.isAlreadyRandomized(rewrittenRight, (VariableReferenceExpression)x, RIGHT_PREFIX)).collect(ImmutableList.toImmutableList());
            Map<VariableReferenceExpression, RowExpression> rightKeyRandomVariableMap = this.generateRandomKeyMap(rightJoinKeys, RIGHT_PREFIX);
            ImmutableList.Builder joinClauseBuilder = ImmutableList.builder();
            List rewrittenJoinClauses = (List)candidateEquiJoinClauses.stream().map(x -> new JoinNode.EquiJoinClause(this.keyToRandomKeyMap.get(LEFT_PREFIX).get(x.getLeft()), this.keyToRandomKeyMap.get(RIGHT_PREFIX).get(x.getRight()))).collect(ImmutableList.toImmutableList());
            joinClauseBuilder.addAll((Iterable)rewrittenJoinClauses);
            List unchangedJoinClauses = (List)joinNode.getCriteria().stream().filter(x -> !candidateEquiJoinClauses.contains(x)).collect(ImmutableList.toImmutableList());
            joinClauseBuilder.addAll((Iterable)unchangedJoinClauses);
            Assignments.Builder leftAssignments = Assignments.builder();
            leftAssignments.putAll(leftKeyRandomVariableMap);
            leftAssignments.putAll((Map)rewrittenLeft.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
            Assignments.Builder rightAssignments = Assignments.builder();
            rightAssignments.putAll(rightKeyRandomVariableMap);
            rightAssignments.putAll((Map)rewrittenRight.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
            ImmutableList.Builder joinOutputBuilder = ImmutableList.builder();
            joinOutputBuilder.addAll(leftKeyRandomVariableMap.keySet());
            joinOutputBuilder.addAll(rightKeyRandomVariableMap.keySet());
            joinOutputBuilder.addAll(joinNode.getOutputVariables());
            this.session.getOptimizerInformationCollector().addInformation(new PlanOptimizerInformation(RandomizeNullKeyInOuterJoin.class.getSimpleName(), true, Optional.empty()));
            JoinNode newJoinNode = new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getStatsEquivalentPlanNode(), joinNode.getType(), (PlanNode)new ProjectNode(rewrittenLeft.getSourceLocation(), this.planNodeIdAllocator.getNextId(), rewrittenLeft, leftAssignments.build(), ProjectNode.Locality.LOCAL), (PlanNode)new ProjectNode(rewrittenRight.getSourceLocation(), this.planNodeIdAllocator.getNextId(), rewrittenRight, rightAssignments.build(), ProjectNode.Locality.LOCAL), (List<JoinNode.EquiJoinClause>)joinClauseBuilder.build(), (List<VariableReferenceExpression>)joinOutputBuilder.build(), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters());
            if (this.strategy.equals((Object)FeaturesConfig.RandomizeOuterJoinNullKeyStrategy.KEY_FROM_OUTER_JOIN)) {
                this.updateCandidates(newJoinNode, context);
            }
            return newJoinNode;
        }

        private RowExpression randomizeJoinKey(RowExpression keyExpression, String prefix) {
            int partitionCount = SystemSessionProperties.getHashPartitionCount(this.session);
            CallExpression randomNumber = Expressions.call(this.functionAndTypeManager, "random", (Type)BigintType.BIGINT, new RowExpression[]{Expressions.constant(partitionCount, (Type)BigintType.BIGINT)});
            CallExpression randomNumberVarchar = Expressions.call("CAST", this.functionAndTypeManager.lookupCast(CastType.CAST, randomNumber.getType(), (Type)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, new RowExpression[]{randomNumber});
            CallExpression concatExpression = Expressions.call(this.functionAndTypeManager, "concat", (Type)VarcharType.VARCHAR, (List<RowExpression>)ImmutableList.of((Object)Expressions.constant(Slices.utf8Slice((String)prefix), (Type)VarcharType.VARCHAR), (Object)randomNumberVarchar));
            RowExpression castToVarchar = keyExpression;
            if (!(keyExpression.getType() instanceof VarcharType)) {
                castToVarchar = Expressions.call("CAST", this.functionAndTypeManager.lookupCast(CastType.CAST, keyExpression.getType(), (Type)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, keyExpression);
            }
            return new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)castToVarchar, (Object)concatExpression));
        }

        private boolean isAlreadyRandomized(PlanNode source, VariableReferenceExpression joinKey, String prefix) {
            return this.keyToRandomKeyMap.containsKey(prefix) && this.keyToRandomKeyMap.get(prefix).containsKey(joinKey) && source.getOutputVariables().contains(this.keyToRandomKeyMap.get(prefix).get(joinKey));
        }

        private Map<VariableReferenceExpression, RowExpression> generateRandomKeyMap(List<VariableReferenceExpression> joinKeys, String prefix) {
            List randomExpressions = (List)joinKeys.stream().map(x -> this.randomizeJoinKey((RowExpression)x, prefix)).collect(ImmutableList.toImmutableList());
            List randomVariable = (List)randomExpressions.stream().map(x -> this.planVariableAllocator.newVariable(x, RandomizeNullKeyInOuterJoin.class.getSimpleName())).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((joinKeys.size() == randomVariable.size() ? 1 : 0) != 0);
            Map newKeyToRandomMap = (Map)IntStream.range(0, joinKeys.size()).boxed().collect(ImmutableMap.toImmutableMap(joinKeys::get, randomVariable::get));
            if (!this.keyToRandomKeyMap.containsKey(prefix)) {
                this.keyToRandomKeyMap.put(prefix, new HashMap());
            }
            this.keyToRandomKeyMap.get(prefix).putAll(newKeyToRandomMap);
            Map result = (Map)IntStream.range(0, randomVariable.size()).boxed().collect(ImmutableMap.toImmutableMap(randomVariable::get, randomExpressions::get));
            return result;
        }

        private void updateCandidates(JoinNode joinNode, SimplePlanRewriter.RewriteContext<Set<VariableReferenceExpression>> context) {
            if (joinNode.getType().equals((Object)JoinNode.Type.LEFT)) {
                context.get().addAll((Collection)joinNode.getOutputVariables().stream().filter(x -> joinNode.getRight().getOutputVariables().contains(x)).collect(ImmutableSet.toImmutableSet()));
            } else if (joinNode.getType().equals((Object)JoinNode.Type.RIGHT)) {
                context.get().addAll((Collection)joinNode.getOutputVariables().stream().filter(x -> joinNode.getLeft().getOutputVariables().contains(x)).collect(ImmutableSet.toImmutableSet()));
            } else {
                Preconditions.checkState((boolean)joinNode.getType().equals((Object)JoinNode.Type.FULL));
                context.get().addAll(joinNode.getOutputVariables());
            }
        }
    }
}

