/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NativeExecutionNode
extends InternalPlanNode {
    private final PlanNode subPlan;

    @JsonCreator
    public NativeExecutionNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="subPlan") PlanNode subPlan) {
        this(sourceLocation, id, Optional.empty(), subPlan);
    }

    public NativeExecutionNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode subPlan) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.subPlan = Objects.requireNonNull(subPlan, "subPlan is null");
    }

    public NativeExecutionNode(PlanNode subPlan) {
        this(subPlan.getSourceLocation(), subPlan.getId(), subPlan.getStatsEquivalentPlanNode(), subPlan);
    }

    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.subPlan.getOutputVariables();
    }

    @JsonProperty
    public PlanNode getSubPlan() {
        return this.subPlan;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        throw new UnsupportedOperationException("replaceChildren is not supported by NativeExecutionNode");
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new NativeExecutionNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.subPlan.assignStatsEquivalentPlanNode(statsEquivalentPlanNode));
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitNativeExecution(this, context);
    }
}

