/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RowNumberNode
extends InternalPlanNode {
    private final PlanNode source;
    private final List<VariableReferenceExpression> partitionBy;
    private final Optional<Integer> maxRowCountPerPartition;
    private final VariableReferenceExpression rowNumberVariable;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public RowNumberNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<VariableReferenceExpression> partitionBy, @JsonProperty(value="rowNumberVariable") VariableReferenceExpression rowNumberVariable, @JsonProperty(value="maxRowCountPerPartition") Optional<Integer> maxRowCountPerPartition, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        this(sourceLocation, id, Optional.empty(), source, partitionBy, rowNumberVariable, maxRowCountPerPartition, hashVariable);
    }

    public RowNumberNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, List<VariableReferenceExpression> partitionBy, VariableReferenceExpression rowNumberVariable, Optional<Integer> maxRowCountPerPartition, Optional<VariableReferenceExpression> hashVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(partitionBy, "partitionBy is null");
        Objects.requireNonNull(rowNumberVariable, "rowNumberVariable is null");
        Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        Objects.requireNonNull(hashVariable, "hashVariable is null");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.rowNumberVariable = rowNumberVariable;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.hashVariable = hashVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables()).add((Object)this.rowNumberVariable).build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public VariableReferenceExpression getRowNumberVariable() {
        return this.rowNumberVariable;
    }

    @JsonProperty
    public Optional<Integer> getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitRowNumber(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new RowNumberNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.partitionBy, this.rowNumberVariable, this.maxRowCountPerPartition, this.hashVariable);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new RowNumberNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.partitionBy, this.rowNumberVariable, this.maxRowCountPerPartition, this.hashVariable);
    }
}

