/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

public class FragmentStatsProvider {
    private static final DataSize CACHE_SIZE = new DataSize(10.0, DataSize.Unit.MEGABYTE);
    private final Cache<QueryFragmentIdentifier, PlanNodeStatsEstimate> fragmentStatsMap = CacheBuilder.newBuilder().maximumSize(CACHE_SIZE.toBytes()).expireAfterWrite(1L, TimeUnit.DAYS).build();

    @Inject
    public FragmentStatsProvider() {
    }

    public void putStats(QueryId queryId, PlanFragmentId fragmentId, PlanNodeStatsEstimate planNodeStatsEstimate) {
        this.fragmentStatsMap.put((Object)new QueryFragmentIdentifier(queryId, fragmentId), (Object)planNodeStatsEstimate);
    }

    public void invalidateStats(QueryId queryId, int maxFragmentId) {
        IntStream.rangeClosed(0, maxFragmentId).forEach(fragmentId -> this.fragmentStatsMap.invalidate((Object)new QueryFragmentIdentifier(queryId, new PlanFragmentId(fragmentId))));
    }

    public PlanNodeStatsEstimate getStats(QueryId queryId, PlanFragmentId fragmentId) {
        PlanNodeStatsEstimate estimate = (PlanNodeStatsEstimate)this.fragmentStatsMap.getIfPresent((Object)new QueryFragmentIdentifier(queryId, fragmentId));
        return estimate == null ? PlanNodeStatsEstimate.unknown() : estimate;
    }

    public static class QueryFragmentIdentifier {
        private final QueryId queryId;
        private final PlanFragmentId planFragmentId;

        public QueryFragmentIdentifier(QueryId queryId, PlanFragmentId planFragmentId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.planFragmentId = Objects.requireNonNull(planFragmentId, "planFragmentId is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryFragmentIdentifier that = (QueryFragmentIdentifier)o;
            return this.queryId.equals((Object)that.queryId) && this.planFragmentId.equals(that.planFragmentId);
        }

        public int hashCode() {
            return Objects.hash(this.queryId, this.planFragmentId);
        }
    }
}

