/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.function.Description;
import javax.validation.constraints.Min;

public class HistoryBasedOptimizationConfig {
    private int maxLastRunsHistory = 10;
    private double historyMatchingThreshold = 0.1;

    @Min(value=1L)
    public @Min(value=1L) int getMaxLastRunsHistory() {
        return this.maxLastRunsHistory;
    }

    @Config(value="hbo.max-last-runs-history")
    @Description(value="Number of last runs for which historical stats are stored")
    public HistoryBasedOptimizationConfig setMaxLastRunsHistory(int maxLastRunsHistory) {
        this.maxLastRunsHistory = maxLastRunsHistory;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) double getHistoryMatchingThreshold() {
        return this.historyMatchingThreshold;
    }

    @Config(value="hbo.history-matching-threshold")
    @Description(value="Historical statistics are reused when input table sizes are within this threshold")
    public HistoryBasedOptimizationConfig setHistoryMatchingThreshold(double historyMatchingThreshold) {
        this.historyMatchingThreshold = historyMatchingThreshold;
        return this;
    }
}

