/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"query.max-pending-splits-per-node", "query.queue-config-file", "experimental.big-query-initial-hash-partitions", "experimental.max-concurrent-big-queries", "experimental.max-queued-big-queries", "query.remote-task.max-consecutive-error-count"})
public class QueryManagerConfig {
    private int scheduleSplitBatchSize = 1000;
    private int minScheduleSplitBatchSize = 100;
    private int maxConcurrentQueries = 1000;
    private int maxQueuedQueries = 5000;
    private int hashPartitionCount = 100;
    private String partitioningProviderCatalog = "system";
    private ExchangeMaterializationStrategy exchangeMaterializationStrategy = ExchangeMaterializationStrategy.NONE;
    private boolean useStreamingExchangeForMarkDistinct;
    private boolean enableWorkerIsolation;
    private Duration minQueryExpireAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private int maxQueryLength = 1000000;
    private int maxStageCount = 100;
    private int stageCountWarningThreshold = 50;
    private int maxTotalRunningTaskCountToKillQuery = Integer.MAX_VALUE;
    private int maxQueryRunningTaskCount = Integer.MAX_VALUE;
    private int maxTotalRunningTaskCountToNotExecuteNewQuery = Integer.MAX_VALUE;
    private double concurrencyThresholdToEnableResourceGroupRefresh = 1.0;
    private Duration resourceGroupRunTimeInfoRefreshInterval = new Duration(100.0, TimeUnit.MILLISECONDS);
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private Duration remoteTaskMaxErrorDuration = new Duration(5.0, TimeUnit.MINUTES);
    private int remoteTaskMaxCallbackThreads = 1000;
    private String queryExecutionPolicy = "all-at-once";
    private Duration queryMaxRunTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxExecutionTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxCpuTime = new Duration(1.0E9, TimeUnit.DAYS);
    private DataSize queryMaxScanRawInputBytes = DataSize.succinctDataSize((double)1000.0, (DataSize.Unit)DataSize.Unit.PETABYTE);
    private long queryMaxOutputPositions = Long.MAX_VALUE;
    private DataSize queryMaxOutputSize = DataSize.succinctDataSize((double)1000.0, (DataSize.Unit)DataSize.Unit.PETABYTE);
    private int requiredWorkers = 1;
    private Duration requiredWorkersMaxWait = new Duration(5.0, TimeUnit.MINUTES);
    private int requiredCoordinators = 1;
    private Duration requiredCoordinatorsMaxWait = new Duration(5.0, TimeUnit.MINUTES);
    private int requiredResourceManagers = 1;
    private int querySubmissionMaxThreads = Runtime.getRuntime().availableProcessors() * 2;
    private int perQueryRetryLimit;
    private Duration perQueryRetryMaxExecutionTime = new Duration(5.0, TimeUnit.MINUTES);
    private int globalQueryRetryFailureLimit = 150;
    private Duration globalQueryRetryFailureWindow = new Duration(5.0, TimeUnit.MINUTES);
    private long rateLimiterBucketMaxSize = 100L;
    private int rateLimiterCacheLimit = 1000;
    private int rateLimiterCacheWindowMinutes = 5;

    @Min(value=1L)
    public @Min(value=1L) int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinScheduleSplitBatchSize() {
        return this.minScheduleSplitBatchSize;
    }

    @Config(value="query.min-schedule-split-batch-size")
    public QueryManagerConfig setMinScheduleSplitBatchSize(int minScheduleSplitBatchSize) {
        this.minScheduleSplitBatchSize = minScheduleSplitBatchSize;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    @Deprecated
    @Config(value="query.max-concurrent-queries")
    public QueryManagerConfig setMaxConcurrentQueries(int maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @Deprecated
    @Config(value="query.max-queued-queries")
    public QueryManagerConfig setMaxQueuedQueries(int maxQueuedQueries) {
        this.maxQueuedQueries = maxQueuedQueries;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHashPartitionCount() {
        return this.hashPartitionCount;
    }

    @LegacyConfig(value={"query.initial-hash-partitions"})
    @Config(value="query.hash-partition-count")
    public QueryManagerConfig setHashPartitionCount(int hashPartitionCount) {
        this.hashPartitionCount = hashPartitionCount;
        return this;
    }

    @NotNull
    public String getPartitioningProviderCatalog() {
        return this.partitioningProviderCatalog;
    }

    @Config(value="query.partitioning-provider-catalog")
    @ConfigDescription(value="Name of the catalog providing custom partitioning")
    public QueryManagerConfig setPartitioningProviderCatalog(String partitioningProviderCatalog) {
        this.partitioningProviderCatalog = partitioningProviderCatalog;
        return this;
    }

    @NotNull
    public ExchangeMaterializationStrategy getExchangeMaterializationStrategy() {
        return this.exchangeMaterializationStrategy;
    }

    @Config(value="query.use-streaming-exchange-for-mark-distinct")
    @ConfigDescription(value="Use streaming instead of materialization with mark distinct when materialized exchange is enabled")
    public QueryManagerConfig setUseStreamingExchangeForMarkDistinct(boolean useStreamingExchangeForMarkDistinct) {
        this.useStreamingExchangeForMarkDistinct = useStreamingExchangeForMarkDistinct;
        return this;
    }

    @NotNull
    public boolean getUseStreamingExchangeForMarkDistinct() {
        return this.useStreamingExchangeForMarkDistinct;
    }

    @Config(value="query.exchange-materialization-strategy")
    @ConfigDescription(value="The exchange materialization strategy to use")
    public QueryManagerConfig setExchangeMaterializationStrategy(ExchangeMaterializationStrategy exchangeMaterializationStrategy) {
        this.exchangeMaterializationStrategy = exchangeMaterializationStrategy;
        return this;
    }

    @NotNull
    public Duration getMinQueryExpireAge() {
        return this.minQueryExpireAge;
    }

    @LegacyConfig(value={"query.max-age"})
    @Config(value="query.min-expire-age")
    @MinDuration(value="30s")
    public QueryManagerConfig setMinQueryExpireAge(Duration minQueryExpireAge) {
        this.minQueryExpireAge = minQueryExpireAge;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @Min(value=0L)
    @Max(value=1000000000L)
    public @Min(value=0L) @Max(value=1000000000L) int getMaxQueryLength() {
        return this.maxQueryLength;
    }

    @Config(value="query.max-length")
    public QueryManagerConfig setMaxQueryLength(int maxQueryLength) {
        this.maxQueryLength = maxQueryLength;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxStageCount() {
        return this.maxStageCount;
    }

    @Config(value="query.max-stage-count")
    public QueryManagerConfig setMaxStageCount(int maxStageCount) {
        this.maxStageCount = maxStageCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getStageCountWarningThreshold() {
        return this.stageCountWarningThreshold;
    }

    @Config(value="query.stage-count-warning-threshold")
    @ConfigDescription(value="Emit a warning when stage count exceeds this threshold")
    public QueryManagerConfig setStageCountWarningThreshold(int stageCountWarningThreshold) {
        this.stageCountWarningThreshold = stageCountWarningThreshold;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxTotalRunningTaskCountToKillQuery() {
        return this.maxTotalRunningTaskCountToKillQuery;
    }

    @Config(value="max-total-running-task-count-to-kill-query")
    @ConfigDescription(value="Query may be killed when running task count from all queries exceeds this threshold")
    public QueryManagerConfig setMaxTotalRunningTaskCountToKillQuery(int maxTotalRunningTaskCountToKillQuery) {
        this.maxTotalRunningTaskCountToKillQuery = maxTotalRunningTaskCountToKillQuery;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxQueryRunningTaskCount() {
        return this.maxQueryRunningTaskCount;
    }

    @Config(value="experimental.max-total-running-task-count-to-not-execute-new-query")
    @ConfigDescription(value="Keep new queries in the queue if total task count exceeds this threshold")
    public QueryManagerConfig setMaxTotalRunningTaskCountToNotExecuteNewQuery(int maxTotalRunningTaskCountToNotExecuteNewQuery) {
        this.maxTotalRunningTaskCountToNotExecuteNewQuery = maxTotalRunningTaskCountToNotExecuteNewQuery;
        return this;
    }

    public int getMaxTotalRunningTaskCountToNotExecuteNewQuery() {
        return this.maxTotalRunningTaskCountToNotExecuteNewQuery;
    }

    @Config(value="max-query-running-task-count")
    @ConfigDescription(value="Maximal allowed running task for single query only if max-total-running-task-count-to-kill-query is violated")
    public QueryManagerConfig setMaxQueryRunningTaskCount(int maxQueryRunningTaskCount) {
        this.maxQueryRunningTaskCount = maxQueryRunningTaskCount;
        return this;
    }

    public Double getConcurrencyThresholdToEnableResourceGroupRefresh() {
        return this.concurrencyThresholdToEnableResourceGroupRefresh;
    }

    @Config(value="concurrency-threshold-to-enable-resource-group-refresh")
    @ConfigDescription(value="Resource group concurrency threshold percentage, once crossed new queries won't run till updated resource group info comes from resource manager")
    public QueryManagerConfig setConcurrencyThresholdToEnableResourceGroupRefresh(double concurrencyThresholdToEnableResourceGroupRefresh) {
        this.concurrencyThresholdToEnableResourceGroupRefresh = concurrencyThresholdToEnableResourceGroupRefresh;
        return this;
    }

    public Duration getResourceGroupRunTimeInfoRefreshInterval() {
        return this.resourceGroupRunTimeInfoRefreshInterval;
    }

    @Config(value="resource-group-runtimeinfo-refresh-interval")
    @ConfigDescription(value="How frequently to poll the resource manager for resource group updates")
    public QueryManagerConfig setResourceGroupRunTimeInfoRefreshInterval(Duration resourceGroupRunTimeInfoRefreshInterval) {
        this.resourceGroupRunTimeInfoRefreshInterval = resourceGroupRunTimeInfoRefreshInterval;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @Deprecated
    public Duration getRemoteTaskMinErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Deprecated
    @Config(value="query.remote-task.min-error-duration")
    public QueryManagerConfig setRemoteTaskMinErrorDuration(Duration remoteTaskMinErrorDuration) {
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getRemoteTaskMaxErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Config(value="query.remote-task.max-error-duration")
    public QueryManagerConfig setRemoteTaskMaxErrorDuration(Duration remoteTaskMaxErrorDuration) {
        this.remoteTaskMaxErrorDuration = remoteTaskMaxErrorDuration;
        return this;
    }

    @NotNull
    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    @Config(value="query.max-run-time")
    public QueryManagerConfig setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxExecutionTime() {
        return this.queryMaxExecutionTime;
    }

    @Config(value="query.max-execution-time")
    public QueryManagerConfig setQueryMaxExecutionTime(Duration queryMaxExecutionTime) {
        this.queryMaxExecutionTime = queryMaxExecutionTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ns")
    public Duration getQueryMaxCpuTime() {
        return this.queryMaxCpuTime;
    }

    @Config(value="query.max-cpu-time")
    public QueryManagerConfig setQueryMaxCpuTime(Duration queryMaxCpuTime) {
        this.queryMaxCpuTime = queryMaxCpuTime;
        return this;
    }

    public DataSize getQueryMaxScanRawInputBytes() {
        return this.queryMaxScanRawInputBytes;
    }

    @Config(value="query.max-scan-raw-input-bytes")
    public QueryManagerConfig setQueryMaxScanRawInputBytes(DataSize queryMaxRawInputBytes) {
        this.queryMaxScanRawInputBytes = queryMaxRawInputBytes;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getQueryMaxOutputPositions() {
        return this.queryMaxOutputPositions;
    }

    @Config(value="query.max-output-positions")
    public QueryManagerConfig setQueryMaxOutputPositions(long queryMaxOutputPositions) {
        this.queryMaxOutputPositions = queryMaxOutputPositions;
        return this;
    }

    public DataSize getQueryMaxOutputSize() {
        return this.queryMaxOutputSize;
    }

    @Config(value="query.max-output-size")
    @MinDataSize(value="1B")
    public QueryManagerConfig setQueryMaxOutputSize(DataSize queryMaxOutputSize) {
        this.queryMaxOutputSize = queryMaxOutputSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRemoteTaskMaxCallbackThreads() {
        return this.remoteTaskMaxCallbackThreads;
    }

    @Config(value="query.remote-task.max-callback-threads")
    public QueryManagerConfig setRemoteTaskMaxCallbackThreads(int remoteTaskMaxCallbackThreads) {
        this.remoteTaskMaxCallbackThreads = remoteTaskMaxCallbackThreads;
        return this;
    }

    @NotNull
    public String getQueryExecutionPolicy() {
        return this.queryExecutionPolicy;
    }

    @Config(value="query.execution-policy")
    public QueryManagerConfig setQueryExecutionPolicy(String queryExecutionPolicy) {
        this.queryExecutionPolicy = queryExecutionPolicy;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredWorkers() {
        return this.requiredWorkers;
    }

    @Config(value="query-manager.required-workers")
    @ConfigDescription(value="Minimum number of active workers that must be available before a query will start")
    public QueryManagerConfig setRequiredWorkers(int requiredWorkers) {
        this.requiredWorkers = requiredWorkers;
        return this;
    }

    @NotNull
    public Duration getRequiredWorkersMaxWait() {
        return this.requiredWorkersMaxWait;
    }

    @Config(value="query-manager.required-workers-max-wait")
    @ConfigDescription(value="Maximum time to wait for minimum number of workers before the query is failed")
    public QueryManagerConfig setRequiredWorkersMaxWait(Duration requiredWorkersMaxWait) {
        this.requiredWorkersMaxWait = requiredWorkersMaxWait;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredCoordinators() {
        return this.requiredCoordinators;
    }

    @Config(value="query-manager.experimental.required-coordinators")
    @ConfigDescription(value="Minimum number of active coordinators that must be available before a query will start")
    public QueryManagerConfig setRequiredCoordinators(int requiredCoordinators) {
        this.requiredCoordinators = requiredCoordinators;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredResourceManagers() {
        return this.requiredResourceManagers;
    }

    @Config(value="query-manager.experimental.required-resource-managers")
    @ConfigDescription(value="Minimum number of active resource managers before coordinator becomes available to take traffic")
    public QueryManagerConfig setRequiredResourceManagers(int requiredResourceManagers) {
        this.requiredResourceManagers = requiredResourceManagers;
        return this;
    }

    @NotNull
    public Duration getRequiredCoordinatorsMaxWait() {
        return this.requiredCoordinatorsMaxWait;
    }

    @Config(value="query-manager.experimental.required-coordinators-max-wait")
    @ConfigDescription(value="Maximum time to wait for minimum number of coordinators before the query is failed")
    public QueryManagerConfig setRequiredCoordinatorsMaxWait(Duration requiredCoordinatorsMaxWait) {
        this.requiredCoordinatorsMaxWait = requiredCoordinatorsMaxWait;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQuerySubmissionMaxThreads() {
        return this.querySubmissionMaxThreads;
    }

    @Config(value="query-manager.experimental.query-submission-max-threads")
    public QueryManagerConfig setQuerySubmissionMaxThreads(int querySubmissionMaxThreads) {
        this.querySubmissionMaxThreads = querySubmissionMaxThreads;
        return this;
    }

    public int getPerQueryRetryLimit() {
        return this.perQueryRetryLimit;
    }

    @Config(value="per-query-retry-limit")
    @ConfigDescription(value="Per-query retry limit due to communication failures")
    public QueryManagerConfig setPerQueryRetryLimit(int perQueryRetryLimit) {
        this.perQueryRetryLimit = perQueryRetryLimit;
        return this;
    }

    public Duration getPerQueryRetryMaxExecutionTime() {
        return this.perQueryRetryMaxExecutionTime;
    }

    @Config(value="per-query-retry-max-execution-time")
    @ConfigDescription(value="max per-query execution time limit allowed for retry")
    public QueryManagerConfig setPerQueryRetryMaxExecutionTime(Duration perQueryRetryMaxExecutionTime) {
        this.perQueryRetryMaxExecutionTime = perQueryRetryMaxExecutionTime;
        return this;
    }

    public int getGlobalQueryRetryFailureLimit() {
        return this.globalQueryRetryFailureLimit;
    }

    @Config(value="global-query-retry-failure-limit")
    @ConfigDescription(value="A circuit breaker to stop query retry if the number of communication failures have gone over a limit")
    public QueryManagerConfig setGlobalQueryRetryFailureLimit(int globalQueryRetryFailureLimit) {
        this.globalQueryRetryFailureLimit = globalQueryRetryFailureLimit;
        return this;
    }

    public Duration getGlobalQueryRetryFailureWindow() {
        return this.globalQueryRetryFailureWindow;
    }

    @Config(value="global-query-retry-failure-window")
    @ConfigDescription(value="A circuit breaker profiling window to stop query retry if the number of communication failures have gone over a limit")
    public QueryManagerConfig setGlobalQueryRetryFailureWindow(Duration globalQueryRetryFailureWindow) {
        this.globalQueryRetryFailureWindow = globalQueryRetryFailureWindow;
        return this;
    }

    public long getRateLimiterBucketMaxSize() {
        return this.rateLimiterBucketMaxSize;
    }

    @Config(value="query-manager.rate-limiter-bucket-max-size")
    @ConfigDescription(value="rate limiter token bucket max size, number of permits per second")
    public QueryManagerConfig setRateLimiterBucketMaxSize(long rateLimiterBucketMaxSize) {
        this.rateLimiterBucketMaxSize = rateLimiterBucketMaxSize;
        return this;
    }

    public int getRateLimiterCacheLimit() {
        return this.rateLimiterCacheLimit;
    }

    @Config(value="query-manager.rate-limiter-cache-limit")
    @ConfigDescription(value="rate limiter cache size limit, used together with rateLimiterCacheWindowMinutes")
    public QueryManagerConfig setRateLimiterCacheLimit(int rateLimiterCacheLimit) {
        this.rateLimiterCacheLimit = rateLimiterCacheLimit;
        return this;
    }

    public int getRateLimiterCacheWindowMinutes() {
        return this.rateLimiterCacheWindowMinutes;
    }

    @Config(value="query-manager.rate-limiter-cache-window-minutes")
    @ConfigDescription(value="rate limiter cache window size in minutes, used together with rateLimiterCacheLimit")
    public QueryManagerConfig setRateLimiterCacheWindowMinutes(int rateLimiterCacheWindowMinutes) {
        this.rateLimiterCacheWindowMinutes = rateLimiterCacheWindowMinutes;
        return this;
    }

    public boolean isEnableWorkerIsolation() {
        return this.enableWorkerIsolation;
    }

    @Config(value="query-manager.enable-worker-isolation")
    @ConfigDescription(value="Config to enable isolating leaf and intermediate workers for query execution")
    public QueryManagerConfig setEnableWorkerIsolation(boolean enableWorkerIsolation) {
        this.enableWorkerIsolation = enableWorkerIsolation;
        return this;
    }

    public static enum ExchangeMaterializationStrategy {
        NONE,
        ALL;

    }
}

