/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.executor.TaskExecutor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class LowMemoryMonitor {
    private static final Logger log = Logger.get(LowMemoryMonitor.class);
    private final ScheduledExecutorService lowMemoryExecutor = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"low-memory-monitor-executor"));
    private final TaskExecutor taskExecutor;
    private final double threshold;
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    @Inject
    public LowMemoryMonitor(TaskExecutor taskExecutor, TaskManagerConfig taskManagerConfig) {
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.threshold = taskManagerConfig.getMemoryBasedSlowDownThreshold();
    }

    @PostConstruct
    public void start() {
        if (this.threshold < 1.0) {
            this.lowMemoryExecutor.scheduleWithFixedDelay(() -> this.checkLowMemory(), 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void stop() {
        this.lowMemoryExecutor.shutdown();
    }

    private void checkLowMemory() {
        long maxMemory;
        long memoryThreshold;
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long usedMemory = memoryUsage.getUsed();
        if (usedMemory > (memoryThreshold = (long)((double)(maxMemory = memoryUsage.getMax()) * this.threshold))) {
            if (!this.taskExecutor.isLowMemory()) {
                log.debug("Enabling Low Memory: Used: %s Max: %s Threshold: %s", new Object[]{usedMemory, maxMemory, memoryThreshold});
                this.taskExecutor.setLowMemory(true);
            }
        } else if (this.taskExecutor.isLowMemory()) {
            log.debug("Disabling Low Memory: Used: %s Max: %s Threshold: %s", new Object[]{usedMemory, maxMemory, memoryThreshold});
            this.taskExecutor.setLowMemory(false);
        }
    }
}

