/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.theta;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchAggregationState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.List;
import org.apache.datasketches.theta.Sketch;

public class ThetaSketchAggregationFunction
extends SqlAggregationFunction {
    private static final Logger log = Logger.get(ThetaSketchAggregationFunction.class);
    public static final String NAME = "sketch_theta";
    public static final ThetaSketchAggregationFunction THETA_SKETCH = new ThetaSketchAggregationFunction();
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ThetaSketchAggregationFunction.class, "output", ThetaSketchAggregationState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ThetaSketchAggregationFunction.class, "input", Type.class, ThetaSketchAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle MERGE_FUNCTION = Reflection.methodHandle(ThetaSketchAggregationFunction.class, "merge", ThetaSketchAggregationState.class, ThetaSketchAggregationState.class);

    public ThetaSketchAggregationFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"varbinary"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    public String getDescription() {
        return "calculates a theta sketch of the selected input column";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ThetaSketchAggregationFunction.class.getClassLoader());
        Type type = boundVariables.getTypeVariable("T");
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), ThetaSketchAggregationFunction.createInputParameterMetadata(type), INPUT_FUNCTION.bindTo(type), MERGE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(ThetaSketchAggregationState.class, StateCompiler.generateStateSerializer(ThetaSketchAggregationState.class, classLoader), StateCompiler.generateStateFactory(ThetaSketchAggregationState.class, classLoader))), (Type)VarbinaryType.VARBINARY);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarbinaryType.VARBINARY, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, ThetaSketchAggregationState state, Block block, int position) {
        if (block.isNull(position)) {
            return;
        }
        if (type.getJavaType().equals(Long.class) || type.getJavaType() == Long.TYPE) {
            state.getSketch().update(type.getLong(block, position));
        } else if (type.getJavaType().equals(Double.class) || type.getJavaType() == Double.TYPE) {
            state.getSketch().update(type.getDouble(block, position));
        } else if (type.getJavaType().equals(String.class) || type.getJavaType().equals(Slice.class)) {
            state.getSketch().update(type.getSlice(block, position).getBytes());
        } else {
            throw new RuntimeException("unsupported sketch column type: " + type + " (java type: " + type.getJavaType() + ")");
        }
    }

    public static void merge(ThetaSketchAggregationState state, ThetaSketchAggregationState otherState) {
        state.getSketch().union((Sketch)otherState.getSketch().getResult());
    }

    public static void output(ThetaSketchAggregationState state, BlockBuilder out) {
        Slice output = Slices.wrappedBuffer((byte[])state.getSketch().getResult().toByteArray());
        VarbinaryType.VARBINARY.writeSlice(out, output);
    }
}

