/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.theta;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchAggregationState;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;
import org.apache.datasketches.theta.Union;
import org.openjdk.jol.info.ClassLayout;

public class ThetaSketchStateFactory
implements AccumulatorStateFactory<ThetaSketchAggregationState> {
    public SingleThetaSketchState createSingleState() {
        return new SingleThetaSketchState();
    }

    public Class<? extends ThetaSketchAggregationState> getSingleStateClass() {
        return SingleThetaSketchState.class;
    }

    public ThetaSketchAggregationState createGroupedState() {
        return new GroupedThetaSketchState();
    }

    public Class<? extends ThetaSketchAggregationState> getGroupedStateClass() {
        return GroupedThetaSketchState.class;
    }

    public static final class GroupedThetaSketchState
    extends AbstractGroupedAccumulatorState
    implements ThetaSketchAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedThetaSketchState.class).instanceSize();
        private final ObjectBigArray<Union> sketches = new ObjectBigArray();

        @Override
        public Union getSketch() {
            if (this.sketches.get(this.getGroupId()) == null) {
                this.setSketch(Union.builder().buildUnion());
            }
            return (Union)this.sketches.get(this.getGroupId());
        }

        @Override
        public void setSketch(Union sketch) {
            this.sketches.set(this.getGroupId(), (Object)Objects.requireNonNull(sketch, "sketch is null"));
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.sketches.sizeOf();
        }

        public void ensureCapacity(long size) {
            this.sketches.ensureCapacity(size);
        }
    }

    public static final class SingleThetaSketchState
    implements ThetaSketchAggregationState,
    AccumulatorState {
        private Union sketch = Union.builder().buildUnion();

        @Override
        public Union getSketch() {
            return this.sketch;
        }

        @Override
        public void setSketch(Union sketch) {
            this.sketch = sketch;
        }

        public long getEstimatedSize() {
            return this.sketch.getCurrentBytes();
        }
    }
}

