/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Coercer;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.SqlPlannerContext;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.TranslateExpressionsUtil;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.SampleNodeUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, SqlPlannerContext> {
    private final Analysis analysis;
    private final VariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;
    private final SqlParser sqlParser;

    RelationPlanner(Analysis analysis, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap, Metadata metadata, Session session, SqlParser sqlParser) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.lambdaDeclarationToVariableMap = Objects.requireNonNull(lambdaDeclarationToVariableMap, "lambdaDeclarationToVariableMap is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.subqueryPlanner = new SubqueryPlanner(analysis, variableAllocator, idAllocator, lambdaDeclarationToVariableMap, metadata, session, sqlParser);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public RelationPlan process(Node node, @Nullable SqlPlannerContext context) {
        this.checkInterruption();
        return (RelationPlan)super.process(node, (Object)context);
    }

    protected RelationPlan visitTable(Table node, SqlPlannerContext context) {
        Analysis.NamedQuery namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            String cteName = node.getName().toString();
            if (namedQuery.isFromView()) {
                cteName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName()).toString();
            }
            this.session.getCteInformationCollector().addCTEReference(cteName, namedQuery.isFromView());
            RelationPlan subPlan = this.process((Node)namedQuery.getQuery(), context);
            Type[] types = (Type[])scope.getRelationType().getAllFields().stream().map(Field::getType).toArray(Type[]::new);
            RelationPlan withCoercions = this.addCoercions(subPlan, types, context);
            return new RelationPlan(withCoercions.getRoot(), scope, withCoercions.getFieldMappings());
        }
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : scope.getRelationType().getAllFields()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)node), (String)field.getName().get(), field.getType());
            outputVariablesBuilder.add((Object)variable);
            columns.put((Object)variable, (Object)this.analysis.getColumn(field));
        }
        ImmutableList outputVariables = outputVariablesBuilder.build();
        List tableConstraints = this.metadata.getTableMetadata(this.session, handle).getMetadata().getTableConstraints();
        context.incrementLeafNodes(this.session);
        TableScanNode root = new TableScanNode(ExpressionTreeUtils.getSourceLocation(node.getLocation()), this.idAllocator.getNextId(), handle, (List)outputVariables, (Map)columns.build(), tableConstraints, TupleDomain.all(), TupleDomain.all());
        return new RelationPlan((PlanNode)root, scope, (List<VariableReferenceExpression>)outputVariables);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, SqlPlannerContext context) {
        RelationPlan subPlan = this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                Field field = subPlan.getDescriptor().getFieldByIndex(i);
                if (field.isHidden()) continue;
                VariableReferenceExpression aliasedColumn = PlannerUtils.newVariable(this.variableAllocator, mappings.get(i).getSourceLocation(), field);
                assignments.put(aliasedColumn, (RowExpression)subPlan.getFieldMappings().get(i));
                newMappings.add((Object)aliasedColumn);
            }
            root = new ProjectNode(ExpressionTreeUtils.getSourceLocation(node.getLocation()), this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build(), ProjectNode.Locality.LOCAL);
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)mappings);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, SqlPlannerContext context) {
        RelationPlan subPlan = this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNodeUtil.fromType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings());
    }

    protected RelationPlan visitJoin(Join node, SqlPlannerContext context) {
        JoinNode root;
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        ImmutableList outputs;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        block31: {
            block32: {
                RelationType right;
                Object left;
                block28: {
                    RelationPlan leftPlan = this.process((Node)node.getLeft(), context);
                    Optional<Unnest> unnest = this.getUnnest(node.getRight());
                    if (unnest.isPresent()) {
                        if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                            throw SemanticExceptions.notSupportedException((Node)((Node)unnest.get()), (String)"UNNEST on other than the right side of CROSS JOIN");
                        }
                        return this.planCrossJoinUnnest(leftPlan, node, unnest.get(), context);
                    }
                    Optional<Lateral> lateral = this.getLateral(node.getRight());
                    if (lateral.isPresent()) {
                        if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                            throw SemanticExceptions.notSupportedException((Node)((Node)lateral.get()), (String)"LATERAL on other than the right side of CROSS JOIN");
                        }
                        return this.planLateralJoin(node, leftPlan, lateral.get(), context);
                    }
                    RelationPlan rightPlan = this.process((Node)node.getRight(), context);
                    if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
                        return this.planJoinUsing(node, leftPlan, rightPlan, context);
                    }
                    leftPlanBuilder = this.initializePlanBuilder(leftPlan);
                    rightPlanBuilder = this.initializePlanBuilder(rightPlan);
                    outputs = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
                    equiClauses = ImmutableList.builder();
                    complexJoinExpressions = new ArrayList<Expression>();
                    postInnerJoinConditions = new ArrayList<Expression>();
                    if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) break block28;
                    Expression criteria = this.analysis.getJoinCriteria(node);
                    left = this.analysis.getOutputDescriptor((Node)node.getLeft());
                    right = this.analysis.getOutputDescriptor((Node)node.getRight());
                    ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
                    ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
                    ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
                    for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                        block30: {
                            block29: {
                                if (!ExpressionTreeUtils.isEqualComparisonExpression(conjunct = ExpressionUtils.normalize(conjunct)) && node.getType() != Join.Type.INNER) {
                                    complexJoinExpressions.add(conjunct);
                                    continue;
                                }
                                Set<QualifiedName> dependencies = VariablesExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                                if (dependencies.stream().allMatch(arg_0 -> ((RelationType)left).canResolve(arg_0))) break block29;
                                if (!dependencies.stream().allMatch(arg_0 -> ((RelationType)right).canResolve(arg_0))) break block30;
                            }
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        if (conjunct instanceof ComparisonExpression) {
                            Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                            Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                            ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                            Set<QualifiedName> firstDependencies = VariablesExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                            Set<QualifiedName> secondDependencies = VariablesExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                            if (firstDependencies.stream().allMatch(arg_0 -> ((RelationType)left).canResolve(arg_0))) {
                                if (secondDependencies.stream().allMatch(arg_0 -> ((RelationType)right).canResolve(arg_0))) {
                                    leftComparisonExpressions.add(firstExpression);
                                    rightComparisonExpressions.add(secondExpression);
                                    joinConditionComparisonOperators.add(comparisonOperator);
                                    continue;
                                }
                            }
                            if (firstDependencies.stream().allMatch(arg_0 -> ((RelationType)right).canResolve(arg_0))) {
                                if (secondDependencies.stream().allMatch(arg_0 -> ((RelationType)left).canResolve(arg_0))) {
                                    leftComparisonExpressions.add(secondExpression);
                                    rightComparisonExpressions.add(firstExpression);
                                    joinConditionComparisonOperators.add(comparisonOperator.flip());
                                    continue;
                                }
                            }
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        complexJoinExpressions.add(conjunct);
                    }
                    leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, (Node)node, context);
                    rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, (Node)node, context);
                    leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
                    rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
                    for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                        if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                            VariableReferenceExpression leftVariable = leftPlanBuilder.translateToVariable((Expression)leftComparisonExpressions.get(i));
                            VariableReferenceExpression rightVariable = rightPlanBuilder.translateToVariable((Expression)rightComparisonExpressions.get(i));
                            equiClauses.add((Object)new JoinNode.EquiJoinClause(leftVariable, rightVariable));
                            continue;
                        }
                        Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftComparisonExpressions.get(i));
                        Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightComparisonExpressions.get(i));
                        postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), leftExpression, rightExpression));
                    }
                }
                root = new JoinNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftPlanBuilder.getRoot().getOutputVariables()).addAll((Iterable)rightPlanBuilder.getRoot().getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
                if (node.getType() == Join.Type.INNER) break block31;
                for (Expression complexExpression : complexJoinExpressions) {
                    Set<InPredicate> inPredicates = this.subqueryPlanner.collectInPredicateSubqueries(complexExpression, (Node)node);
                    if (inPredicates.isEmpty()) continue;
                    InPredicate inPredicate = (InPredicate)Iterables.getLast(inPredicates);
                    throw SemanticExceptions.notSupportedException((Node)inPredicate, (String)"IN with subquery predicate in join condition");
                }
                if (node.getType() != Join.Type.LEFT && node.getType() != Join.Type.RIGHT) break block32;
                left = this.analysis.getOutputDescriptor((Node)node.getLeft());
                right = this.analysis.getOutputDescriptor((Node)node.getRight());
                for (Expression complexJoinExpression : complexJoinExpressions) {
                    Set<QualifiedName> dependencies;
                    block34: {
                        block33: {
                            boolean noSubqueriesPresent;
                            dependencies = VariablesExtractor.extractNames(complexJoinExpression, this.analysis.getColumnReferences());
                            boolean bl = noSubqueriesPresent = this.subqueryPlanner.collectScalarSubqueries(complexJoinExpression, (Node)node).isEmpty() && this.subqueryPlanner.collectExistsSubqueries(complexJoinExpression, (Node)node).isEmpty() && this.subqueryPlanner.collectQuantifiedComparisonSubqueries(complexJoinExpression, (Node)node).isEmpty();
                            if (noSubqueriesPresent || dependencies.isEmpty()) break block33;
                            if (!dependencies.stream().anyMatch(arg_0 -> ((RelationType)left).canResolve(arg_0))) break block34;
                            if (!dependencies.stream().anyMatch(arg_0 -> ((RelationType)right).canResolve(arg_0))) break block34;
                        }
                        leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, (Collection<Expression>)ImmutableList.of((Object)complexJoinExpression), (Node)node, context);
                        continue;
                    }
                    if (node.getType() == Join.Type.LEFT) {
                        if (!dependencies.stream().allMatch(arg_0 -> ((RelationType)left).canResolve(arg_0))) {
                            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, complexJoinExpression, (Node)node, context);
                            continue;
                        }
                    }
                    leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, complexJoinExpression, (Node)node, context);
                }
                break block31;
            }
            leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, complexJoinExpressions, (Node)node, context);
        }
        RelationPlan intermediateRootRelationPlan = new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs);
        TranslationMap translationMap = new TranslationMap(intermediateRootRelationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translationMap.setFieldMappings((List<VariableReferenceExpression>)outputs);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        if (node.getType() != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            Expression rewrittenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftPlanBuilder.getRoot().getOutputVariables()).addAll((Iterable)rightPlanBuilder.getRoot().getOutputVariables()).build(), Optional.of(this.rowExpression(rewrittenFilterCondition, context)), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        }
        if (node.getType() == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, (Node)node, context);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(ExpressionTreeUtils.getSourceLocation((Node)postInnerJoinCriteria), this.idAllocator.getNextId(), (PlanNode)root, this.rowExpression(postInnerJoinCriteria, context));
            }
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs);
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right, SqlPlannerContext context) {
        VariableReferenceExpression variable;
        List joinColumns = ((JoinUsing)node.getCriteria().get()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, VariableReferenceExpression> leftJoinColumns = new HashMap<Identifier, VariableReferenceExpression>();
        HashMap<Identifier, VariableReferenceExpression> rightJoinColumns = new HashMap<Identifier, VariableReferenceExpression>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putAll((Map)left.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
        rightCoercions.putAll((Map)right.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((Expression)identifier);
            VariableReferenceExpression leftOutput = PlannerUtils.newVariable(this.variableAllocator, (Expression)identifier, type);
            int leftField = (Integer)joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, this.rowExpression((Expression)new Cast(identifier.getLocation(), (Expression)ExpressionTreeUtils.createSymbolReference(left.getVariable(leftField)), type.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(left.getDescriptor().getFieldByIndex(leftField).getType(), type)), context));
            leftJoinColumns.put(identifier, leftOutput);
            VariableReferenceExpression rightOutput = PlannerUtils.newVariable(this.variableAllocator, (Expression)identifier, type);
            int rightField = (Integer)joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, this.rowExpression((Expression)new Cast(identifier.getLocation(), (Expression)ExpressionTreeUtils.createSymbolReference(right.getVariable(rightField)), type.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(right.getDescriptor().getFieldByIndex(rightField).getType(), type)), context));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), (PlanNode)leftCoercion, (PlanNode)rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftCoercion.getOutputVariables()).addAll((Iterable)rightCoercion.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            VariableReferenceExpression output = PlannerUtils.newVariable(this.variableAllocator, (Expression)column, this.analysis.getType((Expression)column));
            outputs.add((Object)output);
            assignments.put(output, this.rowExpression((Expression)new CoalesceExpression(column.getLocation(), (Expression)ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)leftJoinColumns.get(column)), (Expression)ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)rightJoinColumns.get(column)), new Expression[0]), context));
        }
        Iterator iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            variable = left.getFieldMappings().get(field);
            outputs.add((Object)variable);
            assignments.put(variable, (RowExpression)variable);
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            variable = right.getFieldMappings().get(field);
            outputs.add((Object)variable);
            assignments.put(variable, (RowExpression)variable);
        }
        return new RelationPlan((PlanNode)new ProjectNode(this.idAllocator.getNextId(), (PlanNode)join, assignments.build()), this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs.build());
    }

    private Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planLateralJoin(Join join, RelationPlan leftPlan, Lateral lateral, SqlPlannerContext context) {
        RelationPlan rightPlan = this.process((Node)lateral.getQuery(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        PlanBuilder planBuilder = this.subqueryPlanner.appendLateralJoin(leftPlanBuilder, rightPlanBuilder, lateral.getQuery(), true, LateralJoinNode.Type.INNER, context);
        ImmutableList outputVariables = ImmutableList.builder().addAll((Iterable)leftPlan.getRoot().getOutputVariables()).addAll((Iterable)rightPlan.getRoot().getOutputVariables()).build();
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<VariableReferenceExpression>)outputVariables);
    }

    private RelationPlan planCrossJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node, SqlPlannerContext context) {
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedVariablesBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            VariableReferenceExpression variable = PlannerUtils.newVariable(this.variableAllocator, field);
            unnestedVariablesBuilder.add((Object)variable);
        }
        ImmutableList unnestedVariables = unnestedVariablesBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = planBuilder.appendProjections(node.getExpressions(), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = (ProjectNode)planBuilder.getRoot();
        ImmutableMap.Builder unnestVariables = ImmutableMap.builder();
        UnmodifiableIterator unnestedVariablesIterator = unnestedVariables.iterator();
        HashSet<VariableReferenceExpression> usedInputVariables = new HashSet<VariableReferenceExpression>();
        ImmutableMap.Builder unnestOutputMappingBuilder = ImmutableMap.builder();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            VariableReferenceExpression inputVariable = new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)expression), translations.get(expression).getName(), type);
            boolean isDuplicate = usedInputVariables.contains(inputVariable);
            usedInputVariables.add(inputVariable);
            ImmutableList.Builder unnestVariableBuilder = ImmutableList.builder();
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestVariableBuilder.add(unnestedVariablesIterator.next());
                    }
                } else {
                    unnestVariableBuilder.add(unnestedVariablesIterator.next());
                }
            } else if (type instanceof MapType) {
                unnestVariableBuilder.addAll((Iterable)ImmutableList.of((Object)unnestedVariablesIterator.next(), (Object)unnestedVariablesIterator.next()));
            } else {
                throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
            }
            if (isDuplicate) {
                unnestOutputMappingBuilder.putAll(this.buildOutputMapping((List)unnestVariables.build().get((Object)inputVariable), (List<VariableReferenceExpression>)unnestVariableBuilder.build()));
                continue;
            }
            unnestVariables.put((Object)inputVariable, (Object)unnestVariableBuilder.build());
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.isWithOrdinality() ? Optional.of(unnestedVariablesIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedVariablesIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output variables were matched with input variables");
        UnnestNode unnestNode = new UnnestNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), (PlanNode)projectNode, leftPlan.getFieldMappings(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)unnestVariables.build(), ordinalityVariable);
        ImmutableMap unnestOutputMapping = unnestOutputMappingBuilder.build();
        if (!unnestOutputMapping.isEmpty()) {
            ProjectNode dedupProjectionNode = this.projectUnnestWithDuplicates((List<VariableReferenceExpression>)unnestedVariables, (Map<VariableReferenceExpression, VariableReferenceExpression>)unnestOutputMapping, unnestNode);
            return new RelationPlan((PlanNode)dedupProjectionNode, this.analysis.getScope((Node)joinNode), dedupProjectionNode.getOutputVariables());
        }
        return new RelationPlan(unnestNode, this.analysis.getScope((Node)joinNode), unnestNode.getOutputVariables());
    }

    private Map<VariableReferenceExpression, VariableReferenceExpression> buildOutputMapping(List<VariableReferenceExpression> input, List<VariableReferenceExpression> output) {
        Preconditions.checkState((output.size() == input.size() ? 1 : 0) != 0);
        IntStream.range(0, output.size()).boxed().forEach(index -> Preconditions.checkState((boolean)((VariableReferenceExpression)output.get((int)index)).getType().equals(((VariableReferenceExpression)input.get((int)index)).getType())));
        return (Map)IntStream.range(0, output.size()).boxed().collect(ImmutableMap.toImmutableMap(index -> (VariableReferenceExpression)output.get((int)index), index -> (VariableReferenceExpression)input.get((int)index)));
    }

    private ProjectNode projectUnnestWithDuplicates(List<VariableReferenceExpression> completeUnnestedOutput, Map<VariableReferenceExpression, VariableReferenceExpression> duplicateUnnestOutputMapping, UnnestNode unnestNode) {
        Assignments.Builder projections = Assignments.builder();
        projections.putAll((Map)unnestNode.getReplicateVariables().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
        for (VariableReferenceExpression unnestedVariable : completeUnnestedOutput) {
            if (duplicateUnnestOutputMapping.containsKey(unnestedVariable)) {
                projections.put(unnestedVariable, (RowExpression)duplicateUnnestOutputMapping.get(unnestedVariable));
                continue;
            }
            projections.put(unnestedVariable, (RowExpression)unnestedVariable);
        }
        if (unnestNode.getOrdinalityVariable().isPresent()) {
            projections.put(unnestNode.getOrdinalityVariable().get(), (RowExpression)unnestNode.getOrdinalityVariable().get());
        }
        return new ProjectNode(this.idAllocator.getNextId(), (PlanNode)unnestNode, projections.build());
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, SqlPlannerContext context) {
        return this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, SqlPlannerContext context) {
        return new QueryPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session, context, this.sqlParser).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, SqlPlannerContext context) {
        return new QueryPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session, context, this.sqlParser).plan(node);
    }

    protected RelationPlan visitValues(Values node, SqlPlannerContext context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        for (Object field : scope.getRelationType().getVisibleFields()) {
            outputVariablesBuilder.add((Object)PlannerUtils.newVariable(this.variableAllocator, (Field)field));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                for (Expression item : ((Row)row).getItems()) {
                    values.add((Object)this.rewriteRow(item, context));
                }
            } else {
                values.add((Object)this.rewriteRow(row, context));
            }
            rowsBuilder.add((Object)values.build());
        }
        context.incrementLeafNodes(this.session);
        ValuesNode valuesNode = new ValuesNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), (List)outputVariablesBuilder.build(), (List)rowsBuilder.build(), Optional.empty());
        return new RelationPlan((PlanNode)valuesNode, scope, (List<VariableReferenceExpression>)outputVariablesBuilder.build());
    }

    private RowExpression rewriteRow(Expression row, SqlPlannerContext context) {
        Expression expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Type baseType = RelationPlanner.this.analysis.getType(node.getBase());
                Type nodeType = RelationPlanner.this.analysis.getType((Expression)node);
                if (TypeUtils.isEnumType((Type)baseType) && TypeUtils.isEnumType((Type)nodeType)) {
                    return new EnumLiteral(nodeType.getTypeSignature().toString(), ExpressionTreeUtils.resolveEnumLiteral(node, nodeType));
                }
                return node;
            }
        }, (Expression)row);
        expression = Coercer.addCoercions(expression, this.analysis);
        expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis), (Expression)expression);
        return this.rowExpression(expression, context);
    }

    protected RelationPlan visitUnnest(Unnest node, SqlPlannerContext context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            VariableReferenceExpression variable = PlannerUtils.newVariable(this.variableAllocator, field);
            outputVariablesBuilder.add((Object)variable);
        }
        ImmutableList unnestedVariables = outputVariablesBuilder.build();
        ImmutableList.Builder argumentVariables = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestVariables = ImmutableMap.builder();
        Iterator unnestedVariablesIterator = unnestedVariables.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Expression rewritten = Coercer.addCoercions(expression, this.analysis);
            rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis), (Expression)rewritten);
            values.add((Object)this.rowExpression(rewritten, context));
            VariableReferenceExpression input = PlannerUtils.newVariable(this.variableAllocator, rewritten, type);
            argumentVariables.add((Object)new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)rewritten), input.getName(), type));
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    ImmutableList.Builder unnestVariableBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestVariableBuilder.add(unnestedVariablesIterator.next());
                    }
                    unnestVariables.put((Object)input, (Object)unnestVariableBuilder.build());
                    continue;
                }
                unnestVariables.put((Object)input, (Object)ImmutableList.of(unnestedVariablesIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestVariables.put((Object)input, (Object)ImmutableList.of(unnestedVariablesIterator.next(), unnestedVariablesIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.isWithOrdinality() ? Optional.of(unnestedVariablesIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedVariablesIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output variables were matched with input variables");
        ValuesNode valuesNode = new ValuesNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), (List)argumentVariables.build(), (List)ImmutableList.of((Object)values.build()), Optional.empty());
        UnnestNode unnestNode = new UnnestNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), (PlanNode)valuesNode, (List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)unnestVariables.build(), ordinalityVariable);
        return new RelationPlan(unnestNode, scope, (List<VariableReferenceExpression>)unnestedVariables);
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, SqlPlannerContext context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = this.process((Node)node, context);
        if (coerceToTypes == null) {
            return plan;
        }
        return this.addCoercions(plan, coerceToTypes, context);
    }

    private RelationPlan addCoercions(RelationPlan plan, Type[] targetColumnTypes, SqlPlannerContext context) {
        RelationType oldRelation = plan.getDescriptor();
        List oldVisibleVariables = (List)oldRelation.getVisibleFields().stream().map(arg_0 -> ((RelationType)oldRelation).indexOf(arg_0)).map(plan.getFieldMappings()::get).collect(ImmutableList.toImmutableList());
        RelationType oldRelationWithVisibleFields = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((targetColumnTypes.length == oldVisibleVariables.size() ? 1 : 0) != 0);
        ImmutableList.Builder newVariables = new ImmutableList.Builder();
        Field[] newFields = new Field[targetColumnTypes.length];
        Assignments.Builder assignments = Assignments.builder();
        for (int i = 0; i < targetColumnTypes.length; ++i) {
            VariableReferenceExpression outputVariable;
            VariableReferenceExpression inputVariable = (VariableReferenceExpression)oldVisibleVariables.get(i);
            Field oldField = oldRelationWithVisibleFields.getFieldByIndex(i);
            Type outputType = targetColumnTypes[i];
            if (!outputType.equals(inputVariable.getType())) {
                Cast cast = new Cast((Expression)ExpressionTreeUtils.createSymbolReference(inputVariable), outputType.getTypeSignature().toString());
                outputVariable = PlannerUtils.newVariable(this.variableAllocator, (Expression)cast, outputType);
                assignments.put(outputVariable, this.rowExpression((Expression)cast, context));
                newVariables.add((Object)outputVariable);
            } else {
                SymbolReference symbolReference = new SymbolReference(oldField.getNodeLocation(), inputVariable.getName());
                outputVariable = PlannerUtils.newVariable(this.variableAllocator, (Expression)symbolReference, outputType);
                assignments.put(outputVariable, this.rowExpression((Expression)symbolReference, context));
                newVariables.add((Object)outputVariable);
            }
            newFields[i] = new Field(oldField.getNodeLocation(), oldField.getRelationAlias(), oldField.getName(), targetColumnTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        return new RelationPlan((PlanNode)projectNode, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(newFields)).build(), (List<VariableReferenceExpression>)newVariables.build());
    }

    protected RelationPlan visitUnion(Union node, SqlPlannerContext context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node, context);
        UnionNode planNode = new UnionNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        if (node.isDistinct().orElse(true).booleanValue()) {
            planNode = this.distinct((PlanNode)planNode);
        }
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    protected RelationPlan visitIntersect(Intersect node, SqlPlannerContext context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node, context);
        IntersectNode planNode = new IntersectNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    protected RelationPlan visitExcept(Except node, SqlPlannerContext context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node, context);
        ExceptNode planNode = new ExceptNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    private SetOperationPlan process(SetOperation node, SqlPlannerContext context) {
        List outputs = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder variableMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, context)).collect(ImmutableList.toImmutableList());
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            List<VariableReferenceExpression> childOutputVariables = relationPlan.getFieldMappings();
            if (outputs == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputVariableBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    VariableReferenceExpression variable = childOutputVariables.get(fieldIndex);
                    outputVariableBuilder.add((Object)this.variableAllocator.newVariable(variable));
                }
                outputs = outputVariableBuilder.build();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == outputs.size() ? 1 : 0) != 0, (String)"Expected relation to have %s variables but has %s variables", (int)descriptor.getVisibleFieldCount(), (int)outputs.size());
            int fieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                variableMapping.put(outputs.get(fieldId), (Object)childOutputVariables.get(fieldIndex));
                ++fieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        return new SetOperationPlan((List)sources.build(), (ListMultimap)variableMapping.build());
    }

    private void checkInterruption() {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_PLANNING_TIMEOUT, String.format("The query planner exceeded the timeout of %s.", SystemSessionProperties.getQueryAnalyzerTimeout(this.session).toString()));
        }
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(node.getSourceLocation(), this.idAllocator.getNextId(), node, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)node.getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private RowExpression rowExpression(Expression expression, SqlPlannerContext context) {
        return TranslateExpressionsUtil.toRowExpression(expression, this.metadata, this.session, this.sqlParser, this.variableAllocator, this.analysis, context.getTranslatorContext());
    }

    private static class SetOperationPlan {
        private final List<PlanNode> sources;
        private final List<VariableReferenceExpression> outputVariables;
        private final Map<VariableReferenceExpression, List<VariableReferenceExpression>> variableMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<VariableReferenceExpression, VariableReferenceExpression> variableMapping) {
            this.sources = sources;
            this.outputVariables = ImmutableList.copyOf((Collection)variableMapping.keySet());
            LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>> mapping = new LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>>();
            variableMapping.asMap().forEach((key, value) -> {
                Preconditions.checkState((boolean)(value instanceof List), (Object)"variableMapping values should be of type List");
                mapping.put((VariableReferenceExpression)key, (List)value);
            });
            this.variableMapping = mapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public List<VariableReferenceExpression> getOutputVariables() {
            return this.outputVariables;
        }

        public Map<VariableReferenceExpression, List<VariableReferenceExpression>> getVariableMapping() {
            return this.variableMapping;
        }
    }
}

