/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.LocalCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.JoinSwappingUtils;
import com.facebook.presto.sql.planner.iterative.rule.PlanNodeWithCost;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DetermineJoinDistributionType
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent());
    private final CostComparator costComparator;
    private final TaskCountEstimator taskCountEstimator;
    private String statsSource;

    public DetermineJoinDistributionType(CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public boolean isCostBased(Session session) {
        return SystemSessionProperties.getJoinDistributionType(session) == FeaturesConfig.JoinDistributionType.AUTOMATIC;
    }

    @Override
    public String getStatsSource() {
        return this.statsSource;
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        FeaturesConfig.JoinDistributionType joinDistributionType = SystemSessionProperties.getJoinDistributionType(context.getSession());
        if (joinDistributionType == FeaturesConfig.JoinDistributionType.AUTOMATIC) {
            PlanNode resultNode = this.getCostBasedJoin(joinNode, context);
            this.statsSource = context.getStatsProvider().getStats(joinNode).getSourceInfo().getSourceInfoName();
            return Rule.Result.ofPlanNode(resultNode);
        }
        return Rule.Result.ofPlanNode(this.getSyntacticOrderJoin(joinNode, context, joinDistributionType));
    }

    public static boolean isBelowMaxBroadcastSize(JoinNode joinNode, Rule.Context context) {
        DataSize joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        PlanNode buildSide = joinNode.getRight();
        PlanNodeStatsEstimate buildSideStatsEstimate = context.getStatsProvider().getStats(buildSide);
        double buildSideSizeInBytes = buildSideStatsEstimate.getOutputSizeInBytes(buildSide);
        return buildSideSizeInBytes <= (double)joinMaxBroadcastTableSize.toBytes() || SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession()) && DetermineJoinDistributionType.getSourceTablesSizeInBytes(buildSide, context) <= (double)joinMaxBroadcastTableSize.toBytes();
    }

    private PlanNode getCostBasedJoin(JoinNode joinNode, Rule.Context context) {
        ArrayList<PlanNodeWithCost> possibleJoinNodes = new ArrayList<PlanNodeWithCost>();
        this.addJoinsWithDifferentDistributions(joinNode, possibleJoinNodes, context);
        this.addJoinsWithDifferentDistributions(joinNode.flipChildren(), possibleJoinNodes, context);
        if (possibleJoinNodes.stream().anyMatch(result -> result.getCost().hasUnknownComponents()) || possibleJoinNodes.isEmpty()) {
            if (SystemSessionProperties.isUseBroadcastJoinWhenBuildSizeSmallProbeSizeUnknownEnabled(context.getSession()) && possibleJoinNodes.stream().anyMatch(result -> ((JoinNode)result.getPlanNode()).getDistributionType().get().equals((Object)JoinNode.DistributionType.REPLICATED))) {
                return (PlanNode)Iterables.getOnlyElement((Iterable)((Iterable)possibleJoinNodes.stream().filter(result -> ((JoinNode)result.getPlanNode()).getDistributionType().get().equals((Object)JoinNode.DistributionType.REPLICATED)).map(x -> x.getPlanNode()).collect(ImmutableList.toImmutableList())));
            }
            if (SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession())) {
                return this.getSizeBasedJoin(joinNode, context);
            }
            return this.getSyntacticOrderJoin(joinNode, context, FeaturesConfig.JoinDistributionType.AUTOMATIC);
        }
        Ordering planNodeOrderings = this.costComparator.forSession(context.getSession()).onResultOf(PlanNodeWithCost::getCost);
        return ((PlanNodeWithCost)planNodeOrderings.min(possibleJoinNodes)).getPlanNode();
    }

    private JoinNode getSizeBasedJoin(JoinNode joinNode, Rule.Context context) {
        boolean isRightSideSmall = JoinSwappingUtils.isBelowBroadcastLimit(joinNode.getRight(), context);
        if (isRightSideSmall && !this.mustPartition(joinNode)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
        }
        boolean isLeftSideSmall = JoinSwappingUtils.isBelowBroadcastLimit(joinNode.getLeft(), context);
        JoinNode flippedJoin = joinNode.flipChildren();
        if (isLeftSideSmall && !this.mustPartition(flippedJoin)) {
            return flippedJoin.withDistributionType(JoinNode.DistributionType.REPLICATED);
        }
        if (isRightSideSmall) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        if (isLeftSideSmall) {
            return flippedJoin.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        if (JoinSwappingUtils.isSmallerThanThreshold(joinNode.getRight(), joinNode.getLeft(), context) && !DetermineJoinDistributionType.mustReplicate(joinNode, context)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        if (JoinSwappingUtils.isSmallerThanThreshold(joinNode.getLeft(), joinNode.getRight(), context) && !DetermineJoinDistributionType.mustReplicate(flippedJoin, context)) {
            return flippedJoin.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        return this.getSyntacticOrderJoin(joinNode, context, FeaturesConfig.JoinDistributionType.AUTOMATIC);
    }

    public static double getSourceTablesSizeInBytes(PlanNode node, Rule.Context context) {
        return DetermineJoinDistributionType.getSourceTablesSizeInBytes(node, context.getLookup(), context.getStatsProvider());
    }

    @VisibleForTesting
    static double getSourceTablesSizeInBytes(PlanNode node, Lookup lookup, StatsProvider statsProvider) {
        boolean hasExpandingNodes = PlanNodeSearcher.searchFrom(node, lookup).whereIsInstanceOfAny(JoinSwappingUtils.EXPANDING_NODE_CLASSES).matches();
        if (hasExpandingNodes) {
            return Double.NaN;
        }
        List sourceNodes = PlanNodeSearcher.searchFrom(node, lookup).whereIsInstanceOfAny((List<Class<? extends PlanNode>>)ImmutableList.of(TableScanNode.class, ValuesNode.class, RemoteSourceNode.class)).findAll();
        return sourceNodes.stream().mapToDouble(sourceNode -> statsProvider.getStats((PlanNode)sourceNode).getOutputSizeInBytes((PlanNode)sourceNode)).sum();
    }

    private void addJoinsWithDifferentDistributions(JoinNode joinNode, List<PlanNodeWithCost> possibleJoinNodes, Rule.Context context) {
        if (!this.mustPartition(joinNode) && DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, context)) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED)));
        }
        if (!DetermineJoinDistributionType.mustReplicate(joinNode, context) && !joinNode.getCriteria().isEmpty()) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED)));
        }
    }

    private JoinNode getSyntacticOrderJoin(JoinNode joinNode, Rule.Context context, FeaturesConfig.JoinDistributionType joinDistributionType) {
        if (this.mustPartition(joinNode)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        if (DetermineJoinDistributionType.mustReplicate(joinNode, context)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
        }
        if (joinDistributionType.canPartition()) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        return joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
    }

    private boolean mustPartition(JoinNode joinNode) {
        return joinNode.getType().mustPartition();
    }

    private static boolean mustReplicate(JoinNode joinNode, Rule.Context context) {
        if (joinNode.getType().mustReplicate(joinNode.getCriteria())) {
            return true;
        }
        return QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), context.getLookup());
    }

    private PlanNodeWithCost getJoinNodeWithCost(Rule.Context context, JoinNode possibleJoinNode) {
        StatsProvider stats = context.getStatsProvider();
        boolean replicated = possibleJoinNode.getDistributionType().get().equals((Object)JoinNode.DistributionType.REPLICATED);
        int estimatedSourceDistributedTaskCount = this.taskCountEstimator.estimateSourceDistributedTaskCount();
        LocalCostEstimate cost = CostCalculatorWithEstimatedExchanges.calculateJoinCostWithoutOutput(possibleJoinNode.getLeft(), possibleJoinNode.getRight(), stats, replicated, estimatedSourceDistributedTaskCount);
        return new PlanNodeWithCost(cost.toPlanCost(), possibleJoinNode);
    }
}

