/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantCastToVarcharInJoinClause
implements Rule<JoinNode> {
    private static final List<Type> TYPE_SUPPORTED = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT);
    private final FunctionAndTypeManager functionAndTypeManager;
    private final FunctionResolution functionResolution;

    public RemoveRedundantCastToVarcharInJoinClause(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = functionAndTypeManager;
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isRemoveRedundantCastToVarcharInJoinEnabled(session);
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return Patterns.join();
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        PlanNode leftInput = context.getLookup().resolve(node.getLeft());
        PlanNode rightInput = context.getLookup().resolve(node.getRight());
        if (!(leftInput instanceof ProjectNode) || !(rightInput instanceof ProjectNode)) {
            return Rule.Result.empty();
        }
        ProjectNode leftProject = (ProjectNode)leftInput;
        ProjectNode rightProject = (ProjectNode)rightInput;
        ImmutableList.Builder joinClauseBuilder = ImmutableList.builder();
        ImmutableMap.Builder newLeftAssignmentsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder newRightAssignmentsBuilder = ImmutableMap.builder();
        boolean isChanged = false;
        for (JoinNode.EquiJoinClause equiJoinClause : node.getCriteria()) {
            RowExpression leftProjectAssignment = (RowExpression)leftProject.getAssignments().getMap().get(equiJoinClause.getLeft());
            RowExpression rightProjectAssignment = (RowExpression)rightProject.getAssignments().getMap().get(equiJoinClause.getRight());
            if (!this.isSupportedCast(leftProjectAssignment) || !this.isSupportedCast(rightProjectAssignment)) {
                joinClauseBuilder.add((Object)equiJoinClause);
                continue;
            }
            RowExpression leftAssignment = (RowExpression)((CallExpression)leftProjectAssignment).getArguments().get(0);
            RowExpression rightAssignment = (RowExpression)((CallExpression)rightProjectAssignment).getArguments().get(0);
            if (!leftAssignment.getType().equals(rightAssignment.getType())) {
                leftAssignment = Expressions.castToBigInt(this.functionAndTypeManager, leftAssignment);
                rightAssignment = Expressions.castToBigInt(this.functionAndTypeManager, rightAssignment);
            }
            VariableReferenceExpression newLeft = context.getVariableAllocator().newVariable(leftAssignment);
            newLeftAssignmentsBuilder.put((Object)newLeft, (Object)leftAssignment);
            VariableReferenceExpression newRight = context.getVariableAllocator().newVariable(rightAssignment);
            newRightAssignmentsBuilder.put((Object)newRight, (Object)rightAssignment);
            joinClauseBuilder.add((Object)new JoinNode.EquiJoinClause(newLeft, newRight));
            isChanged = true;
        }
        if (!isChanged) {
            return Rule.Result.empty();
        }
        newLeftAssignmentsBuilder.putAll(leftProject.getAssignments().getMap());
        ImmutableMap newLeftAssignments = newLeftAssignmentsBuilder.build();
        newRightAssignmentsBuilder.putAll(rightProject.getAssignments().getMap());
        ImmutableMap newRightAssignments = newRightAssignmentsBuilder.build();
        PlanNode newLeftProject = PlannerUtils.addProjections(leftProject.getSource(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)newLeftAssignments);
        PlanNode newRightProject = PlannerUtils.addProjections(rightProject.getSource(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)newRightAssignments);
        return Rule.Result.ofPlanNode(new JoinNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getType(), newLeftProject, newRightProject, (List<JoinNode.EquiJoinClause>)joinClauseBuilder.build(), node.getOutputVariables(), node.getFilter(), Optional.empty(), Optional.empty(), node.getDistributionType(), node.getDynamicFilters()));
    }

    private boolean isSupportedCast(RowExpression rowExpression) {
        if (rowExpression instanceof CallExpression && this.functionResolution.isCastFunction(((CallExpression)rowExpression).getFunctionHandle())) {
            CallExpression cast = (CallExpression)rowExpression;
            return TYPE_SUPPORTED.contains(((RowExpression)cast.getArguments().get(0)).getType()) && cast.getType() instanceof VarcharType;
        }
        return false;
    }
}

