/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RowExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RewriteConstantArrayContainsToInExpression
extends RowExpressionRewriteRuleSet {
    public RewriteConstantArrayContainsToInExpression(FunctionAndTypeManager functionAndTypeManager) {
        super(new Rewriter(functionAndTypeManager));
    }

    @Override
    public boolean isRewriterEnabled(Session session) {
        return SystemSessionProperties.isRwriteConstantArrayContainsToInExpressionEnabled(session);
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.filterRowExpressionRewriteRule(), this.projectRowExpressionRewriteRule());
    }

    private static class ContainsToInRewriter
    extends RowExpressionRewriter<Void> {
        private final FunctionResolution functionResolution;

        private ContainsToInRewriter(FunctionAndTypeManager functionAndTypeManager) {
            this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        }

        private boolean isSupportedType(Type type) {
            return TypeUtils.isExactNumericType((Type)type) || type instanceof VarcharType || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampType.TIMESTAMP_MICROSECONDS);
        }

        public RowExpression rewriteCall(CallExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
            if (this.functionResolution.isArrayContainsFunction(node.getFunctionHandle()) && node.getArguments().get(0) instanceof ConstantExpression && !((ConstantExpression)node.getArguments().get(0)).isNull()) {
                Preconditions.checkState((((ConstantExpression)node.getArguments().get(0)).getValue() instanceof Block && ((RowExpression)node.getArguments().get(0)).getType() instanceof ArrayType ? 1 : 0) != 0);
                Block arrayValue = (Block)((ConstantExpression)node.getArguments().get(0)).getValue();
                if (arrayValue.getPositionCount() == 0) {
                    return null;
                }
                Type arrayElementType = ((ArrayType)((RowExpression)node.getArguments().get(0)).getType()).getElementType();
                if (!this.isSupportedType(arrayElementType)) {
                    return null;
                }
                ImmutableList.Builder arguments = ImmutableList.builder();
                arguments.add(node.getArguments().get(1));
                for (int i = 0; i < arrayValue.getPositionCount(); ++i) {
                    arguments.add((Object)Expressions.constant(TypeUtils.readNativeValue((Type)arrayElementType, (Block)arrayValue, (int)i), arrayElementType));
                }
                return new SpecialFormExpression(node.getSourceLocation(), SpecialFormExpression.Form.IN, node.getType(), (List)arguments.build());
            }
            return null;
        }
    }

    private static class Rewriter
    implements RowExpressionRewriteRuleSet.PlanRowExpressionRewriter {
        private final ContainsToInRewriter containsToInRewriter;

        public Rewriter(FunctionAndTypeManager functionAndTypeManager) {
            Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.containsToInRewriter = new ContainsToInRewriter(functionAndTypeManager);
        }

        @Override
        public RowExpression rewrite(RowExpression expression, Rule.Context context) {
            return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)this.containsToInRewriter, (RowExpression)expression);
        }
    }
}

