/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.optimizations.StreamPreferredProperties;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AddLocalExchanges
implements PlanOptimizer {
    private final Metadata metadata;
    private final SqlParser parser;

    public AddLocalExchanges(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanWithProperties result = new Rewriter(variableAllocator, idAllocator, session).accept(plan, StreamPreferredProperties.any());
        boolean optimizerTriggered = PlanNodeSearcher.searchFrom(result.getNode()).where(node -> node instanceof ExchangeNode && ((ExchangeNode)((Object)node)).getScope().isLocal()).findFirst().isPresent();
        return PlanOptimizerResult.optimizerResult(result.getNode(), optimizerTriggered);
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final StreamPropertyDerivations.StreamProperties properties;

        public PlanWithProperties(PlanNode node, StreamPropertyDerivations.StreamProperties properties) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.properties = Objects.requireNonNull(properties, "StreamProperties is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public StreamPropertyDerivations.StreamProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends InternalPlanVisitor<PlanWithProperties, StreamPreferredProperties> {
        private final VariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final TypeProvider types;

        public Rewriter(VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Session session) {
            this.variableAllocator = variableAllocator;
            this.types = TypeProvider.viewOf(variableAllocator.getVariables());
            this.idAllocator = idAllocator;
            this.session = session;
        }

        public PlanWithProperties visitPlan(PlanNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, StreamPreferredProperties parentPreferences) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        @Override
        public PlanWithProperties visitLateralJoin(LateralJoinNode node, StreamPreferredProperties parentPreferences) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        public PlanWithProperties visitOutput(OutputNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren((PlanNode)node, StreamPreferredProperties.any().withOrderSensitivity(), StreamPreferredProperties.any().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream().withOrderSensitivity(), StreamPreferredProperties.singleStream().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties childPlan = this.planAndEnforce(node.getSource(), StreamPreferredProperties.any(), StreamPreferredProperties.singleStream());
            if (childPlan.getProperties().isSingleStream() && childPlan.getProperties().isOrdered()) {
                OrderingScheme orderingScheme = node.getOrderingScheme();
                List desiredProperties = (List)orderingScheme.getOrderByVariables().stream().map(variable -> new SortingProperty(variable, orderingScheme.getOrdering(variable))).collect(ImmutableList.toImmutableList());
                if (LocalProperties.match(childPlan.getProperties().getLocalProperties(), desiredProperties).stream().noneMatch(Optional::isPresent)) {
                    return childPlan;
                }
            }
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                PlanWithProperties sortPlan = this.planAndEnforceChildren(node, StreamPreferredProperties.fixedParallelism(), StreamPreferredProperties.fixedParallelism());
                if (!sortPlan.getProperties().isSingleStream()) {
                    return this.deriveProperties((PlanNode)ExchangeNode.mergingExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, sortPlan.getNode(), node.getOrderingScheme()), sortPlan.getProperties());
                }
                return sortPlan;
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitStatisticsWriterNode(StatisticsWriterNode node, StreamPreferredProperties context) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        public PlanWithProperties visitTopN(TopNNode node, StreamPreferredProperties parentPreferences) {
            if (node.getStep().equals((Object)TopNNode.Step.PARTIAL)) {
                return this.planAndEnforceChildren((PlanNode)node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren((PlanNode)node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        public PlanWithProperties visitLimit(LimitNode node, StreamPreferredProperties parentPreferences) {
            if (node.isPartial()) {
                return this.planAndEnforceChildren((PlanNode)node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren((PlanNode)node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties preferredProperties;
            StreamPreferredProperties requiredProperties;
            if (node.isPartial()) {
                if (SystemSessionProperties.isQuickDistinctLimitEnabled(this.session)) {
                    PlanWithProperties source = this.accept(node.getSource(), StreamPreferredProperties.defaultParallelism(this.session));
                    PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source.getNode()), source.getProperties());
                    return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)exchange));
                }
                requiredProperties = parentPreferences.withoutPreference().withDefaultParallelism(this.session);
                preferredProperties = parentPreferences.withDefaultParallelism(this.session);
            } else {
                requiredProperties = StreamPreferredProperties.singleStream();
                preferredProperties = StreamPreferredProperties.defaultParallelism(this.session);
            }
            return this.planAndEnforceChildren((PlanNode)node, requiredProperties, preferredProperties);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        public PlanWithProperties visitAggregation(AggregationNode node, StreamPreferredProperties parentPreferences) {
            Preconditions.checkState((node.getStep() == AggregationNode.Step.SINGLE ? 1 : 0) != 0, (String)"step of aggregation is expected to be SINGLE, but it is %s", (Object)node.getStep());
            if (AggregationUtils.hasSingleNodeExecutionPreference(node, AddLocalExchanges.this.metadata.getFunctionAndTypeManager())) {
                return this.planAndEnforceChildren((PlanNode)node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            List groupingKeys = node.getGroupingKeys();
            if (node.hasDefaultOutput()) {
                Preconditions.checkState((boolean)AggregationUtils.isDecomposable(node, AddLocalExchanges.this.metadata.getFunctionAndTypeManager()));
                PlanWithProperties child = this.planAndEnforce(node.getSource(), StreamPreferredProperties.any(), StreamPreferredProperties.defaultParallelism(this.session));
                PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.systemPartitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, child.getNode(), groupingKeys, Optional.empty()), child.getProperties());
                return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)exchange));
            }
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputVariables()).withDefaultParallelism(this.session).withPartitioning(groupingKeys);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            Object preGroupedSymbols = ImmutableList.of();
            List matchResult = LocalProperties.match(child.getProperties().getLocalProperties(), LocalProperties.grouped(groupingKeys));
            if (!matchResult.get(0).isPresent()) {
                preGroupedSymbols = groupingKeys;
            } else if (matchResult.get(0).get().getColumns().size() < groupingKeys.size() && SystemSessionProperties.isSegmentedAggregationEnabled(this.session)) {
                preGroupedSymbols = (List)groupingKeys.stream().filter(groupingKey -> !((LocalProperty)((Optional)matchResult.get(0)).get()).getColumns().contains(groupingKey)).collect(ImmutableList.toImmutableList());
            }
            AggregationNode result = new AggregationNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getAggregations(), node.getGroupingSets(), (List)preGroupedSymbols, node.getStep(), node.getHashVariable(), node.getGroupIdVariable(), node.getAggregationId());
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputVariables()).withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            ArrayList desiredProperties = new ArrayList();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderByVariables().stream().map(variable -> new SortingProperty(variable, orderingScheme.getOrdering(variable))).forEach(desiredProperties::add));
            Iterator matchIterator = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).iterator();
            Object prePartitionedInputs = ImmutableSet.of();
            if (!node.getPartitionBy().isEmpty()) {
                Optional<LocalProperty<LocalProperty>> groupingRequirement = matchIterator.next();
                Set unPartitionedInputs = groupingRequirement.map(LocalProperty::getColumns).orElse((Set)ImmutableSet.of());
                prePartitionedInputs = (Set)node.getPartitionBy().stream().filter(variable -> !unPartitionedInputs.contains(variable)).collect(ImmutableSet.toImmutableSet());
            }
            int preSortedOrderPrefix = 0;
            if (prePartitionedInputs.equals(ImmutableSet.copyOf(node.getPartitionBy()))) {
                while (matchIterator.hasNext() && !matchIterator.next().isPresent()) {
                    ++preSortedOrderPrefix;
                }
            }
            WindowNode result = new WindowNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getSpecification(), node.getWindowFunctions(), node.getHashVariable(), (Set<VariableReferenceExpression>)prePartitionedInputs, preSortedOrderPrefix);
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputVariables()).withDefaultParallelism(this.session).withPartitioning(node.getDistinctVariables());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            MarkDistinctNode result = new MarkDistinctNode(node.getSourceLocation(), node.getId(), child.getNode(), node.getMarkerVariable(), this.pruneMarkDistinctVariables(node, child.getProperties().getLocalProperties()), node.getHashVariable());
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        private List<VariableReferenceExpression> pruneMarkDistinctVariables(MarkDistinctNode node, List<LocalProperty<VariableReferenceExpression>> localProperties) {
            if (localProperties.isEmpty()) {
                return node.getDistinctVariables();
            }
            ImmutableSet.Builder redundantVariablesBuilder = ImmutableSet.builder();
            for (LocalProperty<VariableReferenceExpression> property : localProperties) {
                if (property instanceof ConstantProperty) {
                    redundantVariablesBuilder.add(((ConstantProperty)property).getColumn());
                    continue;
                }
                if (node.getDistinctVariables().containsAll(property.getColumns())) continue;
                break;
            }
            ImmutableSet redundantVariables = redundantVariablesBuilder.build();
            List remainingSymbols = (List)node.getDistinctVariables().stream().filter(arg_0 -> Rewriter.lambda$pruneMarkDistinctVariables$5((Set)redundantVariables, arg_0)).collect(ImmutableList.toImmutableList());
            if (remainingSymbols.isEmpty()) {
                return ImmutableList.of(node.getDistinctVariables().get(0));
            }
            return remainingSymbols;
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session);
            if (!node.isPartial()) {
                requiredProperties = requiredProperties.withPartitioning(node.getPartitionBy());
            }
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session);
            if (!node.isPartial()) {
                requiredProperties = requiredProperties.withPartitioning(node.getPartitionBy());
            }
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode originalTableWriterNode, StreamPreferredProperties parentPreferences) {
            PlanWithProperties tableWriter;
            if (originalTableWriterNode.getTablePartitioningScheme().isPresent() && SystemSessionProperties.getTaskPartitionedWriterCount(this.session) == 1) {
                return this.planAndEnforceChildren(originalTableWriterNode, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            if (!originalTableWriterNode.getTablePartitioningScheme().isPresent() && SystemSessionProperties.getTaskWriterCount(this.session) == 1) {
                return this.planAndEnforceChildren(originalTableWriterNode, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            if (!SystemSessionProperties.isTableWriterMergeOperatorEnabled(this.session)) {
                return this.planAndEnforceChildren(originalTableWriterNode, StreamPreferredProperties.fixedParallelism(), StreamPreferredProperties.fixedParallelism());
            }
            Optional<StatisticAggregations.Parts> statisticAggregations = originalTableWriterNode.getStatisticsAggregation().map(aggregations -> aggregations.splitIntoPartialAndIntermediate(this.variableAllocator, AddLocalExchanges.this.metadata.getFunctionAndTypeManager()));
            if (!originalTableWriterNode.getTablePartitioningScheme().isPresent()) {
                int taskConcurrency;
                int taskWriterCount = SystemSessionProperties.getTaskWriterCount(this.session);
                if (taskWriterCount == (taskConcurrency = SystemSessionProperties.getTaskConcurrency(this.session))) {
                    tableWriter = this.planAndEnforceChildren(new TableWriterNode(originalTableWriterNode.getSourceLocation(), originalTableWriterNode.getId(), originalTableWriterNode.getStatsEquivalentPlanNode(), originalTableWriterNode.getSource(), originalTableWriterNode.getTarget(), this.variableAllocator.newVariable("partialrowcount", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("partialcontext", (Type)VarbinaryType.VARBINARY), originalTableWriterNode.getColumns(), originalTableWriterNode.getColumnNames(), originalTableWriterNode.getNotNullColumnVariables(), originalTableWriterNode.getTablePartitioningScheme(), originalTableWriterNode.getPreferredShufflePartitioningScheme(), statisticAggregations.map(StatisticAggregations.Parts::getPartialAggregation), originalTableWriterNode.getTaskCountIfScaledWriter()), StreamPreferredProperties.fixedParallelism(), StreamPreferredProperties.fixedParallelism());
                } else {
                    PlanWithProperties source = this.accept(originalTableWriterNode.getSource(), StreamPreferredProperties.defaultParallelism(this.session));
                    PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source.getNode()), source.getProperties());
                    tableWriter = this.deriveProperties((PlanNode)new TableWriterNode(originalTableWriterNode.getSourceLocation(), originalTableWriterNode.getId(), originalTableWriterNode.getStatsEquivalentPlanNode(), exchange.getNode(), originalTableWriterNode.getTarget(), this.variableAllocator.newVariable("partialrowcount", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("partialcontext", (Type)VarbinaryType.VARBINARY), originalTableWriterNode.getColumns(), originalTableWriterNode.getColumnNames(), originalTableWriterNode.getNotNullColumnVariables(), originalTableWriterNode.getTablePartitioningScheme(), originalTableWriterNode.getPreferredShufflePartitioningScheme(), statisticAggregations.map(StatisticAggregations.Parts::getPartialAggregation), originalTableWriterNode.getTaskCountIfScaledWriter()), exchange.getProperties());
                }
            } else {
                PlanWithProperties source = this.accept(originalTableWriterNode.getSource(), StreamPreferredProperties.defaultParallelism(this.session));
                PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source.getNode(), originalTableWriterNode.getTablePartitioningScheme().get()), source.getProperties());
                tableWriter = this.deriveProperties((PlanNode)new TableWriterNode(originalTableWriterNode.getSourceLocation(), originalTableWriterNode.getId(), originalTableWriterNode.getStatsEquivalentPlanNode(), exchange.getNode(), originalTableWriterNode.getTarget(), this.variableAllocator.newVariable("partialrowcount", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("partialcontext", (Type)VarbinaryType.VARBINARY), originalTableWriterNode.getColumns(), originalTableWriterNode.getColumnNames(), originalTableWriterNode.getNotNullColumnVariables(), originalTableWriterNode.getTablePartitioningScheme(), originalTableWriterNode.getPreferredShufflePartitioningScheme(), statisticAggregations.map(StatisticAggregations.Parts::getPartialAggregation), originalTableWriterNode.getTaskCountIfScaledWriter()), exchange.getProperties());
            }
            PlanWithProperties gatheringExchange = this.deriveProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, tableWriter.getNode()), tableWriter.getProperties());
            return this.deriveProperties((PlanNode)new TableWriterMergeNode(originalTableWriterNode.getSourceLocation(), this.idAllocator.getNextId(), gatheringExchange.getNode(), originalTableWriterNode.getRowCountVariable(), originalTableWriterNode.getFragmentVariable(), originalTableWriterNode.getTableCommitContextVariable(), statisticAggregations.map(StatisticAggregations.Parts::getIntermediateAggregation)), gatheringExchange.getProperties());
        }

        @Override
        public PlanWithProperties visitTableWriteMerge(TableWriterMergeNode node, StreamPreferredProperties context) {
            throw new IllegalArgumentException("Unexpected TableWriterMergeNode");
        }

        @Override
        public PlanWithProperties visitExchange(ExchangeNode node, StreamPreferredProperties parentPreferences) {
            Preconditions.checkArgument((!node.getScope().isLocal() ? 1 : 0) != 0, (Object)"AddLocalExchanges can not process a plan containing a local exchange");
            if (node.getOrderingScheme().isPresent()) {
                return this.planAndEnforceChildren(node, StreamPreferredProperties.any().withOrderSensitivity(), StreamPreferredProperties.any().withOrderSensitivity());
            }
            return this.planAndEnforceChildren(node, SystemSessionProperties.isEnforceFixedDistributionForOutputOperator(this.session) ? StreamPreferredProperties.fixedParallelism() : StreamPreferredProperties.any(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        public PlanWithProperties visitUnion(UnionNode node, StreamPreferredProperties preferredProperties) {
            ExchangeNode result;
            List sourcesWithProperties = (List)node.getSources().stream().map(source -> this.accept((PlanNode)source, StreamPreferredProperties.defaultParallelism(this.session))).collect(ImmutableList.toImmutableList());
            List sources = (List)sourcesWithProperties.stream().map(PlanWithProperties::getNode).collect(ImmutableList.toImmutableList());
            List inputProperties = (List)sourcesWithProperties.stream().map(PlanWithProperties::getProperties).collect(ImmutableList.toImmutableList());
            ArrayList<List<VariableReferenceExpression>> inputLayouts = new ArrayList<List<VariableReferenceExpression>>(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                inputLayouts.add(node.sourceOutputLayout(i));
            }
            if (preferredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), node.getOutputVariables()), sources, inputLayouts, false, Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            Optional<List<VariableReferenceExpression>> preferredPartitionColumns = preferredProperties.getPartitioningColumns();
            if (preferredPartitionColumns.isPresent()) {
                ExchangeNode exchangeNode = new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (Collection)preferredPartitionColumns.get()), node.getOutputVariables()), sources, inputLayouts, false, Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            ExchangeNode exchangeNode = result = new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, ImmutableList.of()), node.getOutputVariables()), sources, inputLayouts, false, Optional.empty());
            return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = SystemSessionProperties.isSpillEnabled(this.session) && SystemSessionProperties.isJoinSpillingEnabled(this.session) ? this.planAndEnforce(node.getLeft(), StreamPreferredProperties.fixedParallelism(), parentPreferences.constrainTo(node.getLeft().getOutputVariables()).withFixedParallelism()) : this.planAndEnforce(node.getLeft(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getLeft().getOutputVariables()).withDefaultParallelism(this.session));
            List buildHashVariables = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
            StreamPreferredProperties buildPreference = SystemSessionProperties.getTaskConcurrency(this.session) > 1 ? StreamPreferredProperties.exactlyPartitionedOn(buildHashVariables) : StreamPreferredProperties.singleStream();
            PlanWithProperties build = this.planAndEnforce(node.getRight(), buildPreference, buildPreference);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)build));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties source = this.planAndEnforce(node.getSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getSource().getOutputVariables()).withDefaultParallelism(this.session));
            PlanWithProperties filteringSource = this.planAndEnforce(node.getFilteringSource(), StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getLeft(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getLeft().getOutputVariables()).withDefaultParallelism(this.session));
            PlanWithProperties build = this.planAndEnforce(node.getRight(), StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)build));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getProbeSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getProbeSource().getOutputVariables()).withDefaultParallelism(this.session));
            StreamPropertyDerivations.StreamProperties indexStreamProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getIndexSource(), AddLocalExchanges.this.metadata, this.session, this.types, AddLocalExchanges.this.parser);
            Preconditions.checkArgument((indexStreamProperties.getDistribution() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE ? 1 : 0) != 0, (Object)"index source must be single stream");
            PlanWithProperties index = new PlanWithProperties(node.getIndexSource(), indexStreamProperties);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)index));
        }

        private PlanWithProperties planAndEnforceChildren(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            List children = (List)node.getSources().stream().map(source -> this.planAndEnforce((PlanNode)source, requiredProperties.constrainTo(source.getOutputVariables()), preferredProperties.constrainTo(source.getOutputVariables()))).collect(ImmutableList.toImmutableList());
            return this.rebaseAndDeriveProperties(node, children);
        }

        private PlanWithProperties planAndEnforce(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            Preconditions.checkArgument((boolean)requiredProperties.getPartitioningColumns().map(node.getOutputVariables()::containsAll).orElse(true));
            Preconditions.checkArgument((boolean)preferredProperties.getPartitioningColumns().map(node.getOutputVariables()::containsAll).orElse(true));
            PlanWithProperties result = this.accept(node, preferredProperties);
            result = this.enforce(result, requiredProperties);
            Preconditions.checkState((boolean)requiredProperties.isSatisfiedBy(result.getProperties()), (Object)"required properties not enforced");
            return result;
        }

        private PlanWithProperties enforce(PlanWithProperties planWithProperties, StreamPreferredProperties requiredProperties) {
            if (requiredProperties.isSatisfiedBy(planWithProperties.getProperties())) {
                return planWithProperties;
            }
            if (requiredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            Optional<List<VariableReferenceExpression>> requiredPartitionColumns = requiredProperties.getPartitioningColumns();
            if (!requiredPartitionColumns.isPresent()) {
                return this.deriveProperties((PlanNode)ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode()), planWithProperties.getProperties());
            }
            if (requiredProperties.isParallelPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.systemPartitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode(), requiredPartitionColumns.get(), Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
            return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            List inputProperties = (List)children.stream().map(PlanWithProperties::getProperties).collect(ImmutableList.toImmutableList());
            return this.deriveProperties(result, inputProperties);
        }

        private PlanWithProperties deriveProperties(PlanNode result, StreamPropertyDerivations.StreamProperties inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.metadata, this.session, this.types, AddLocalExchanges.this.parser));
        }

        private PlanWithProperties deriveProperties(PlanNode result, List<StreamPropertyDerivations.StreamProperties> inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.metadata, this.session, this.types, AddLocalExchanges.this.parser));
        }

        private PlanWithProperties accept(PlanNode node, StreamPreferredProperties context) {
            PlanWithProperties result = (PlanWithProperties)node.accept((PlanVisitor)this, (Object)context);
            boolean passStatsEquivalentPlanNode = !(node instanceof TableWriterNode) || !(result.getNode() instanceof TableWriterMergeNode);
            return new PlanWithProperties(passStatsEquivalentPlanNode ? result.getNode().assignStatsEquivalentPlanNode(node.getStatsEquivalentPlanNode()) : result.getNode(), result.getProperties());
        }

        private static /* synthetic */ boolean lambda$pruneMarkDistinctVariables$5(Set redundantVariables, VariableReferenceExpression variable) {
            return !redundantVariables.contains(variable);
        }
    }
}

