/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.ComplexTypeFunctionDescriptor;
import com.facebook.presto.spi.function.LambdaArgumentDescriptor;
import com.facebook.presto.spi.function.LambdaDescriptor;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PushdownSubfields
implements PlanOptimizer {
    public static final QualifiedObjectName CARDINALITY = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"cardinality");
    public static final QualifiedObjectName ELEMENT_AT = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"element_at");
    public static final QualifiedObjectName CAST = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$operator$cast");
    private final Metadata metadata;
    private boolean isEnabledForTesting;

    public PushdownSubfields(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isPushdownSubfieldsEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        if (!this.isEnabled(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        Rewriter rewriter = new Rewriter(session, this.metadata);
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan, new Rewriter.Context());
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
    }

    private static boolean isSubscriptOrElementAtFunction(CallExpression expression, StandardFunctionResolution functionResolution, FunctionAndTypeManager functionAndTypeManager) {
        return functionResolution.isSubscriptFunction(expression.getFunctionHandle()) || functionAndTypeManager.getFunctionMetadata(expression.getFunctionHandle()).getName().equals((Object)ELEMENT_AT);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;
        private final Metadata metadata;
        private final StandardFunctionResolution functionResolution;
        private final ExpressionOptimizer expressionOptimizer;
        private final SubfieldExtractor subfieldExtractor;
        private static final QualifiedObjectName ARBITRARY_AGGREGATE_FUNCTION = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"arbitrary");
        private boolean planChanged;

        public Rewriter(Session session, Metadata metadata) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.functionResolution = new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
            this.expressionOptimizer = new RowExpressionOptimizer(metadata);
            this.subfieldExtractor = new SubfieldExtractor(this.functionResolution, this.expressionOptimizer, session.toConnectorSession(), metadata.getFunctionAndTypeManager(), SystemSessionProperties.isPushdownSubfieldsFromArrayLambdasEnabled(session));
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getGroupingKeys());
            for (Map.Entry entry : node.getAggregations().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
                QualifiedObjectName aggregateName = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(aggregation.getCall().getFunctionHandle()).getName();
                if (ARBITRARY_AGGREGATE_FUNCTION.equals((Object)aggregateName)) {
                    Preconditions.checkState((boolean)(aggregation.getArguments().get(0) instanceof VariableReferenceExpression));
                    context.get().addAssignment(variable, (VariableReferenceExpression)aggregation.getArguments().get(0));
                } else {
                    aggregation.getArguments().forEach(expression -> {
                        Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
                    });
                }
                aggregation.getFilter().ifPresent(expression -> {
                    Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
                });
                aggregation.getOrderBy().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
                aggregation.getMask().ifPresent(context.get().variables::add);
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getCorrelation());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSource().getOutputVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getPredicate().accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
                context.get().addAssignment(entry.getKey(), entry.getValue());
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).forEach(context.get().variables::add);
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).forEach(context.get().variables::add);
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).forEach(context.get().variables::add);
            node.getFilter().ifPresent(expression -> {
                Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
            });
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOutputVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                RowExpression expression = (RowExpression)entry.getValue();
                if (expression instanceof VariableReferenceExpression) {
                    context.get().addAssignment(variable, (VariableReferenceExpression)expression);
                    continue;
                }
                Optional<Subfield> subfield = Rewriter.toSubfield(expression, this.functionResolution, this.expressionOptimizer, this.session.toConnectorSession(), this.metadata.getFunctionAndTypeManager());
                if (subfield.isPresent()) {
                    context.get().addAssignment(variable, subfield.get());
                    continue;
                }
                expression.accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getSourceJoinVariable());
            context.get().variables.add(node.getFilteringSourceJoinVariable());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getFilter().accept((RowExpressionVisitor)this.subfieldExtractor, (Object)context.get());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (context.get().subfields.isEmpty()) {
                return node;
            }
            ImmutableMap.Builder newAssignments = ImmutableMap.builder();
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                if (context.get().variables.contains(variable)) {
                    newAssignments.put(entry);
                    continue;
                }
                List subfields = context.get().findSubfields(variable.getName());
                Verify.verify((!subfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                String columnName = Rewriter.getColumnName(this.session, this.metadata, node.getTable(), (ColumnHandle)entry.getValue());
                List subfieldsWithoutNoSubfield = subfields.stream().filter(subfield -> !Rewriter.containsNoSubfieldPathElement(subfield)).collect(Collectors.toList());
                List subfieldsWithNoSubfield = subfields.stream().filter(subfield -> Rewriter.containsNoSubfieldPathElement(subfield)).collect(Collectors.toList());
                List columnSubfields = subfieldsWithoutNoSubfield.stream().filter(subfield -> !Rewriter.prefixExists(subfield, subfieldsWithoutNoSubfield)).map(Subfield::getPath).map(path -> new Subfield(columnName, path)).collect(Collectors.toList());
                columnSubfields.addAll(subfieldsWithNoSubfield.stream().filter(subfield -> !Rewriter.isPrefixOf(Rewriter.dropNoSubfield(subfield), subfieldsWithoutNoSubfield)).map(Subfield::getPath).map(path -> new Subfield(columnName, path)).collect(Collectors.toList()));
                this.planChanged = true;
                newAssignments.put((Object)variable, (Object)((ColumnHandle)entry.getValue()).withRequiredSubfields((List)ImmutableList.copyOf(columnSubfields)));
            }
            return new TableScanNode(node.getSourceLocation(), node.getId(), node.getTable(), node.getOutputVariables(), (Map)newAssignments.build(), node.getTableConstraints(), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getColumns());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getVariableMapping().entrySet()) {
                ((List)entry.getValue()).forEach(variable -> ((Context)context.get()).addAssignment((VariableReferenceExpression)entry.getKey(), variable));
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            ImmutableList.Builder newSubfields = ImmutableList.builder();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : node.getUnnestVariables().entrySet()) {
                List matchingSubfields;
                VariableReferenceExpression container = entry.getKey();
                boolean found = false;
                if (this.isRowType(container) && !SystemSessionProperties.isLegacyUnnest(this.session)) {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            newSubfields.add((Object)new Subfield(container.getName(), (List)ImmutableList.of((Object)Subfield.allSubscripts(), (Object)Rewriter.nestedField(field.getName()))));
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).add((Object)Rewriter.nestedField(field.getName())).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                } else {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            context.get().variables.add(container);
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                }
                if (found) continue;
                context.get().variables.add(container);
            }
            context.get().subfields.addAll(newSubfields.build());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSpecification().getPartitionBy());
            node.getSpecification().getOrderingScheme().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(CallExpression::getArguments).flatMap(Collection::stream).forEach(expression -> {
                Void cfr_ignored_0 = (Void)expression.accept((RowExpressionVisitor)this.subfieldExtractor, context.get());
            });
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getStartValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getEndValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        private boolean isRowType(VariableReferenceExpression variable) {
            return variable.getType() instanceof ArrayType && ((ArrayType)variable.getType()).getElementType() instanceof RowType;
        }

        private static Subfield dropNoSubfield(Subfield subfield) {
            return new Subfield(subfield.getRootName(), (List)subfield.getPath().stream().filter(pathElement -> !(pathElement instanceof Subfield.NoSubfield)).collect(ImmutableList.toImmutableList()));
        }

        private static boolean containsNoSubfieldPathElement(Subfield subfield) {
            return subfield.getPath().stream().anyMatch(pathElement -> pathElement instanceof Subfield.NoSubfield);
        }

        private static boolean prefixExists(Subfield subfieldPath, Collection<Subfield> subfieldPaths) {
            return subfieldPaths.stream().anyMatch(path -> path.isPrefix(subfieldPath));
        }

        private static boolean isPrefixOf(Subfield subfieldPath, Collection<Subfield> subfieldPaths) {
            return subfieldPaths.stream().anyMatch(arg_0 -> ((Subfield)subfieldPath).isPrefix(arg_0));
        }

        private static String getColumnName(Session session, Metadata metadata, TableHandle tableHandle, ColumnHandle columnHandle) {
            return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
        }

        private static Optional<Subfield> toSubfield(RowExpression expression, StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession, FunctionAndTypeManager functionAndTypeManager) {
            block7: {
                ImmutableList.Builder elements = ImmutableList.builder();
                while (true) {
                    if (expression instanceof VariableReferenceExpression) {
                        return Optional.of(new Subfield(((VariableReferenceExpression)expression).getName(), (List)elements.build().reverse()));
                    }
                    if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.DEREFERENCE) {
                        SpecialFormExpression dereference = (SpecialFormExpression)expression;
                        RowExpression base = (RowExpression)dereference.getArguments().get(0);
                        RowType baseType = (RowType)base.getType();
                        RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)dereference.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                        if (indexExpression instanceof ConstantExpression) {
                            Optional fieldName;
                            Object index = ((ConstantExpression)indexExpression).getValue();
                            Verify.verify((index != null ? 1 : 0) != 0, (String)"Struct field index cannot be null", (Object[])new Object[0]);
                            if (index instanceof Number && (fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) {
                                elements.add((Object)Rewriter.nestedField((String)fieldName.get()));
                                expression = base;
                                continue;
                            }
                        }
                        return Optional.empty();
                    }
                    if (!(expression instanceof CallExpression) || !PushdownSubfields.isSubscriptOrElementAtFunction((CallExpression)expression, functionResolution, functionAndTypeManager)) break block7;
                    List arguments = ((CallExpression)expression).getArguments();
                    RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)arguments.get(1), ExpressionOptimizer.Level.OPTIMIZED, connectorSession);
                    if (!(indexExpression instanceof ConstantExpression)) break;
                    Object index = ((ConstantExpression)indexExpression).getValue();
                    if (index == null) {
                        return Optional.empty();
                    }
                    if (index instanceof Number) {
                        elements.add((Object)new Subfield.LongSubscript(((Number)index).longValue()));
                        expression = (RowExpression)arguments.get(0);
                        continue;
                    }
                    if (!Varchars.isVarcharType((Type)indexExpression.getType())) break;
                    elements.add((Object)new Subfield.StringSubscript(((Slice)index).toStringUtf8()));
                    expression = (RowExpression)arguments.get(0);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private static Subfield.NestedField nestedField(String name) {
            return new Subfield.NestedField(name.toLowerCase(Locale.ENGLISH));
        }

        private static final class Context {
            public static final Set<Subfield> ALL_SUBFIELDS_OF_ARRAY_ELEMENT_OR_MAP_VALUE = ImmutableSet.of((Object)new Subfield("", (List)ImmutableList.of((Object)Subfield.allSubscripts())));
            private final Set<VariableReferenceExpression> variables = new HashSet<VariableReferenceExpression>();
            private final Set<Subfield> subfields = new HashSet<Subfield>();
            private Set<Subfield> lambdaSubfields = ALL_SUBFIELDS_OF_ARRAY_ELEMENT_OR_MAP_VALUE;

            private Context() {
            }

            private void addAssignment(VariableReferenceExpression variable, VariableReferenceExpression otherVariable) {
                if (this.variables.contains(variable)) {
                    this.variables.add(otherVariable);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(otherVariable.getName(), path)).forEach(this.subfields::add);
            }

            private void addAssignment(VariableReferenceExpression variable, Subfield subfield) {
                if (this.variables.contains(variable)) {
                    this.subfields.add(subfield);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(subfield.getRootName(), (List)ImmutableList.builder().addAll((Iterable)subfield.getPath()).addAll((Iterable)path).build())).forEach(this.subfields::add);
            }

            private List<Subfield> findSubfields(String rootName) {
                return (List)this.subfields.stream().filter(subfield -> rootName.equals(subfield.getRootName())).collect(ImmutableList.toImmutableList());
            }

            public void setLambdaSubfields(Set<Subfield> lambdaSubfields) {
                this.lambdaSubfields = lambdaSubfields;
            }

            public Set<Subfield> getLambdaSubfields() {
                return this.lambdaSubfields;
            }

            private void giveUpOnCollectingLambdaSubfields() {
                this.setLambdaSubfields(ALL_SUBFIELDS_OF_ARRAY_ELEMENT_OR_MAP_VALUE);
            }

            private boolean isPruningLambdaSubfieldsPossible() {
                return !this.getLambdaSubfields().isEmpty() && this.getLambdaSubfields().stream().noneMatch(subfield -> subfield.getPath().stream().skip(subfield.getPath().size() - 1).anyMatch(pathElement -> pathElement.equals(Subfield.allSubscripts())));
            }
        }

        private static final class SubfieldExtractor
        extends DefaultRowExpressionTraversalVisitor<Context> {
            private final StandardFunctionResolution functionResolution;
            private final ExpressionOptimizer expressionOptimizer;
            private final ConnectorSession connectorSession;
            private final FunctionAndTypeManager functionAndTypeManager;
            private final boolean isPushDownSubfieldsFromLambdasEnabled;

            private SubfieldExtractor(StandardFunctionResolution functionResolution, ExpressionOptimizer expressionOptimizer, ConnectorSession connectorSession, FunctionAndTypeManager functionAndTypeManager, boolean isPushDownSubfieldsFromLambdasEnabled) {
                this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
                this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimizer is null");
                this.connectorSession = connectorSession;
                this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
                this.isPushDownSubfieldsFromLambdasEnabled = isPushDownSubfieldsFromLambdasEnabled;
            }

            public Void visitCall(CallExpression call, Context context) {
                ComplexTypeFunctionDescriptor functionDescriptor = this.functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle()).getDescriptor();
                if (PushdownSubfields.isSubscriptOrElementAtFunction(call, this.functionResolution, this.functionAndTypeManager)) {
                    Optional subfield = Rewriter.toSubfield((RowExpression)call, this.functionResolution, this.expressionOptimizer, this.connectorSession, this.functionAndTypeManager);
                    if (subfield.isPresent()) {
                        if (context.isPruningLambdaSubfieldsPossible()) {
                            this.addRequiredLambdaSubfields(context, (Subfield)subfield.get());
                        } else {
                            context.subfields.add(subfield.get());
                        }
                    } else {
                        call.getArguments().forEach(argument -> {
                            Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                        });
                    }
                    return null;
                }
                if (!this.isPushDownSubfieldsFromLambdasEnabled) {
                    context.setLambdaSubfields(Context.ALL_SUBFIELDS_OF_ARRAY_ELEMENT_OR_MAP_VALUE);
                    call.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                    return null;
                }
                Set<Subfield> lambdaSubfieldsOriginal = context.getLambdaSubfields();
                if (functionDescriptor.isAccessingInputValues() && functionDescriptor.getLambdaDescriptors().isEmpty()) {
                    context.giveUpOnCollectingLambdaSubfields();
                }
                if (functionDescriptor.getOutputToInputTransformationFunction().isPresent()) {
                    Set transformedLambdaSubfields = (Set)((Function)functionDescriptor.getOutputToInputTransformationFunction().get()).apply(context.getLambdaSubfields());
                    context.setLambdaSubfields((Set<Subfield>)ImmutableSet.copyOf((Collection)transformedLambdaSubfields));
                }
                Set argumentIndicesContainingMapOrArray = (Set)functionDescriptor.getArgumentIndicesContainingMapOrArray().orElse(IntStream.range(0, call.getArguments().size()).filter(argIndex -> SubfieldExtractor.isMapOrArrayOfRowType((RowExpression)call.getArguments().get(argIndex))).boxed().collect(ImmutableSet.toImmutableSet()));
                Map lambdaSubfieldsFromOuterFunctions = (Map)argumentIndicesContainingMapOrArray.stream().collect(ImmutableMap.toImmutableMap(callArgumentIndex -> callArgumentIndex, unused -> ImmutableSet.copyOf(context.getLambdaSubfields())));
                Object lambdaSubfieldsFromCurrentFunction = ImmutableMap.of();
                for (LambdaDescriptor lambdaDescriptor : functionDescriptor.getLambdaDescriptors()) {
                    Optional<Map<Integer, Set<Subfield>>> lambdaSubfields = this.collectLambdaSubfields(call, lambdaDescriptor);
                    if (!lambdaSubfields.isPresent()) {
                        context.giveUpOnCollectingLambdaSubfields();
                        call.getArguments().forEach(argument -> {
                            Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                        });
                        return null;
                    }
                    lambdaSubfieldsFromCurrentFunction = SubfieldExtractor.merge((Map<Integer, Set<Subfield>>)lambdaSubfieldsFromCurrentFunction, lambdaSubfields.get());
                }
                Map<Integer, Set<Subfield>> lambdaSubfields = SubfieldExtractor.merge(lambdaSubfieldsFromOuterFunctions, (Map<Integer, Set<Subfield>>)lambdaSubfieldsFromCurrentFunction);
                lambdaSubfields = SubfieldExtractor.addNoSubfieldIfNoAccessedSubfieldsFound(call, lambdaSubfields);
                for (int callArgumentIndex2 = 0; callArgumentIndex2 < call.getArguments().size(); ++callArgumentIndex2) {
                    if (lambdaSubfields.containsKey(callArgumentIndex2)) {
                        context.setLambdaSubfields(lambdaSubfields.get(callArgumentIndex2));
                    } else {
                        context.setLambdaSubfields(Context.ALL_SUBFIELDS_OF_ARRAY_ELEMENT_OR_MAP_VALUE);
                    }
                    ((RowExpression)call.getArguments().get(callArgumentIndex2)).accept((RowExpressionVisitor)this, (Object)context);
                }
                context.setLambdaSubfields(lambdaSubfieldsOriginal);
                return null;
            }

            private static Map<Integer, Set<Subfield>> merge(Map<Integer, Set<Subfield>> s1, Map<Integer, Set<Subfield>> s2) {
                HashMap<Integer, Set<Subfield>> result = new HashMap<Integer, Set<Subfield>>(s1);
                s2.forEach((callArgumentIndex, subfields) -> result.merge((Integer)callArgumentIndex, (Set<Subfield>)subfields, (lambdaSubfields1, lambdaSubfields2) -> ImmutableSet.builder().addAll((Iterable)lambdaSubfields1).addAll((Iterable)lambdaSubfields2).build()));
                return ImmutableMap.copyOf(result);
            }

            private static Map<Integer, Set<Subfield>> addNoSubfieldIfNoAccessedSubfieldsFound(CallExpression call, Map<Integer, Set<Subfield>> argumentIndexToLambdaSubfieldsMap) {
                ImmutableMap.Builder argumentIndexToLambdaSubfieldsMapBuilder = ImmutableMap.builder();
                for (Integer callArgumentIndex : argumentIndexToLambdaSubfieldsMap.keySet()) {
                    if (!argumentIndexToLambdaSubfieldsMap.get(callArgumentIndex).isEmpty()) {
                        argumentIndexToLambdaSubfieldsMapBuilder.put((Object)callArgumentIndex, argumentIndexToLambdaSubfieldsMap.get(callArgumentIndex));
                        continue;
                    }
                    RowExpression argument = (RowExpression)call.getArguments().get(callArgumentIndex);
                    if (!SubfieldExtractor.isMapOrArrayOfRowType(argument)) continue;
                    argumentIndexToLambdaSubfieldsMapBuilder.put((Object)callArgumentIndex, (Object)ImmutableSet.of((Object)new Subfield("", (List)ImmutableList.of((Object)Subfield.allSubscripts(), (Object)Subfield.noSubfield()))));
                }
                return argumentIndexToLambdaSubfieldsMapBuilder.build();
            }

            private static boolean isMapOrArrayOfRowType(RowExpression argument) {
                return argument.getType() instanceof ArrayType && ((ArrayType)argument.getType()).getElementType() instanceof RowType || argument.getType() instanceof MapType && ((MapType)argument.getType()).getValueType() instanceof RowType;
            }

            private Optional<Map<Integer, Set<Subfield>>> collectLambdaSubfields(CallExpression call, LambdaDescriptor lambdaDescriptor) {
                HashMap argumentIndexToLambdaSubfieldsMap = new HashMap();
                if (!(call.getArguments().get(lambdaDescriptor.getCallArgumentIndex()) instanceof LambdaDefinitionExpression)) {
                    return Optional.empty();
                }
                LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)call.getArguments().get(lambdaDescriptor.getCallArgumentIndex());
                Context subContext = new Context();
                lambda.getBody().accept((RowExpressionVisitor)this, (Object)subContext);
                Iterator iterator = lambdaDescriptor.getLambdaArgumentDescriptors().keySet().iterator();
                while (iterator.hasNext()) {
                    int lambdaArgumentIndex = (Integer)iterator.next();
                    LambdaArgumentDescriptor lambdaArgumentDescriptor = (LambdaArgumentDescriptor)lambdaDescriptor.getLambdaArgumentDescriptors().get(lambdaArgumentIndex);
                    int callArgumentIndex = lambdaArgumentDescriptor.getCallArgumentIndex();
                    argumentIndexToLambdaSubfieldsMap.putIfAbsent(callArgumentIndex, new HashSet());
                    String root = (String)lambda.getArguments().get(lambdaArgumentIndex);
                    if (subContext.variables.stream().anyMatch(variable -> variable.getName().equals(root))) {
                        return Optional.empty();
                    }
                    Set transformedLambdaSubfields = (Set)lambdaArgumentDescriptor.getLambdaArgumentToInputTransformationFunction().apply(subContext.subfields.stream().filter(x -> x.getRootName().equals(root)).collect(ImmutableSet.toImmutableSet()));
                    ((Set)argumentIndexToLambdaSubfieldsMap.get(callArgumentIndex)).addAll(transformedLambdaSubfields);
                }
                return Optional.of(ImmutableMap.copyOf(argumentIndexToLambdaSubfieldsMap));
            }

            public Void visitSpecialForm(SpecialFormExpression specialForm, Context context) {
                Optional subfield;
                if (specialForm.getForm() == SpecialFormExpression.Form.IS_NULL) {
                    if (specialForm.getArguments().get(0) instanceof VariableReferenceExpression && ((RowExpression)specialForm.getArguments().get(0)).getType() instanceof RowType) {
                        context.subfields.add(new Subfield(((VariableReferenceExpression)specialForm.getArguments().get(0)).getName(), (List)ImmutableList.of((Object)Subfield.noSubfield())));
                        return null;
                    }
                } else if (specialForm.getForm() != SpecialFormExpression.Form.DEREFERENCE) {
                    specialForm.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                    return null;
                }
                if ((subfield = Rewriter.toSubfield((RowExpression)specialForm, this.functionResolution, this.expressionOptimizer, this.connectorSession, this.functionAndTypeManager)).isPresent()) {
                    if (context.isPruningLambdaSubfieldsPossible()) {
                        this.addRequiredLambdaSubfields(context, (Subfield)subfield.get());
                    } else {
                        context.subfields.add(subfield.get());
                    }
                } else {
                    specialForm.getArguments().forEach(argument -> {
                        Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
                    });
                }
                return null;
            }

            private void addRequiredLambdaSubfields(Context context, Subfield input) {
                Set<Subfield> lambdaSubfields = context.getLambdaSubfields();
                for (Subfield lambdaSubfield : lambdaSubfields) {
                    ImmutableList newPath = ImmutableList.builder().addAll((Iterable)input.getPath()).addAll((Iterable)lambdaSubfield.getPath()).build();
                    context.subfields.add(new Subfield(input.getRootName(), (List)newPath));
                }
            }

            public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
                if (context.isPruningLambdaSubfieldsPossible()) {
                    this.addRequiredLambdaSubfields(context, (Subfield)Rewriter.toSubfield((RowExpression)reference, this.functionResolution, this.expressionOptimizer, this.connectorSession, this.functionAndTypeManager).get());
                    return null;
                }
                context.variables.add(reference);
                return null;
            }
        }
    }
}

