/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.OperatorInputStats;
import com.facebook.presto.util.Mergeable;
import com.facebook.presto.util.MoreMaps;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PlanNodeStats
implements Mergeable<PlanNodeStats> {
    private final PlanNodeId planNodeId;
    private final Duration planNodeScheduledTime;
    private final Duration planNodeCpuTime;
    private final long planNodeInputPositions;
    private final DataSize planNodeInputDataSize;
    private final long planNodeRawInputPositions;
    private final DataSize planNodeRawInputDataSize;
    private final long planNodeOutputPositions;
    private final DataSize planNodeOutputDataSize;
    protected final Map<String, OperatorInputStats> operatorInputStats;
    private final long planNodeNullJoinBuildKeyCount;
    private final long planNodeJoinBuildKeyCount;
    private final long planNodeNullJoinProbeKeyCount;
    private final long planNodeJoinProbeKeyCount;

    PlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, long planNodeInputPositions, DataSize planNodeInputDataSize, long planNodeRawInputPositions, DataSize planNodeRawInputDataSize, long planNodeOutputPositions, DataSize planNodeOutputDataSize, Map<String, OperatorInputStats> operatorInputStats, long planNodeNullJoinBuildKeyCount, long planNodeJoinBuildKeyCount, long planNodeNullJoinProbeKeyCount, long planNodeJoinProbeKeyCount) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.planNodeScheduledTime = Objects.requireNonNull(planNodeScheduledTime, "planNodeScheduledTime is null");
        this.planNodeCpuTime = Objects.requireNonNull(planNodeCpuTime, "planNodeCpuTime is null");
        this.planNodeInputPositions = planNodeInputPositions;
        this.planNodeInputDataSize = planNodeInputDataSize;
        this.planNodeRawInputPositions = planNodeRawInputPositions;
        this.planNodeRawInputDataSize = planNodeRawInputDataSize;
        this.planNodeOutputPositions = planNodeOutputPositions;
        this.planNodeOutputDataSize = planNodeOutputDataSize;
        this.operatorInputStats = Objects.requireNonNull(operatorInputStats, "operatorInputStats is null");
        this.planNodeNullJoinBuildKeyCount = planNodeNullJoinBuildKeyCount;
        this.planNodeJoinBuildKeyCount = planNodeJoinBuildKeyCount;
        this.planNodeNullJoinProbeKeyCount = planNodeNullJoinProbeKeyCount;
        this.planNodeJoinProbeKeyCount = planNodeJoinProbeKeyCount;
    }

    private static double computedStdDev(double sumSquared, double sum, long n) {
        double average = sum / (double)n;
        double variance = (sumSquared - 2.0 * sum * average + average * average * (double)n) / (double)n;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public Duration getPlanNodeScheduledTime() {
        return this.planNodeScheduledTime;
    }

    public Duration getPlanNodeCpuTime() {
        return this.planNodeCpuTime;
    }

    public Set<String> getOperatorTypes() {
        return this.operatorInputStats.keySet();
    }

    public long getPlanNodeInputPositions() {
        return this.planNodeInputPositions;
    }

    public DataSize getPlanNodeInputDataSize() {
        return this.planNodeInputDataSize;
    }

    public long getPlanNodeRawInputPositions() {
        return this.planNodeRawInputPositions;
    }

    public DataSize getPlanNodeRawInputDataSize() {
        return this.planNodeRawInputDataSize;
    }

    public long getPlanNodeOutputPositions() {
        return this.planNodeOutputPositions;
    }

    public DataSize getPlanNodeOutputDataSize() {
        return this.planNodeOutputDataSize;
    }

    public Map<String, Double> getOperatorInputPositionsAverages() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (double)((OperatorInputStats)entry.getValue()).getInputPositions() / (double)this.operatorInputStats.get(entry.getKey()).getTotalDrivers()));
    }

    public Map<String, Double> getOperatorInputPositionsStdDevs() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PlanNodeStats.computedStdDev(((OperatorInputStats)entry.getValue()).getSumSquaredInputPositions(), ((OperatorInputStats)entry.getValue()).getInputPositions(), ((OperatorInputStats)entry.getValue()).getTotalDrivers())));
    }

    public long getPlanNodeNullJoinBuildKeyCount() {
        return this.planNodeNullJoinBuildKeyCount;
    }

    public long getPlanNodeJoinBuildKeyCount() {
        return this.planNodeJoinBuildKeyCount;
    }

    public long getPlanNodeNullJoinProbeKeyCount() {
        return this.planNodeNullJoinProbeKeyCount;
    }

    public long getPlanNodeJoinProbeKeyCount() {
        return this.planNodeJoinProbeKeyCount;
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals((Object)other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
        long planNodeInputPositions = this.planNodeInputPositions + other.planNodeInputPositions;
        DataSize planNodeInputDataSize = DataSize.succinctBytes((long)(this.planNodeInputDataSize.toBytes() + other.planNodeInputDataSize.toBytes()));
        long planNodeRawInputPositions = this.planNodeRawInputPositions + other.planNodeRawInputPositions;
        DataSize planNodeRawInputDataSize = DataSize.succinctBytes((long)(this.planNodeRawInputDataSize.toBytes() + other.planNodeRawInputDataSize.toBytes()));
        long planNodeOutputPositions = this.planNodeOutputPositions + other.planNodeOutputPositions;
        DataSize planNodeOutputDataSize = DataSize.succinctBytes((long)(this.planNodeOutputDataSize.toBytes() + other.planNodeOutputDataSize.toBytes()));
        Map<String, OperatorInputStats> operatorInputStats = MoreMaps.mergeMaps(this.operatorInputStats, other.operatorInputStats, OperatorInputStats::merge);
        long planNodeNullJoinBuildKeyCount = this.planNodeNullJoinBuildKeyCount + other.planNodeNullJoinBuildKeyCount;
        long planNodeJoinBuildKeyCount = this.planNodeJoinBuildKeyCount + other.planNodeJoinBuildKeyCount;
        long planNodeNullJoinProbeKeyCount = this.planNodeNullJoinProbeKeyCount + other.planNodeNullJoinProbeKeyCount;
        long planNodeJoinProbeKeyCount = this.planNodeJoinProbeKeyCount + other.planNodeJoinProbeKeyCount;
        return new PlanNodeStats(this.planNodeId, new Duration((double)(this.planNodeScheduledTime.toMillis() + other.getPlanNodeScheduledTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeCpuTime.toMillis() + other.getPlanNodeCpuTime().toMillis()), TimeUnit.MILLISECONDS), planNodeInputPositions, planNodeInputDataSize, planNodeRawInputPositions, planNodeRawInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, operatorInputStats, planNodeNullJoinBuildKeyCount, planNodeJoinBuildKeyCount, planNodeNullJoinProbeKeyCount, planNodeJoinProbeKeyCount);
    }
}

