/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.setdigest;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.type.setdigest.SetDigest;
import io.airlift.slice.Slice;
import java.util.Map;

public final class SetDigestFunctions {
    private SetDigestFunctions() {
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="SetDigest") Slice digest) {
        return SetDigest.newInstance(digest).cardinality();
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long intersectionCardinality(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        if (digest1.isExact() && digest2.isExact()) {
            return SetDigest.exactIntersectionCardinality(digest1, digest2);
        }
        long cardinality1 = digest1.cardinality();
        long cardinality2 = digest2.cardinality();
        double jaccard = SetDigest.jaccardIndex(digest1, digest2);
        digest1.mergeWith(digest2);
        long result = Math.round(jaccard * (double)digest1.cardinality());
        return Math.min(result, Math.min(cardinality1, cardinality2));
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double jaccardIndex(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        return SetDigest.jaccardIndex(digest1, digest2);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,smallint)")
    public static Block hashCounts(@TypeParameter(value="map<bigint,smallint>") Type mapType, @SqlType(value="SetDigest") Slice slice) {
        SetDigest digest = SetDigest.newInstance(slice);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry<Long, Short> entry : digest.getHashCounts().entrySet()) {
            BigintType.BIGINT.writeLong(singleMapBlockBuilder, entry.getKey().longValue());
            SmallintType.SMALLINT.writeLong(singleMapBlockBuilder, (long)entry.getValue().shortValue());
        }
        blockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)blockBuilder, 0);
    }
}

