/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.client.ErrorLocation;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Failure;
import com.facebook.presto.spi.ErrorCause;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoTransportException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class Failures {
    private static final String NODE_CRASHED_ERROR = "The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String WORKER_NODE_ERROR = "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String REMOTE_TASK_MISMATCH_ERROR = "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";

    private Failures() {
    }

    public static ExecutionFailureInfo toFailure(Throwable failure) {
        return Failures.toFailure(failure, Sets.newIdentityHashSet());
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, errorMessage);
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static List<ExecutionFailureInfo> toFailures(Collection<? extends Throwable> failures) {
        return (List)failures.stream().map(Failures::toFailure).collect(ImmutableList.toImmutableList());
    }

    private static ExecutionFailureInfo toFailure(Throwable throwable, Set<Throwable> seenFailures) {
        String type;
        if (throwable == null) {
            return null;
        }
        HostAddress remoteHost = null;
        if (throwable instanceof Failure) {
            type = ((Failure)throwable).getType();
        } else {
            Class<?> clazz = throwable.getClass();
            type = (String)MoreObjects.firstNonNull((Object)clazz.getCanonicalName(), (Object)clazz.getName());
        }
        if (throwable instanceof PrestoTransportException) {
            remoteHost = ((PrestoTransportException)throwable).getRemoteHost();
        }
        if (seenFailures.contains(throwable)) {
            return new ExecutionFailureInfo(type, "[cyclic] " + throwable.getMessage(), null, (List<ExecutionFailureInfo>)ImmutableList.of(), (List<String>)ImmutableList.of(), null, StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode(), remoteHost, ErrorCause.UNKNOWN);
        }
        seenFailures.add(throwable);
        ExecutionFailureInfo cause = Failures.toFailure(throwable.getCause(), seenFailures);
        ErrorCode errorCode = Failures.toErrorCode(throwable);
        if (errorCode == null) {
            errorCode = cause == null ? StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode() : cause.getErrorCode();
        }
        return new ExecutionFailureInfo(type, throwable.getMessage(), cause, (List)Arrays.stream(throwable.getSuppressed()).map(failure -> Failures.toFailure(failure, seenFailures)).collect(ImmutableList.toImmutableList()), Lists.transform(Arrays.asList(throwable.getStackTrace()), (Function)Functions.toStringFunction()), Failures.getErrorLocation(throwable), errorCode, remoteHost, Failures.toErrorCause(throwable));
    }

    @Nullable
    private static ErrorLocation getErrorLocation(Throwable throwable) {
        SemanticException e;
        if (throwable instanceof ParsingException) {
            ParsingException e2 = (ParsingException)throwable;
            return new ErrorLocation(e2.getLineNumber(), e2.getColumnNumber());
        }
        if (throwable instanceof SemanticException && (e = (SemanticException)throwable).getLocation().isPresent()) {
            NodeLocation nodeLocation = (NodeLocation)e.getLocation().get();
            return new ErrorLocation(nodeLocation.getLineNumber(), nodeLocation.getColumnNumber());
        }
        return null;
    }

    @Nullable
    private static ErrorCode toErrorCode(Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof PrestoException) {
            return ((PrestoException)throwable).getErrorCode();
        }
        if (throwable instanceof Failure && ((Failure)throwable).getErrorCode() != null) {
            return ((Failure)throwable).getErrorCode();
        }
        if (throwable instanceof ParsingException || throwable instanceof SemanticException) {
            return StandardErrorCode.SYNTAX_ERROR.toErrorCode();
        }
        return null;
    }

    private static ErrorCause toErrorCause(Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof ExceededMemoryLimitException) {
            return ((ExceededMemoryLimitException)((Object)throwable)).getErrorCause();
        }
        return ErrorCause.UNKNOWN;
    }

    public static PrestoException internalError(Throwable t) {
        Throwables.throwIfInstanceOf((Throwable)t, Error.class);
        Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
    }
}

