/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiddenColumns {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
        this.runner.createCatalog((String)SessionTestUtils.TEST_SESSION.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"regionkey", "bigint", "", ""}).row(new Object[]{"name", "varchar(25)", "", ""}).row(new Object[]{"comment", "varchar(152)", "", ""}).build();
        Assert.assertEquals((Iterable)this.runner.execute("DESC REGION"), (Iterable)expected);
    }

    @Test
    public void testSimpleSelect() {
        Assert.assertEquals((Iterable)this.runner.execute("SELECT * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, * from REGION"), (Iterable)this.runner.execute("SELECT row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number, * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, x.row_number from REGION x"), (Iterable)this.runner.execute("SELECT row_number, row_number from REGION"));
    }

    @Test
    public void testAliasedTableColumns() {
        Assert.assertEquals((Iterable)this.runner.execute("SELECT * FROM orders AS t (a, b, c, d, e, f, g, h, i)"), (Iterable)this.runner.execute("SELECT * FROM orders"));
    }
}

