/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public abstract class AbstractTestBlock {
    private static final BlockEncodingSerde BLOCK_ENCODING_SERDE = new BlockEncodingManager();

    protected <T> void assertBlock(Block block, Supplier<BlockBuilder> newBlockBuilder, T[] expectedValues) {
        this.assertBlockSize(block);
        this.assertRetainedSize(block);
        this.assertBlockPositions(block, newBlockBuilder, expectedValues);
        this.assertBlockPositions(AbstractTestBlock.copyBlockViaBlockSerde(block), newBlockBuilder, expectedValues);
        this.assertBlockPositions(AbstractTestBlock.copyBlockViaWritePositionTo(block, newBlockBuilder), newBlockBuilder, expectedValues);
        if (expectedValues.getClass().getComponentType().isArray() || expectedValues.getClass().getComponentType() == List.class || expectedValues.getClass().getComponentType() == Map.class) {
            this.assertBlockPositions(AbstractTestBlock.copyBlockViaWriteStructure(block, newBlockBuilder), newBlockBuilder, expectedValues);
        }
        Block blockWithNull = AbstractTestBlock.copyBlockViaBlockSerde(block).appendNull();
        T[] expectedValuesWithNull = Arrays.copyOf(expectedValues, expectedValues.length + 1);
        this.assertBlockPositions(blockWithNull, newBlockBuilder, expectedValuesWithNull);
        this.assertBlockSize(block);
        this.assertRetainedSize(block);
        try {
            block.isNull(-1);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            block.isNull(block.getPositionCount());
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertRetainedSize(Block block) {
        long retainedSize = ClassLayout.parseClass(block.getClass()).instanceSize();
        Field[] fields = block.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                Class<?> type;
                if (Modifier.isStatic(field.getModifiers()) || (type = field.getType()).isPrimitive()) continue;
                field.setAccessible(true);
                if (type == Slice.class) {
                    Slice slice = (Slice)field.get(block);
                    if (slice == null) continue;
                    retainedSize += slice.getRetainedSize();
                    continue;
                }
                if (type == BlockBuilderStatus.class) {
                    if (field.get(block) == null) continue;
                    retainedSize += (long)BlockBuilderStatus.INSTANCE_SIZE;
                    continue;
                }
                if (type == BlockBuilder.class || type == Block.class) {
                    retainedSize += ((Block)field.get(block)).getRetainedSizeInBytes();
                    continue;
                }
                if (type == BlockBuilder[].class || type == Block[].class) {
                    Block[] blocks;
                    for (Block innerBlock : blocks = (Block[])field.get(block)) {
                        this.assertRetainedSize(innerBlock);
                        retainedSize += innerBlock.getRetainedSizeInBytes();
                    }
                    continue;
                }
                if (type == SliceOutput.class) {
                    retainedSize += ((SliceOutput)field.get(block)).getRetainedSize();
                    continue;
                }
                if (type == int[].class) {
                    retainedSize += SizeOf.sizeOf((int[])((int[])field.get(block)));
                    continue;
                }
                if (type == boolean[].class) {
                    retainedSize += SizeOf.sizeOf((boolean[])((boolean[])field.get(block)));
                    continue;
                }
                if (type == byte[].class) {
                    retainedSize += SizeOf.sizeOf((byte[])((byte[])field.get(block)));
                    continue;
                }
                if (type == long[].class) {
                    retainedSize += SizeOf.sizeOf((long[])((long[])field.get(block)));
                    continue;
                }
                if (type == short[].class) {
                    retainedSize += SizeOf.sizeOf((short[])((short[])field.get(block)));
                    continue;
                }
                if (type == DictionaryId.class) {
                    retainedSize += (long)ClassLayout.parseClass(DictionaryId.class).instanceSize();
                    continue;
                }
                if (type == AbstractMapBlock.HashTables.class) {
                    retainedSize += ((AbstractMapBlock.HashTables)field.get(block)).getRetainedSizeInBytes();
                    continue;
                }
                if (type == MethodHandle.class) continue;
                throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
            }
        }
        catch (IllegalAccessException t) {
            throw new RuntimeException(t);
        }
        Assert.assertEquals((long)block.getRetainedSizeInBytes(), (long)retainedSize);
    }

    protected <T> void assertBlockFilteredPositions(T[] expectedValues, Block block, Supplier<BlockBuilder> newBlockBuilder, int ... positions) {
        Block filteredBlock = block.copyPositions(positions, 0, positions.length);
        T[] filteredExpectedValues = AbstractTestBlock.filter(expectedValues, positions);
        Assert.assertEquals((int)filteredBlock.getPositionCount(), (int)positions.length);
        this.assertBlock(filteredBlock, newBlockBuilder, filteredExpectedValues);
    }

    private static <T> T[] filter(T[] expectedValues, int[] positions) {
        Object[] prunedExpectedValues = (Object[])Array.newInstance(expectedValues.getClass().getComponentType(), positions.length);
        for (int i = 0; i < prunedExpectedValues.length; ++i) {
            prunedExpectedValues[i] = expectedValues[positions[i]];
        }
        return prunedExpectedValues;
    }

    private <T> void assertBlockPositions(Block block, Supplier<BlockBuilder> newBlockBuilder, T[] expectedValues) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.assertBlockPosition(block, newBlockBuilder, position, expectedValues[position], expectedValues.getClass().getComponentType());
        }
    }

    protected List<Block> splitBlock(Block block, int count) {
        double sizePerSplit = (double)block.getPositionCount() * 1.0 / (double)count;
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            int startPosition = Math.toIntExact(Math.round(sizePerSplit * (double)i));
            int endPosition = Math.toIntExact(Math.round(sizePerSplit * (double)(i + 1)));
            result.add((Object)block.getRegion(startPosition, endPosition - startPosition));
        }
        return result.build();
    }

    private void assertBlockSize(Block block) {
        OptionalInt fixedSizeInBytesPerPosition = block.fixedSizeInBytesPerPosition();
        if (fixedSizeInBytesPerPosition.isPresent()) {
            Assert.assertEquals((long)((long)fixedSizeInBytesPerPosition.getAsInt() * (long)block.getPositionCount()), (long)block.getSizeInBytes());
        }
        long expectedBlockSize = AbstractTestBlock.copyBlockViaBlockSerde(block).getSizeInBytes();
        Assert.assertEquals((long)block.getSizeInBytes(), (long)expectedBlockSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(0, block.getPositionCount()), (long)expectedBlockSize);
        long logicalSizeInBytes = block.getLogicalSizeInBytes();
        long expectedLogicalBlockSize = AbstractTestBlock.copyBlockViaBlockSerde(block).getLogicalSizeInBytes();
        Assert.assertEquals((long)logicalSizeInBytes, (long)expectedLogicalBlockSize);
        Assert.assertEquals((long)block.getRegionLogicalSizeInBytes(0, block.getPositionCount()), (long)expectedLogicalBlockSize);
        long approximateLogicalSizeInBytes = block.getApproximateRegionLogicalSizeInBytes(0, block.getPositionCount());
        long expectedApproximateLogicalBlockSize = expectedLogicalBlockSize;
        if (block instanceof DictionaryBlock) {
            int dictionaryPositionCount = ((DictionaryBlock)block).getDictionary().getPositionCount();
            expectedApproximateLogicalBlockSize = ((DictionaryBlock)block).getDictionary().getApproximateRegionLogicalSizeInBytes(0, dictionaryPositionCount) * (long)block.getPositionCount() / (long)dictionaryPositionCount;
        }
        Assert.assertEquals((long)approximateLogicalSizeInBytes, (long)expectedApproximateLogicalBlockSize);
        List<Block> splitBlock = this.splitBlock(block, 2);
        Block firstHalf = splitBlock.get(0);
        int firstHalfPositionCount = firstHalf.getPositionCount();
        long expectedFirstHalfSize = AbstractTestBlock.copyBlockViaBlockSerde(firstHalf).getSizeInBytes();
        Assert.assertEquals((long)firstHalf.getSizeInBytes(), (long)expectedFirstHalfSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(0, firstHalfPositionCount), (long)expectedFirstHalfSize);
        long firstHalfLogicalSizeInBytes = firstHalf.getLogicalSizeInBytes();
        long expectedFirstHalfLogicalSize = AbstractTestBlock.copyBlockViaBlockSerde(firstHalf).getLogicalSizeInBytes();
        Assert.assertEquals((long)firstHalfLogicalSizeInBytes, (long)expectedFirstHalfLogicalSize);
        Assert.assertEquals((long)firstHalf.getRegionLogicalSizeInBytes(0, firstHalfPositionCount), (long)expectedFirstHalfLogicalSize);
        long approximateFirstHalfLogicalSize = firstHalf.getApproximateRegionLogicalSizeInBytes(0, firstHalfPositionCount);
        long expectedApproximateFirstHalfLogicalSize = expectedFirstHalfLogicalSize;
        if (firstHalf instanceof DictionaryBlock) {
            int dictionaryPositionCount = ((DictionaryBlock)firstHalf).getDictionary().getPositionCount();
            expectedApproximateFirstHalfLogicalSize = ((DictionaryBlock)firstHalf).getDictionary().getApproximateRegionLogicalSizeInBytes(0, dictionaryPositionCount) * (long)firstHalfPositionCount / (long)dictionaryPositionCount;
        }
        Assert.assertEquals((long)approximateFirstHalfLogicalSize, (long)expectedApproximateFirstHalfLogicalSize);
        long expectedApproximateFirstHalfLogicalSizeFromUnsplittedBlock = logicalSizeInBytes == 0L ? approximateLogicalSizeInBytes : approximateLogicalSizeInBytes * firstHalfLogicalSizeInBytes / logicalSizeInBytes;
        Assertions.assertBetweenInclusive((Comparable)Long.valueOf(approximateFirstHalfLogicalSize), (Comparable)Long.valueOf(Math.min(expectedApproximateFirstHalfLogicalSizeFromUnsplittedBlock - 3L, (long)((double)expectedApproximateFirstHalfLogicalSizeFromUnsplittedBlock * 0.7))), (Comparable)Long.valueOf(Math.max(expectedApproximateFirstHalfLogicalSizeFromUnsplittedBlock + 3L, (long)((double)expectedApproximateFirstHalfLogicalSizeFromUnsplittedBlock * 1.3))));
        Block secondHalf = splitBlock.get(1);
        int secondHalfPositionCount = secondHalf.getPositionCount();
        long expectedSecondHalfSize = AbstractTestBlock.copyBlockViaBlockSerde(secondHalf).getSizeInBytes();
        Assert.assertEquals((long)secondHalf.getSizeInBytes(), (long)expectedSecondHalfSize);
        Assert.assertEquals((long)block.getRegionSizeInBytes(firstHalfPositionCount, secondHalfPositionCount), (long)expectedSecondHalfSize);
        long secondHalfLogicalSizeInBytes = secondHalf.getLogicalSizeInBytes();
        long expectedSecondHalfLogicalSize = AbstractTestBlock.copyBlockViaBlockSerde(secondHalf).getLogicalSizeInBytes();
        Assert.assertEquals((long)secondHalfLogicalSizeInBytes, (long)expectedSecondHalfLogicalSize);
        Assert.assertEquals((long)secondHalf.getRegionLogicalSizeInBytes(0, secondHalfPositionCount), (long)expectedSecondHalfLogicalSize);
        long approximateSecondHalfLogicalSize = secondHalf.getApproximateRegionLogicalSizeInBytes(0, secondHalfPositionCount);
        long expectedApproximateSecondHalfLogicalSize = AbstractTestBlock.copyBlockViaBlockSerde(secondHalf).getApproximateRegionLogicalSizeInBytes(0, secondHalfPositionCount);
        if (secondHalf instanceof DictionaryBlock) {
            int dictionaryPositionCount = ((DictionaryBlock)secondHalf).getDictionary().getPositionCount();
            expectedApproximateSecondHalfLogicalSize = ((DictionaryBlock)secondHalf).getDictionary().getApproximateRegionLogicalSizeInBytes(0, dictionaryPositionCount) * (long)secondHalfPositionCount / (long)dictionaryPositionCount;
        }
        Assert.assertEquals((long)approximateSecondHalfLogicalSize, (long)expectedApproximateSecondHalfLogicalSize);
        long expectedApproximateSecondHalfLogicalSizeFromUnsplittedBlock = logicalSizeInBytes == 0L ? approximateLogicalSizeInBytes : approximateLogicalSizeInBytes * secondHalfLogicalSizeInBytes / logicalSizeInBytes;
        Assertions.assertBetweenInclusive((Comparable)Long.valueOf(approximateSecondHalfLogicalSize), (Comparable)Long.valueOf(Math.min(expectedApproximateSecondHalfLogicalSizeFromUnsplittedBlock - 3L, (long)((double)expectedApproximateSecondHalfLogicalSizeFromUnsplittedBlock * 0.7))), (Comparable)Long.valueOf(Math.max(expectedApproximateSecondHalfLogicalSizeFromUnsplittedBlock + 3L, (long)((double)expectedApproximateSecondHalfLogicalSizeFromUnsplittedBlock * 1.3))));
        boolean[] positions = new boolean[block.getPositionCount()];
        Arrays.fill(positions, 0, firstHalfPositionCount, true);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions, firstHalfPositionCount), (long)expectedFirstHalfSize);
        Arrays.fill(positions, true);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions, positions.length), (long)expectedBlockSize);
        Arrays.fill(positions, 0, firstHalfPositionCount, false);
        Assert.assertEquals((long)block.getPositionsSizeInBytes(positions, positions.length - firstHalfPositionCount), (long)expectedSecondHalfSize);
    }

    protected <T> void assertBlockPosition(Block block, Supplier<BlockBuilder> newBlockBuilder, int position, T expectedValue, Class<?> expectedValueType) {
        this.assertPositionValue(block, position, expectedValue);
        this.assertPositionValue(block.getSingleValueBlock(position), 0, expectedValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, 1)), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(0, position + 1)), position, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, block.getPositionCount() - position)), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(position, 1), newBlockBuilder), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(0, position + 1), newBlockBuilder), position, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaWritePositionTo(block.getRegion(position, block.getPositionCount() - position), newBlockBuilder), 0, expectedValue);
        if (expectedValueType.isArray() || expectedValueType == List.class || expectedValueType == Map.class) {
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(position, 1), newBlockBuilder), 0, expectedValue);
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(0, position + 1), newBlockBuilder), position, expectedValue);
            this.assertPositionValue(AbstractTestBlock.copyBlockViaWriteStructure(block.getRegion(position, block.getPositionCount() - position), newBlockBuilder), 0, expectedValue);
        }
        this.assertPositionValue(block.copyRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.copyRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.copyRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(block.copyPositions(new int[]{position}, 0, 1), 0, expectedValue);
    }

    private <T> void assertPositionValue(Block block, int position, T expectedValue) {
        this.assertCheckedPositionValue(block, position, expectedValue);
        this.assertPositionValueUnchecked(block, position + block.getOffsetBase(), expectedValue);
    }

    protected <T> void assertCheckedPositionValue(Block block, int position, T expectedValue) {
        this.assertPositionValueUnchecked(block, position + block.getOffsetBase(), expectedValue);
        if (expectedValue == null) {
            Assert.assertTrue((boolean)block.isNull(position));
            return;
        }
        Assert.assertFalse((boolean)block.isNull(position));
        if (expectedValue instanceof Slice) {
            Slice expectedSliceValue = (Slice)expectedValue;
            if (this.isByteAccessSupported() && expectedSliceValue.length() >= 1) {
                Assert.assertEquals((byte)block.getByte(position), (byte)expectedSliceValue.getByte(0));
            }
            if (this.isShortAccessSupported() && expectedSliceValue.length() >= 2) {
                Assert.assertEquals((short)block.getShort(position), (short)expectedSliceValue.getShort(0));
            }
            if (this.isIntAccessSupported() && expectedSliceValue.length() >= 4) {
                Assert.assertEquals((int)block.getInt(position), (int)expectedSliceValue.getInt(0));
            }
            if (this.isIntAccessSupported() && expectedSliceValue.length() >= 8) {
                Assert.assertEquals((long)block.getLong(position), (long)expectedSliceValue.getLong(0));
            }
            if (this.isAlignedLongAccessSupported()) {
                for (int offset = 0; offset <= expectedSliceValue.length() - 8; offset += 8) {
                    Assert.assertEquals((long)block.getLong(position, offset), (long)expectedSliceValue.getLong(offset));
                }
            }
            if (this.isSliceAccessSupported()) {
                Assert.assertEquals((int)block.getSliceLength(position), (int)expectedSliceValue.length());
                this.assertSlicePosition(block, position, expectedSliceValue);
            }
        } else if (expectedValue instanceof long[]) {
            Block actual = block.getBlock(position);
            long[] expected = (long[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((long)BigintType.BIGINT.getLong(actual, i), (long)expected[i]);
            }
        } else if (expectedValue instanceof Slice[]) {
            Block actual = block.getBlock(position);
            Slice[] expected = (Slice[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(actual, i), (Object)expected[i]);
            }
        } else if (expectedValue instanceof long[][]) {
            Block actual = block.getBlock(position);
            long[][] expected = (long[][])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                this.assertPositionValue(actual, i, expected[i]);
            }
        } else {
            Assert.fail((String)("Unexpected type: " + expectedValue.getClass().getSimpleName()));
        }
    }

    protected <T> void assertPositionValueUnchecked(Block block, int internalPosition, T expectedValue) {
        if (expectedValue == null) {
            Assert.assertTrue((boolean)block.isNullUnchecked(internalPosition));
            return;
        }
        Assert.assertFalse((block.mayHaveNull() && block.isNullUnchecked(internalPosition) ? 1 : 0) != 0);
        if (expectedValue instanceof Slice) {
            Slice expectedSliceValue = (Slice)expectedValue;
            if (this.isByteAccessSupported() && expectedSliceValue.length() >= 1) {
                Assert.assertEquals((byte)block.getByteUnchecked(internalPosition), (byte)expectedSliceValue.getByte(0));
            }
            if (this.isShortAccessSupported() && expectedSliceValue.length() >= 2) {
                Assert.assertEquals((short)block.getShortUnchecked(internalPosition), (short)expectedSliceValue.getShort(0));
            }
            if (this.isIntAccessSupported() && expectedSliceValue.length() >= 4) {
                Assert.assertEquals((int)block.getIntUnchecked(internalPosition), (int)expectedSliceValue.getInt(0));
            }
            if (this.isIntAccessSupported() && expectedSliceValue.length() >= 8) {
                Assert.assertEquals((long)block.getLongUnchecked(internalPosition), (long)expectedSliceValue.getLong(0));
            }
            if (this.isAlignedLongAccessSupported()) {
                for (int offset = 0; offset <= expectedSliceValue.length() - 8; offset += 8) {
                    Assert.assertEquals((long)block.getLongUnchecked(internalPosition, offset), (long)expectedSliceValue.getLong(offset));
                }
            }
            if (this.isSliceAccessSupported()) {
                Assert.assertEquals((int)block.getSliceLengthUnchecked(internalPosition), (int)expectedSliceValue.length());
                this.assertSlicePositionUnchecked(block, internalPosition, expectedSliceValue);
            }
        } else if (expectedValue instanceof long[]) {
            Block actual = block.getBlockUnchecked(internalPosition);
            long[] expected = (long[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < actual.getPositionCount(); ++i) {
                Assert.assertEquals((long)BigintType.BIGINT.getLongUnchecked((UncheckedBlock)actual, i + actual.getOffsetBase()), (long)expected[i]);
            }
        } else if (expectedValue instanceof Slice[]) {
            Block actual = block.getBlockUnchecked(internalPosition);
            Slice[] expected = (Slice[])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(actual, i), (Object)expected[i]);
            }
        } else if (expectedValue instanceof long[][]) {
            Block actual = block.getBlockUnchecked(internalPosition);
            long[][] expected = (long[][])expectedValue;
            Assert.assertEquals((int)actual.getPositionCount(), (int)expected.length);
            for (int i = 0; i < expected.length; ++i) {
                this.assertPositionValue(actual, i, expected[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void assertSlicePosition(Block block, int position, Slice expectedSliceValue) {
        int length = block.getSliceLength(position);
        Assert.assertEquals((int)length, (int)expectedSliceValue.length());
        Block expectedBlock = AbstractTestBlock.toSingeValuedBlock(expectedSliceValue);
        for (int offset = 0; offset < length - 3; ++offset) {
            Assert.assertEquals((Object)block.getSlice(position, offset, 3), (Object)expectedSliceValue.slice(offset, 3));
            Assert.assertTrue((boolean)block.bytesEqual(position, offset, expectedSliceValue, offset, 3));
            Assert.assertFalse((boolean)block.bytesEqual(position, offset, Slices.utf8Slice((String)"XXX"), 0, 3));
            Assert.assertEquals((int)block.bytesCompare(position, offset, 3, expectedSliceValue, offset, 3), (int)0);
            Assert.assertTrue((block.bytesCompare(position, offset, 3, expectedSliceValue, offset, 2) > 0 ? 1 : 0) != 0);
            Slice greaterSlice = AbstractTestBlock.createGreaterValue(expectedSliceValue, offset, 3);
            Assert.assertTrue((block.bytesCompare(position, offset, 3, greaterSlice, 0, greaterSlice.length()) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)block.equals(position, offset, expectedBlock, 0, offset, 3));
            Assert.assertEquals((int)block.compareTo(position, offset, 3, expectedBlock, 0, offset, 3), (int)0);
            BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
            block.writeBytesTo(position, offset, 3, blockBuilder);
            blockBuilder.closeEntry();
            Block segment = blockBuilder.build();
            Assert.assertTrue((boolean)block.equals(position, offset, segment, 0, 0, 3));
        }
    }

    protected void assertSlicePositionUnchecked(Block block, int internalPosition, Slice expectedSliceValue) {
        int length = block.getSliceLengthUnchecked(internalPosition);
        Assert.assertEquals((int)length, (int)expectedSliceValue.length());
        Block expectedBlock = AbstractTestBlock.toSingeValuedBlock(expectedSliceValue);
        for (int offset = 0; offset < length - 3; ++offset) {
            Assert.assertEquals((Object)block.getSliceUnchecked(internalPosition, offset, 3), (Object)expectedSliceValue.slice(offset, 3));
            Assert.assertTrue((boolean)block.bytesEqual(internalPosition - block.getOffsetBase(), offset, expectedSliceValue, offset, 3));
            Assert.assertFalse((boolean)block.bytesEqual(internalPosition - block.getOffsetBase(), offset, Slices.utf8Slice((String)UUID.randomUUID().toString()), 0, 3));
            Assert.assertEquals((int)block.bytesCompare(internalPosition - block.getOffsetBase(), offset, 3, expectedSliceValue, offset, 3), (int)0);
            Assert.assertTrue((block.bytesCompare(internalPosition - block.getOffsetBase(), offset, 3, expectedSliceValue, offset, 2) > 0 ? 1 : 0) != 0);
            Slice greaterSlice = AbstractTestBlock.createGreaterValue(expectedSliceValue, offset, 3);
            Assert.assertTrue((block.bytesCompare(internalPosition - block.getOffsetBase(), offset, 3, greaterSlice, 0, greaterSlice.length()) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)block.equals(internalPosition - block.getOffsetBase(), offset, expectedBlock, 0, offset, 3));
            Assert.assertEquals((int)block.compareTo(internalPosition - block.getOffsetBase(), offset, 3, expectedBlock, 0, offset, 3), (int)0);
            BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
            block.writeBytesTo(internalPosition - block.getOffsetBase(), offset, 3, blockBuilder);
            blockBuilder.closeEntry();
            Block segment = blockBuilder.build();
            Assert.assertTrue((boolean)block.equals(internalPosition - block.getOffsetBase(), offset, segment, 0, 0, 3));
        }
    }

    protected boolean isByteAccessSupported() {
        return true;
    }

    protected boolean isShortAccessSupported() {
        return true;
    }

    protected boolean isIntAccessSupported() {
        return true;
    }

    protected boolean isLongAccessSupported() {
        return true;
    }

    protected boolean isAlignedLongAccessSupported() {
        return false;
    }

    protected boolean isSliceAccessSupported() {
        return true;
    }

    private static Block copyBlockViaBlockSerde(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        BLOCK_ENCODING_SERDE.writeBlock((SliceOutput)sliceOutput, block);
        return BLOCK_ENCODING_SERDE.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block copyBlockViaWritePositionTo(Block block, Supplier<BlockBuilder> newBlockBuilder) {
        BlockBuilder blockBuilder = newBlockBuilder.get();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                blockBuilder.appendNull();
                continue;
            }
            block.writePositionTo(i, blockBuilder);
        }
        return blockBuilder.build();
    }

    private static Block copyBlockViaWriteStructure(Block block, Supplier<BlockBuilder> newBlockBuilder) {
        BlockBuilder blockBuilder = newBlockBuilder.get();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.appendStructure(block.getBlock(i));
        }
        return blockBuilder.build();
    }

    private static Block toSingeValuedBlock(Slice expectedValue) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1, expectedValue.length());
        VarbinaryType.VARBINARY.writeSlice(blockBuilder, expectedValue);
        return blockBuilder.build();
    }

    private static Slice createGreaterValue(Slice expectedValue, int offset, int length) {
        DynamicSliceOutput greaterOutput = new DynamicSliceOutput(length + 1);
        greaterOutput.writeBytes(expectedValue, offset, length);
        greaterOutput.writeByte(95);
        return greaterOutput.slice();
    }

    protected static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = AbstractTestBlock.createExpectedValue(position);
        }
        return expectedValues;
    }

    protected static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    protected static <T> T[] alternatingNullValues(T[] objects) {
        T[] objectsWithNulls = Arrays.copyOf(objects, objects.length * 2 + 1);
        for (int i = 0; i < objects.length; ++i) {
            objectsWithNulls[i * 2] = null;
            objectsWithNulls[i * 2 + 1] = objects[i];
        }
        objectsWithNulls[objectsWithNulls.length - 1] = null;
        return objectsWithNulls;
    }

    protected static Slice[] createExpectedUniqueValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = Slices.copyOf((Slice)AbstractTestBlock.createExpectedValue(position));
        }
        return expectedValues;
    }

    protected static void assertEstimatedDataSizeForStats(BlockBuilder blockBuilder, Slice[] expectedSliceValues) {
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedSliceValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = expectedSliceValues[i] == null ? 0 : expectedSliceValues[i].length();
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
        BlockBuilder nullValueBlockBuilder = blockBuilder.newBlockBuilderLike(null).appendNull();
        Assert.assertEquals((long)nullValueBlockBuilder.getEstimatedDataSizeForStats(0), (long)0L);
        Assert.assertEquals((long)nullValueBlockBuilder.build().getEstimatedDataSizeForStats(0), (long)0L);
    }

    protected static void testCopyRegionCompactness(Block block) {
        AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount()));
        if (block.getPositionCount() > 0) {
            AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount() - 1));
            AbstractTestBlock.assertCompact(block.copyRegion(1, block.getPositionCount() - 1));
        }
    }

    protected static void assertCompact(Block block) {
        Assert.assertSame((Object)block.copyRegion(0, block.getPositionCount()), (Object)block);
    }

    protected static void assertNotCompact(Block block) {
        Assert.assertNotSame((Object)block.copyRegion(0, block.getPositionCount()), (Object)block);
    }

    protected static void testCompactBlock(Block block) {
        AbstractTestBlock.assertCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }

    protected static void testIncompactBlock(Block block) {
        AbstractTestBlock.assertNotCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }
}

