/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.client.DriftClient;
import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.ExceptionClassification;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.server.DriftServer;
import com.facebook.drift.server.guice.DriftServerBinder;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvokerFactory;
import com.facebook.drift.transport.netty.server.DriftNettyServerModule;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.udf.PrestoThriftPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfPage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.net.HostAndPort;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkThriftUdfPageSerDe {
    private static final int POSITIONS_PER_PAGE = 10000;
    private static final FunctionAndTypeManager TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final PagesSerde PAGE_SERDE = new PagesSerde((BlockEncodingSerde)new BlockEncodingManager(), Optional.empty(), Optional.empty(), Optional.empty());

    @Benchmark
    public void testThriftPageSerde(BenchmarkData data) {
        if (data.typeSignature.indexOf("map") < 0) {
            Assert.assertTrue((boolean)((ThriftTestService)BenchmarkData.thriftTestService.get()).test(ThriftUdfPage.thriftPage((PrestoThriftPage)new PrestoThriftPage((List)ImmutableList.of((Object)PrestoThriftBlock.fromBlock((Block)data.page.getBlock(0), (Type)TYPE_MANAGER.getType(TypeSignature.parseTypeSignature((String)data.typeSignature)))), data.page.getPositionCount())), data.typeSignature));
        }
    }

    @Benchmark
    public void testSerializedPageSerde(BenchmarkData data) {
        Assert.assertTrue((boolean)((ThriftTestService)BenchmarkData.thriftTestService.get()).test(ThriftUdfPage.prestoPage((SerializedPage)PAGE_SERDE.serialize(data.page)), data.typeSignature));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).jvmArgs(new String[]{"-Xmx10g"}).include(".*" + BenchmarkThriftUdfPageSerDe.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    public static class ThriftTestServiceImplementation
    implements ThriftTestService {
        @Override
        public boolean test(ThriftUdfPage input, String type) {
            switch (input.getPageFormat()) {
                case PRESTO_THRIFT: {
                    return ((PrestoThriftBlock)input.getThriftPage().getThriftBlocks().get(0)).toBlock(TYPE_MANAGER.getType(TypeSignature.parseTypeSignature((String)type))) != null;
                }
                case PRESTO_SERIALIZED: {
                    return PAGE_SERDE.deserialize(input.getPrestoPage().toSerializedPage()) != null;
                }
            }
            return false;
        }
    }

    @ThriftService(value="test", idlName="test")
    public static interface ThriftTestService {
        @ThriftMethod
        public boolean test(ThriftUdfPage var1, String var2);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"boolean", "bigint", "varchar", "array<bigint>", "map<int, real>"})
        private String typeSignature;
        private Page page;
        private static DriftClient<ThriftTestService> thriftTestService;
        private static DriftServer server;

        @Setup
        public void setup() {
            Bootstrap app = new Bootstrap(new Module[]{new DriftNettyServerModule(), binder -> binder.bind(ThriftTestServiceImplementation.class).in(Scopes.SINGLETON), binder -> binder.bind(ThriftTestService.class).to(ThriftTestServiceImplementation.class), binder -> DriftServerBinder.driftServerBinder((Binder)binder).bindService(ThriftTestServiceImplementation.class)});
            Injector injector = app.setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"thrift.server.port", (Object)"7779")).doNotInitializeLogging().initialize();
            server = (DriftServer)injector.getInstance(DriftServer.class);
            ThriftCodecManager codecManager = new ThriftCodecManager(new ThriftCodec[0]);
            Closer closer = Closer.create();
            MethodInvokerFactory methodInvokerFactory = (MethodInvokerFactory)closer.register((Closeable)DriftNettyMethodInvokerFactory.createStaticDriftNettyMethodInvokerFactory((DriftNettyClientConfig)new DriftNettyClientConfig()));
            DriftClientFactory clientFactory = new DriftClientFactory(codecManager, methodInvokerFactory, (AddressSelector)new SimpleAddressSelector((Iterable)ImmutableList.of((Object)HostAndPort.fromParts((String)"localhost", (int)7779)), true), throwable -> new ExceptionClassification(Optional.of(true), ExceptionClassification.HostStatus.NORMAL));
            thriftTestService = clientFactory.createDriftClient(ThriftTestService.class);
            Type type = TYPE_MANAGER.getType(TypeSignature.parseTypeSignature((String)this.typeSignature));
            Block block = BlockAssertions.createRandomBlockForType(type, 10000, 0.0f, 0.0f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
            this.page = new Page(10000, new Block[]{block});
        }

        @TearDown
        public void teardown() {
            server.shutdown();
        }
    }
}

