/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayBlock
extends AbstractTestBlock {
    private static final int[] ARRAY_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void testWithFixedWidthBlock() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        long[][] expectedValuesWithNull = (long[][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithVariableWidthBlock() {
        Slice[][] expectedValues = new Slice[ARRAY_SIZES.length][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new Slice[ARRAY_SIZES[i]];
            for (int j = 0; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Slice[][] expectedValuesWithNull = (Slice[][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithArrayBlock() {
        long[][][] expectedValues = TestArrayBlock.createExpectedValues();
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        long[][][] expectedValuesWithNull = (long[][][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testSingleValueBlock() {
        Object values = TestArrayBlock.createTestArray(50);
        BlockBuilder arrayBlockBuilder = TestArrayBlock.createBlockBuilderWithValues(values);
        Block arrayBlock = arrayBlockBuilder.build();
        Assert.assertSame((Object)arrayBlock, (Object)arrayBlock.getSingleValueBlock(0));
        Assert.assertNotSame((Object)arrayBlockBuilder, (Object)arrayBlockBuilder.getSingleValueBlock(0));
        values = TestArrayBlock.createTestArray(50, 50);
        arrayBlockBuilder = TestArrayBlock.createBlockBuilderWithValues(values);
        arrayBlock = arrayBlockBuilder.build();
        Block firstElement = arrayBlock.getRegion(0, 1);
        Assert.assertNotSame((Object)firstElement, (Object)firstElement.getSingleValueBlock(0));
        Block secondElementCopy = arrayBlock.copyRegion(1, 1);
        Assert.assertSame((Object)secondElementCopy, (Object)secondElementCopy.getSingleValueBlock(0));
        values = new long[][]{null};
        arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 1, 100);
        TestArrayBlock.writeValues(values, arrayBlockBuilder);
        arrayBlock = arrayBlockBuilder.build();
        Assert.assertSame((Object)arrayBlock, (Object)arrayBlock.getSingleValueBlock(0));
        Assert.assertNotSame((Object)arrayBlock, (Object)arrayBlockBuilder.getSingleValueBlock(0));
        values = new long[][]{null, null};
        arrayBlockBuilder = TestArrayBlock.createBlockBuilderWithValues(values);
        arrayBlock = arrayBlockBuilder.build();
        Assert.assertNotSame((Object)arrayBlock, (Object)arrayBlock.getSingleValueBlock(0));
    }

    private static long[][] createTestArray(int ... entryCounts) {
        long[][] result = new long[entryCounts.length][];
        for (int rowNumber = 0; rowNumber < entryCounts.length; ++rowNumber) {
            int entryCount = entryCounts[rowNumber];
            long[] array = new long[entryCount];
            for (int entryNumber = 0; entryNumber < entryCount; ++entryNumber) {
                array[entryNumber] = entryNumber;
            }
            result[rowNumber] = array;
        }
        return result;
    }

    private static long[][][] createExpectedValues() {
        long[][][] expectedValues = new long[ARRAY_SIZES.length][][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new long[ARRAY_SIZES[i]][];
            for (int j = 1; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = (long[])((i + j) % 5 == 0 ? null : new long[]{i, j, i + j});
            }
        }
        return expectedValues;
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        ArrayBlockBuilder emptyBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 0, 0);
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        long[][][] expectedValues = (long[][][])TestArrayBlock.alternatingNullValues(TestArrayBlock.createExpectedValues());
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestArrayBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    @Test
    public void testLogicalSizeInBytes() {
        int positionCount = 100;
        int[] offsets = IntStream.rangeClosed(0, positionCount).toArray();
        boolean[] nulls = new boolean[positionCount];
        Block arrayOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createRandomLongsBlock(positionCount, 0.0f));
        Assert.assertEquals((long)arrayOfLong.getLogicalSizeInBytes(), (long)1400L);
        Block arrayOfRleOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createRLEBlock(1L, 100));
        Assert.assertEquals((long)arrayOfRleOfLong.getLogicalSizeInBytes(), (long)1400L);
        Block arrayOfRleOfArrayOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createRleBlockWithRandomValue(arrayOfLong, 100));
        Assert.assertEquals((long)arrayOfRleOfArrayOfLong.getLogicalSizeInBytes(), (long)1900L);
        Block arrayOfDictionaryOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createLongDictionaryBlock(0, 100));
        Assert.assertEquals((long)arrayOfDictionaryOfLong.getLogicalSizeInBytes(), (long)1400L);
        Block arrayOfArrayOfDictionaryOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)arrayOfDictionaryOfLong);
        Assert.assertEquals((long)arrayOfArrayOfDictionaryOfLong.getLogicalSizeInBytes(), (long)1900L);
        Block arrayOfDictionaryOfArrayOfLong = ArrayBlock.fromElementBlock((int)positionCount, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createRandomDictionaryBlock(arrayOfDictionaryOfLong, 100, true));
        Assert.assertEquals((long)arrayOfDictionaryOfArrayOfLong.getLogicalSizeInBytes(), (long)1900L);
    }

    @Test
    public void testCopyEmptyRawElementPositions() {
        int positionCount = 100;
        int[] offsets = new int[positionCount + 1];
        Arrays.fill(offsets, 1, offsets.length, 1);
        Block elements = ArrayBlock.fromElementBlock((int)positionCount, Optional.empty(), (int[])offsets, (Block)BlockAssertions.createRandomLongsBlock(1, 0.0f));
        Block offsetsShifted = elements.getRegion(50, 50);
        Assert.assertEquals((int)offsetsShifted.getOffsetBase(), (int)50);
        Block copiedArray = offsetsShifted.copyPositions(new int[]{0, 25, 49}, 0, 3);
        Assert.assertEquals((int)copiedArray.getPositionCount(), (int)3);
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 0, 0);
        long[][] expectedValues = new long[3][];
        for (int i = 0; i < expectedValues.length; ++i) {
            expectedValues[i] = new long[0];
        }
        TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        BlockAssertions.assertBlockEquals((Type)new ArrayType((Type)BigintType.BIGINT), copiedArray, blockBuilder.build());
    }

    private static int getExpectedEstimatedDataSize(long[][] values) {
        if (values == null) {
            return 0;
        }
        int size = 0;
        for (long[] value : values) {
            if (value == null) continue;
            size += 8 * value.length;
        }
        return size;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyValueBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestArrayBlock.testCompactBlock(ArrayBlock.fromElementBlock((int)0, Optional.empty(), (int[])new int[1], (Block)emptyValueBlock));
        TestArrayBlock.testCompactBlock(ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testIncompactBlock(ArrayBlock.fromElementBlock((int)(valueIsNull.length - 1), Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testIncompactBlock(ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)inCompactValueBlock));
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((BlockBuilder)new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100), null, 100);
        for (long[][] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            ArrayBlockBuilder intermediateBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
            for (int j = 0; j < expectedValue.length; ++j) {
                if (expectedValue[j] == null) {
                    intermediateBlockBuilder.appendNull();
                    continue;
                }
                BlockBuilder innerMostBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, expectedValue.length);
                for (long v : expectedValue[j]) {
                    BigintType.BIGINT.writeLong(innerMostBlockBuilder, v);
                }
                intermediateBlockBuilder.appendStructure(innerMostBlockBuilder.build());
            }
            blockBuilder.appendStructure(intermediateBlockBuilder.build());
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, expectedValues.length, 100);
        return TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
    }

    private static BlockBuilder writeValues(long[][] expectedValues, BlockBuilder blockBuilder) {
        for (long[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, expectedValue.length);
            for (long v : expectedValue) {
                BigintType.BIGINT.writeLong(elementBlockBuilder, v);
            }
            blockBuilder.appendStructure((Block)elementBlockBuilder);
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)VarcharType.VARCHAR, null, 100, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, expectedValue.length);
            for (Slice v : expectedValue) {
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, v);
            }
            blockBuilder.appendStructure(elementBlockBuilder.build());
        }
        return blockBuilder;
    }
}

