/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TestBlockBuilder {
    @Test
    public void testMultipleValuesWithNull() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        Block block = blockBuilder.build();
        Assert.assertTrue((boolean)block.isNull(0));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 1), (long)42L);
        Assert.assertTrue((boolean)block.isNull(2));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 3), (long)42L);
    }

    @Test
    public void testNewBlockBuilderLike() {
        ArrayType longArrayType = new ArrayType((Type)BigintType.BIGINT);
        ArrayType arrayType = new ArrayType((Type)longArrayType);
        ImmutableList channels = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)arrayType);
        PageBuilder pageBuilder = new PageBuilder((List)channels);
        BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder varcharBlockBuilder = pageBuilder.getBlockBuilder(1);
        BlockBuilder arrayBlockBuilder = pageBuilder.getBlockBuilder(2);
        for (int i = 0; i < 100; ++i) {
            BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)i);
            VarcharType.VARCHAR.writeSlice(varcharBlockBuilder, Slices.utf8Slice((String)("test" + i)));
            BlockBuilder longArrayBlock = new ArrayType((Type)BigintType.BIGINT).createBlockBuilder(null, 1).appendStructure(BigintType.BIGINT.createBlockBuilder(null, 2).writeLong((long)i).closeEntry().writeLong((long)(i * 2)).closeEntry().build());
            arrayBlockBuilder.appendStructure((Block)longArrayBlock);
            pageBuilder.declarePosition();
        }
        PageBuilder newPageBuilder = pageBuilder.newPageBuilderLike();
        for (int i = 0; i < channels.size(); ++i) {
            Assert.assertEquals((Object)newPageBuilder.getType(i), (Object)pageBuilder.getType(i));
            Assert.assertNotEquals((Object)pageBuilder.getBlockBuilder(i), (Object)newPageBuilder.getBlockBuilder(i));
            Assert.assertEquals((int)newPageBuilder.getBlockBuilder(i).getPositionCount(), (int)0);
            Assert.assertTrue((newPageBuilder.getBlockBuilder(i).getRetainedSizeInBytes() < pageBuilder.getBlockBuilder(i).getRetainedSizeInBytes() ? 1 : 0) != 0);
        }
        BlockBuilder newBigintBlockBuilder = bigintBlockBuilder.newBlockBuilderLike(null, 200);
        Assert.assertEquals((int)newBigintBlockBuilder.getPositionCount(), (int)0);
        Assert.assertEquals((long)newBigintBlockBuilder.getRetainedSizeInBytes(), (long)80L);
        newBigintBlockBuilder.writeLong(0L);
        Assert.assertEquals((int)newBigintBlockBuilder.getPositionCount(), (int)1);
        Assert.assertEquals((long)newBigintBlockBuilder.getRetainedSizeInBytes(), (long)1880L);
        BlockBuilder newVarcharBlockBuilder = varcharBlockBuilder.newBlockBuilderLike(null, 200);
        Assert.assertEquals((int)newVarcharBlockBuilder.getPositionCount(), (int)0);
        Assert.assertEquals((long)newVarcharBlockBuilder.getRetainedSizeInBytes(), (long)164L);
        newVarcharBlockBuilder.writeLong(0L);
        newVarcharBlockBuilder.closeEntry();
        Assert.assertEquals((int)newVarcharBlockBuilder.getPositionCount(), (int)1);
        Assert.assertEquals((long)newVarcharBlockBuilder.getRetainedSizeInBytes(), (long)2360L);
        BlockBuilder newArrayBlockBuilder = arrayBlockBuilder.newBlockBuilderLike(null, 200);
        Assert.assertEquals((int)newArrayBlockBuilder.getPositionCount(), (int)0);
        Assert.assertEquals((long)newArrayBlockBuilder.getRetainedSizeInBytes(), (long)248L);
        newArrayBlockBuilder.appendStructure(ArrayBlock.fromElementBlock((int)1, Optional.empty(), (int[])IntStream.range(0, 2).toArray(), (Block)newBigintBlockBuilder.build()));
        Assert.assertEquals((int)newArrayBlockBuilder.getPositionCount(), (int)1);
        Assert.assertEquals((long)newArrayBlockBuilder.getRetainedSizeInBytes(), (long)5848L);
    }

    @Test
    public void testNewBlockBuilderLikeForLargeBlockBuilder() {
        throw new SkipException("https://github.com/prestodb/presto/issues/15653 - Skipped because it OOMs");
    }

    @Test
    public void testGetPositions() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).appendNull().writeLong(43L).appendNull();
        int[] positions = new int[]{0, 1, 1, 1, 4};
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, positions.length), BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 4), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 2, 1), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 2, -1);
        Block block = blockBuilder.build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, positions.length), BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 4), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 2, 1), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 2, -1);
        AtomicBoolean isIdentical = new AtomicBoolean(false);
        block.getPositions(positions, 0, positions.length - 1).retainedBytesForEachPart((part, size) -> {
            if (part == positions) {
                isIdentical.set(true);
            }
        });
        Assert.assertTrue((boolean)isIdentical.get());
    }

    private static void assertInvalidGetPositions(Block block, int[] positions, int offset, int length) {
        try {
            block.getPositions(positions, offset, length).getLong(0);
            Assert.fail((String)"Expected to fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("position is not valid"));
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid offset"));
        }
    }
}

