/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlock
extends AbstractTestBlock {
    @Test
    public void testSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getSizeInBytes(), (long)(dictionaryBlock.getDictionary().getSizeInBytes() + 400L));
    }

    @Test
    public void testNonCachedLogicalBytes() {
        int numEntries = 10;
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, numEntries);
        int[] dictionaryIndexes = new int[numEntries + 10];
        Arrays.fill(dictionaryIndexes, 1);
        blockBuilder.appendNull();
        dictionaryIndexes[0] = 0;
        String string = "";
        for (int i = 1; i < numEntries; ++i) {
            string = string + "a";
            VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)string));
            dictionaryIndexes[i] = numEntries - i;
        }
        Block elementBlock = blockBuilder.build();
        DictionaryBlock block = new DictionaryBlock(numEntries, elementBlock, dictionaryIndexes);
        int elementSize = 5;
        long size = block.getRegionLogicalSizeInBytes(0, 1);
        Assert.assertEquals((long)size, (long)(0 + 1 * elementSize));
        size = block.getRegionLogicalSizeInBytes(0, numEntries);
        Assert.assertEquals((long)size, (long)(45 + numEntries * elementSize));
        size = block.getRegionLogicalSizeInBytes(1, 2);
        Assert.assertEquals((long)size, (long)(17 + 2 * elementSize));
        size = block.getRegionLogicalSizeInBytes(9, 1);
        Assert.assertEquals((long)size, (long)(1 + 1 * elementSize));
    }

    @Test
    public void testLogicalSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)95L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)950L);
        dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(TestDictionaryBlock.alternatingNullValues(expectedValues), 210);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)21);
        Assert.assertEquals((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)150L);
        Assert.assertEquals((long)dictionaryBlock.getLogicalSizeInBytes(), (long)1500L);
        Block longArrayBlock = BlockAssertions.createRandomLongsBlock(100, 0.5f);
        DictionaryBlock dictionaryDictionaryBlock = BlockAssertions.createRandomDictionaryBlock((Block)BlockAssertions.createRandomDictionaryBlock(longArrayBlock, 50), 10);
        Assert.assertEquals((long)dictionaryDictionaryBlock.getDictionary().getLogicalSizeInBytes(), (long)450L);
        Assert.assertEquals((long)dictionaryDictionaryBlock.getLogicalSizeInBytes(), (long)90L);
        DictionaryBlock dictionaryRleBlock = BlockAssertions.createRandomDictionaryBlock((Block)BlockAssertions.createRLEBlock(1L, 50), 10);
        Assert.assertEquals((long)dictionaryRleBlock.getDictionary().getLogicalSizeInBytes(), (long)450L);
        Assert.assertEquals((long)dictionaryRleBlock.getLogicalSizeInBytes(), (long)90L);
    }

    @Test
    public void testCopyRegionCreatesCompactBlock() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        DictionaryBlock copyRegionDictionaryBlock = (DictionaryBlock)dictionaryBlock.copyRegion(1, 3);
        Assert.assertTrue((boolean)copyRegionDictionaryBlock.isCompact());
    }

    @Test
    public void testCopyPositionsWithCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Slice firstExpectedValue = expectedValues[0];
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 10, 20, 30, 40};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{firstExpectedValue});
        this.assertBlock((Block)copiedBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue});
    }

    @Test
    public void testCopyPositionsWithCompactionsAndReorder() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{50, 55, 40, 45, 60};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)2);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[5]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 1, 0, 1, 0);
    }

    @Test
    public void testCopyPositionsSamePosition() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{52, 52, 52};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getDictionary().getPositionCount(), (int)1);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[2]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 0, 0);
    }

    @Test
    public void testCopyPositionsNoCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(1);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 2, 4, 5};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assert.assertEquals((int)copiedBlock.getPositionCount(), (int)positionsToCopy.length);
        this.assertBlock(copiedBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, expectedValues);
    }

    @Test
    public void testCompact() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlockWithUnreferencedKeys(expectedValues, 10);
        Assert.assertFalse((boolean)dictionaryBlock.isCompact());
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertNotEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
        Assert.assertEquals((int)compactBlock.getDictionary().getPositionCount(), (int)(expectedValues.length / 2 + 1));
        this.assertBlock(compactBlock.getDictionary(), TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[3]});
        TestDictionaryBlock.assertDictionaryIds(compactBlock, 0, 1, 1, 2, 2, 0, 1, 1, 2, 2);
        Assert.assertTrue((boolean)compactBlock.isCompact());
        DictionaryBlock reCompactedBlock = compactBlock.compact();
        Assert.assertEquals((Object)reCompactedBlock.getDictionarySourceId(), (Object)compactBlock.getDictionarySourceId());
    }

    @Test
    public void testCompactAllKeysReferenced() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 10);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assert.assertEquals((Object)compactBlock.getDictionary(), (Object)dictionaryBlock.getDictionary());
        Assert.assertEquals((int)compactBlock.getPositionCount(), (int)dictionaryBlock.getPositionCount());
        for (int position = 0; position < compactBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)compactBlock.getId(position), (int)dictionaryBlock.getId(position));
        }
        Assert.assertTrue((boolean)compactBlock.isCompact());
    }

    @Test
    public void testBasicGetPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), new int[]{0, 1, 2, 3, 4, 5});
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[2], expectedValues[3], expectedValues[4], expectedValues[5]});
        DictionaryId dictionaryId = dictionaryBlock.getDictionarySourceId();
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 8, 1, 2, 4, 5, 7, 9}, 2, 4);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[4], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 1, 3, 0, 0}, 0, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{-1, -1, 0, 1, 2}, 2, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 2, 2}, 0, 3);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[1], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{1, 1, 1, 1, 1}, 0, 5);
        this.assertBlock((Block)dictionaryBlock, TestDictionaryBlock::createBlockBuilder, new Slice[]{expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5]});
        Assert.assertEquals((Object)dictionaryBlock.getDictionarySourceId(), (Object)dictionaryId);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int position = (Integer)unmodifiableIterator.next();
            try {
                dictionaryBlock.getPositions(new int[]{position}, 0, 1);
                Assert.fail((String)"Expected to fail");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid position"));
            }
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int offset = (Integer)unmodifiableIterator.next();
            try {
                dictionaryBlock.getPositions(new int[]{0}, offset, 1);
                Assert.fail((String)"Expected to fail");
            }
            catch (IndexOutOfBoundsException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid offset"));
            }
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            try {
                dictionaryBlock.getPositions(new int[]{0}, 0, length);
                Assert.fail((String)"Expected to fail");
            }
            catch (IndexOutOfBoundsException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid offset"));
            }
        }
    }

    @Test
    public void testCompactGetPositions() {
        DictionaryBlock block = new DictionaryBlock(BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(10)), new int[]{0, 1, 2, 3, 4, 5}).compact();
        block = (DictionaryBlock)block.getPositions(new int[]{3, 3, 4, 5, 2, 0, 1, 1}, 0, 7);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 2, 3, 4, 5, 6, 6, 5, 4, 3, 2, 1}, 0, 12);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{0, 2, 0, 2, 0}, 0, 5);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 1, 1}, 0, 4);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[]{1, 1, 1, 1}, 0, 4);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0}, 0, 1);
        Assert.assertTrue((boolean)block.isCompact());
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertFalse((boolean)block.isCompact());
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assert.assertTrue((boolean)block.isCompact());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        int dictionaryPositionCount = 100;
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(positionCount);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, dictionaryPositionCount);
        for (int position = 0; position < dictionaryPositionCount; ++position) {
            Assert.assertEquals((long)dictionaryBlock.getEstimatedDataSizeForStats(position), (long)expectedValues[position % positionCount].length());
        }
    }

    @Test
    public void testDictionarySizeMethods() {
        IntArrayBlock fixedWidthBlock = new IntArrayBlock(100, Optional.empty(), IntStream.range(0, 100).toArray());
        TestDictionaryBlock.assertDictionarySizeMethods((Block)fixedWidthBlock);
        Block variableWidthBlock = BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(fixedWidthBlock.getPositionCount()));
        TestDictionaryBlock.assertDictionarySizeMethods(variableWidthBlock);
        TestDictionaryBlock.assertDictionarySizeMethods(fixedWidthBlock.getPositions(IntStream.range(0, 50).toArray(), 0, 50));
        TestDictionaryBlock.assertDictionarySizeMethods(variableWidthBlock.getPositions(IntStream.range(0, 50).toArray(), 0, 50));
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new DictionaryBlock((Block)fixedWidthBlock, IntStream.range(0, 50).toArray()));
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new DictionaryBlock(variableWidthBlock, IntStream.range(0, 50).toArray()));
        int[] positions = TestDictionaryBlock.createCompactRepeatingIdsRange(fixedWidthBlock.getPositionCount());
        TestDictionaryBlock.assertDictionarySizeMethods(fixedWidthBlock.getPositions(positions, 0, positions.length));
        TestDictionaryBlock.assertDictionarySizeMethods(variableWidthBlock.getPositions(positions, 0, positions.length));
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new DictionaryBlock((Block)fixedWidthBlock, TestDictionaryBlock.createCompactRepeatingIdsRange(fixedWidthBlock.getPositionCount())));
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new DictionaryBlock(variableWidthBlock, TestDictionaryBlock.createCompactRepeatingIdsRange(variableWidthBlock.getPositionCount())));
    }

    private static int[] createCompactRepeatingIdsRange(int positions) {
        int[] ids = new int[positions * 2];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i % positions;
        }
        return ids;
    }

    private static void assertDictionarySizeMethods(Block block) {
        int positions = block.getPositionCount();
        int[] allIds = IntStream.range(0, positions).toArray();
        Assert.assertEquals((long)new DictionaryBlock(block, allIds).getSizeInBytes(), (long)(block.getSizeInBytes() + 4L * (long)positions));
        if (positions > 0) {
            int firstHalfLength = positions / 2;
            int secondHalfLength = positions - firstHalfLength;
            int[] firstHalfIds = IntStream.range(0, firstHalfLength).toArray();
            int[] secondHalfIds = IntStream.range(firstHalfLength, positions).toArray();
            boolean[] selectedPositions = new boolean[positions];
            Assert.assertEquals((long)new DictionaryBlock(block, allIds).getPositionsSizeInBytes(selectedPositions, 0), (long)0L);
            selectedPositions[0] = true;
            Assert.assertEquals((long)new DictionaryBlock(block, allIds).getPositionsSizeInBytes(selectedPositions, 1), (long)(block.getPositionsSizeInBytes(selectedPositions, 1) + 4L));
            Assert.assertEquals((long)new DictionaryBlock(block, new int[]{0}).getSizeInBytes(), (long)(block.getPositionsSizeInBytes(selectedPositions, 1) + 4L));
            Arrays.fill(selectedPositions, true);
            Assert.assertEquals((long)new DictionaryBlock(block, allIds).getPositionsSizeInBytes(selectedPositions, positions), (long)(block.getSizeInBytes() + 4L * (long)positions));
            Assert.assertEquals((long)new DictionaryBlock(block, firstHalfIds).getSizeInBytes(), (long)(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength));
            Assert.assertEquals((long)new DictionaryBlock(block, secondHalfIds).getSizeInBytes(), (long)(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength));
            Assert.assertEquals((long)new DictionaryBlock(block, allIds).getRegionSizeInBytes(0, firstHalfLength), (long)(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength));
            Assert.assertEquals((long)new DictionaryBlock(block, allIds).getRegionSizeInBytes(firstHalfLength, secondHalfLength), (long)(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength));
        }
    }

    private static DictionaryBlock createDictionaryBlockWithUnreferencedKeys(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int index = i % dictionarySize;
            if (index % 2 != 0 || index != 0) {
                // empty if block
            }
            ids[i] = --index;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 100, 1);
    }

    private static void assertDictionaryIds(DictionaryBlock dictionaryBlock, int ... expected) {
        Assert.assertEquals((int)dictionaryBlock.getPositionCount(), (int)expected.length);
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)dictionaryBlock.getId(position), (int)expected[position]);
        }
    }
}

