/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.SingleArrayBlockWriter;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.block.SingleRowBlockWriter;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDirectEntryBlockBuilder {
    private static final int POSITION_COUNT = 100;
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);

    @Test
    public void testArrayWithNestedMap() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayBlockBuilder beginEntryBlockBuilder = new ArrayBlockBuilder((Type)mapType, null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleArrayBlockWriter singleArrayBlockWriter = beginEntryBlockBuilder.beginBlockEntry();
            for (int j = 0; j < 10; ++j) {
                BlockBuilder innerMapWriter = singleArrayBlockWriter.beginBlockEntry();
                BigintType.BIGINT.writeLong(innerMapWriter, (long)i);
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)("Value1" + j)));
                BigintType.BIGINT.writeLong(innerMapWriter, (long)(i + 1));
                VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)("Value2" + j)));
                singleArrayBlockWriter.closeEntry();
                singleArrayBlockWriter.appendNull();
            }
            beginEntryBlockBuilder.closeEntry();
        }
        ArrayBlockBuilder directEntryBlockBuilder = new ArrayBlockBuilder((Type)mapType, null, 100);
        for (int i = 0; i < 100; ++i) {
            directEntryBlockBuilder.beginDirectEntry();
            MapBlockBuilder innerBuilder = (MapBlockBuilder)directEntryBlockBuilder.getElementBlockBuilder();
            BlockBuilder keyBuilder = innerBuilder.getKeyBlockBuilder();
            BlockBuilder valueBuilder = innerBuilder.getValueBlockBuilder();
            for (int j = 0; j < 10; ++j) {
                innerBuilder.beginDirectEntry();
                BigintType.BIGINT.writeLong(keyBuilder, (long)i);
                BigintType.BIGINT.writeLong(keyBuilder, (long)(i + 1));
                VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)("Value1" + j)));
                VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)("Value2" + j)));
                innerBuilder.closeEntry();
                innerBuilder.appendNull();
            }
            directEntryBlockBuilder.closeEntry();
        }
        Slice beginEntrySlice = this.getSlice((BlockBuilder)beginEntryBlockBuilder);
        Slice directEntrySlice = this.getSlice((BlockBuilder)directEntryBlockBuilder);
        Assert.assertEquals((int)beginEntrySlice.compareTo(directEntrySlice), (int)0);
    }

    private Slice getSlice(BlockBuilder beginEntryBlockBuilder) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, (Block)beginEntryBlockBuilder);
        return sliceOutput.slice();
    }

    public static void throwUnsupportedOperation() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testNestedRow() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayType arrayType = new ArrayType((Type)DoubleType.DOUBLE);
        RowType.Field nestedRowField = new RowType.Field(Optional.of("my_struct"), (Type)IntegerType.INTEGER);
        RowType nestedRowType = RowType.from((List)ImmutableList.of((Object)nestedRowField));
        ImmutableList rowType = ImmutableList.of((Object)RealType.REAL, (Object)mapType, (Object)arrayType, (Object)nestedRowType);
        RowBlockBuilder beginEntryBlockBuilder = new RowBlockBuilder((List)rowType, null, 1);
        for (int i = 0; i < 100; ++i) {
            SingleRowBlockWriter singleRowBlockWriter = beginEntryBlockBuilder.beginBlockEntry();
            RealType.REAL.writeLong((BlockBuilder)singleRowBlockWriter, (long)i);
            BlockBuilder mapWriter = singleRowBlockWriter.beginBlockEntry();
            for (int j = 0; j < 5; ++j) {
                BigintType.BIGINT.writeLong(mapWriter, (long)(i + j));
                VarcharType.VARCHAR.writeSlice(mapWriter, Slices.utf8Slice((String)("Value1" + j)));
            }
            singleRowBlockWriter.closeEntry();
            BlockBuilder arrayWriter = singleRowBlockWriter.beginBlockEntry();
            for (int j = 0; j < 8; ++j) {
                DoubleType.DOUBLE.writeDouble(arrayWriter, (double)(i * 3 + j));
            }
            singleRowBlockWriter.closeEntry();
            BlockBuilder rowWriter = singleRowBlockWriter.beginBlockEntry();
            if (i % 2 == 0) {
                rowWriter.appendNull();
            } else {
                IntegerType.INTEGER.writeLong(rowWriter, (long)i);
            }
            singleRowBlockWriter.closeEntry();
            beginEntryBlockBuilder.closeEntry();
            beginEntryBlockBuilder.appendNull();
        }
        RowBlockBuilder directEntryBlockBuilder = new RowBlockBuilder((List)rowType, null, 1);
        for (int i = 0; i < 100; ++i) {
            directEntryBlockBuilder.beginDirectEntry();
            RealType.REAL.writeLong(directEntryBlockBuilder.getBlockBuilder(0), (long)i);
            MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)directEntryBlockBuilder.getBlockBuilder(1);
            mapBlockBuilder.beginDirectEntry();
            BlockBuilder keyBuilder = mapBlockBuilder.getKeyBlockBuilder();
            BlockBuilder valueBuilder = mapBlockBuilder.getValueBlockBuilder();
            for (int j = 0; j < 5; ++j) {
                BigintType.BIGINT.writeLong(keyBuilder, (long)(i + j));
                VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)("Value1" + j)));
            }
            mapBlockBuilder.closeEntry();
            ArrayBlockBuilder arrayBuilder = (ArrayBlockBuilder)directEntryBlockBuilder.getBlockBuilder(2);
            arrayBuilder.beginDirectEntry();
            for (int j = 0; j < 8; ++j) {
                DoubleType.DOUBLE.writeDouble(arrayBuilder.getElementBlockBuilder(), (double)(i * 3 + j));
            }
            arrayBuilder.closeEntry();
            RowBlockBuilder nestedRowBuilder = (RowBlockBuilder)directEntryBlockBuilder.getBlockBuilder(3);
            nestedRowBuilder.beginDirectEntry();
            BlockBuilder nestedRowValueBuilder = nestedRowBuilder.getBlockBuilder(0);
            if (i % 2 == 0) {
                nestedRowValueBuilder.appendNull();
            } else {
                IntegerType.INTEGER.writeLong(nestedRowValueBuilder, (long)i);
            }
            nestedRowBuilder.closeEntry();
            directEntryBlockBuilder.closeEntry();
            directEntryBlockBuilder.appendNull();
        }
        Slice beginEntrySlice = this.getSlice((BlockBuilder)beginEntryBlockBuilder);
        Slice directEntrySlice = this.getSlice((BlockBuilder)directEntryBlockBuilder);
        Assert.assertEquals((int)beginEntrySlice.compareTo(directEntrySlice), (int)0);
    }

    @Test
    public void testNestedMap() {
        MapType innerMap = new MapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        ArrayType arrayType = new ArrayType((Type)innerMap);
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)arrayType, MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]), MethodHandleUtil.methodHandle(TestDirectEntryBlockBuilder.class, (String)"throwUnsupportedOperation", (Class[])new Class[0]));
        MapBlockBuilder beginEntryBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter mapWriter = beginEntryBlockBuilder.beginBlockEntry();
            for (int j = 0; j < 7; ++j) {
                BigintType.BIGINT.writeLong((BlockBuilder)mapWriter, (long)(i * 7 + j));
                BlockBuilder arrayWriter = mapWriter.beginBlockEntry();
                for (int k = 0; k < 10; ++k) {
                    BlockBuilder innerMapWriter = arrayWriter.beginBlockEntry();
                    for (int l = 0; l < 3; ++l) {
                        BigintType.BIGINT.writeLong(innerMapWriter, (long)(k * 10 + l));
                        VarcharType.VARCHAR.writeSlice(innerMapWriter, Slices.utf8Slice((String)("Value" + l)));
                    }
                    arrayWriter.closeEntry();
                    arrayWriter.appendNull();
                }
                mapWriter.closeEntry();
            }
            beginEntryBlockBuilder.closeEntry();
        }
        MapBlockBuilder directEntryBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
        for (int i = 0; i < 100; ++i) {
            directEntryBlockBuilder.beginDirectEntry();
            BlockBuilder keyBuilder = directEntryBlockBuilder.getKeyBlockBuilder();
            ArrayBlockBuilder arrayBuilder = (ArrayBlockBuilder)directEntryBlockBuilder.getValueBlockBuilder();
            MapBlockBuilder innerMapBuilder = (MapBlockBuilder)arrayBuilder.getElementBlockBuilder();
            BlockBuilder innerMapKeyBuilder = innerMapBuilder.getKeyBlockBuilder();
            BlockBuilder innerMapValueBuilder = innerMapBuilder.getValueBlockBuilder();
            for (int j = 0; j < 7; ++j) {
                BigintType.BIGINT.writeLong(keyBuilder, (long)(i * 7 + j));
                arrayBuilder.beginDirectEntry();
                for (int k = 0; k < 10; ++k) {
                    innerMapBuilder.beginDirectEntry();
                    for (int l = 0; l < 3; ++l) {
                        BigintType.BIGINT.writeLong(innerMapKeyBuilder, (long)(k * 10 + l));
                        VarcharType.VARCHAR.writeSlice(innerMapValueBuilder, Slices.utf8Slice((String)("Value" + l)));
                    }
                    innerMapBuilder.closeEntry();
                    innerMapBuilder.appendNull();
                }
                arrayBuilder.closeEntry();
            }
            directEntryBlockBuilder.closeEntry();
        }
        Slice beginEntrySlice = this.getSlice((BlockBuilder)beginEntryBlockBuilder);
        Slice directEntrySlice = this.getSlice((BlockBuilder)directEntryBlockBuilder);
        Assert.assertEquals((int)beginEntrySlice.compareTo(directEntrySlice), (int)0);
    }
}

