/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.testing.TestingEnvironment;
import com.facebook.presto.util.StructuralTestUtil;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        this.testWith(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] mapIsNull = new boolean[]{false, true, false, false, false, false};
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(0, Optional.empty(), new int[1], (Block)emptyBlock, (Block)emptyBlock));
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(mapIsNull.length, Optional.of(mapIsNull), offsets, (Block)compactKeyBlock, (Block)compactValueBlock));
        TestMapBlock.testIncompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(mapIsNull.length, Optional.of(mapIsNull), offsets, (Block)inCompactKeyBlock, (Block)inCompactValueBlock));
    }

    @Test
    public void testLazyHashTableBuildOverBlockRegion() {
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5)));
    }

    @Test
    public void testSingleValueBlock() {
        Map<String, Long>[] values = TestMapBlock.createTestMap(50);
        BlockBuilder mapBlockBuilder = TestMapBlock.createBlockBuilderWithValues(values);
        Block mapBlock = mapBlockBuilder.build();
        Assert.assertSame((Object)mapBlock, (Object)mapBlock.getSingleValueBlock(0));
        Assert.assertNotSame((Object)mapBlockBuilder, (Object)mapBlockBuilder.getSingleValueBlock(0));
        values = TestMapBlock.createTestMap(50, 50);
        mapBlockBuilder = TestMapBlock.createBlockBuilderWithValues(values);
        mapBlock = mapBlockBuilder.build();
        Block firstElement = mapBlock.getRegion(0, 1);
        Assert.assertNotSame((Object)firstElement, (Object)firstElement.getSingleValueBlock(0));
        Block secondElementCopy = mapBlock.copyRegion(1, 1);
        Assert.assertSame((Object)secondElementCopy, (Object)secondElementCopy.getSingleValueBlock(0));
        values = new Map[]{null};
        mapBlockBuilder = TestMapBlock.createBlockBuilderWithValues(values);
        mapBlock = mapBlockBuilder.build();
        Assert.assertSame((Object)mapBlock, (Object)mapBlock.getSingleValueBlock(0));
        Assert.assertNotSame((Object)mapBlock, (Object)mapBlockBuilder.getSingleValueBlock(0));
        values = new Map[]{null, null};
        mapBlockBuilder = TestMapBlock.createBlockBuilderWithValues(values);
        mapBlock = mapBlockBuilder.build();
        Assert.assertNotSame((Object)mapBlock, (Object)mapBlock.getSingleValueBlock(0));
    }

    @Test
    public void testSeekKey() {
        Block keyBlock = BlockAssertions.createStringsBlock("k");
        Block valueBlock = BlockAssertions.createStringsBlock("v");
        Block mapBlock = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR).createBlockFromKeyValue(1, Optional.empty(), IntStream.range(0, 2).toArray(), keyBlock, valueBlock);
        SingleMapBlock singleMapBlock = (SingleMapBlock)mapBlock.getBlock(0);
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{VarcharType.VARCHAR});
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR});
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        Assert.assertEquals((int)singleMapBlock.seekKeyExact(Slices.utf8Slice((String)new String(new char[10]).replace("\u0000", "Doudou")), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode), (int)-1);
        Assert.assertEquals((int)singleMapBlock.seekKeyExact(Slices.utf8Slice((String)"k"), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode), (int)1);
    }

    @Test
    public void testLogicalSizeInBytes() {
        int positionCount = 100;
        int[] offsets = IntStream.rangeClosed(0, positionCount).toArray();
        boolean[] nulls = new boolean[positionCount];
        Block keyBlock1 = BlockAssertions.createRandomLongsBlock(positionCount, 0.0f);
        Block valueBlock1 = BlockAssertions.createRandomLongsBlock(positionCount, 0.0f);
        Block mapOfLongAndLong = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock1, valueBlock1);
        Assert.assertEquals((long)mapOfLongAndLong.getLogicalSizeInBytes(), (long)3100L);
        RunLengthEncodedBlock keyBlock2 = BlockAssertions.createRLEBlock(1L, positionCount);
        RunLengthEncodedBlock valueBlock2 = BlockAssertions.createRLEBlock(2L, positionCount);
        Block mapOfRleOfLongAndRleOfLong = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, (Block)keyBlock2, (Block)valueBlock2);
        Assert.assertEquals((long)mapOfRleOfLongAndRleOfLong.getLogicalSizeInBytes(), (long)3100L);
        RunLengthEncodedBlock keyBlock3 = BlockAssertions.createRLEBlock(1L, positionCount);
        RunLengthEncodedBlock valueBlock3 = BlockAssertions.createRleBlockWithRandomValue(StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock1, valueBlock1), positionCount);
        Block mapOfRleOfLongAndRleOfMapOfLongAndLong = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, (Block)keyBlock3, (Block)valueBlock3);
        Assert.assertEquals((long)mapOfRleOfLongAndRleOfMapOfLongAndLong.getLogicalSizeInBytes(), (long)5300L);
        RunLengthEncodedBlock keyBlock4 = BlockAssertions.createRLEBlock(1L, positionCount);
        Block valueBlock4 = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock1, (Block)BlockAssertions.createRLEBlock(1L, positionCount));
        Block mapBlock4 = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, (Block)keyBlock4, valueBlock4);
        Assert.assertEquals((long)mapBlock4.getLogicalSizeInBytes(), (long)5300L);
        Block keyBlock5 = BlockAssertions.createLongDictionaryBlock(0, positionCount);
        Block valuesBlock5 = BlockAssertions.createLongDictionaryBlock(0, positionCount);
        Block mapBlock5 = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock5, valuesBlock5);
        Assert.assertEquals((long)mapBlock5.getLogicalSizeInBytes(), (long)3100L);
        Block keyBlock6 = BlockAssertions.createLongDictionaryBlock(0, positionCount);
        Block valuesBlock6 = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock1, BlockAssertions.createLongDictionaryBlock(0, positionCount));
        Block mapBlock6 = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(nulls), offsets, keyBlock6, valuesBlock6);
        Assert.assertEquals((long)mapBlock6.getLogicalSizeInBytes(), (long)5300L);
    }

    private void assertLazyHashTableBuildOverBlockRegion(Map<String, Long>[] testValues) {
        MapBlock block = TestMapBlock.createBlockWithValuesFromKeyValueBlock(testValues);
        BlockBuilder blockBuilder = TestMapBlock.createBlockBuilderWithValues(testValues);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 0, 4);
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 2, 4);
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 4, 4);
        block = TestMapBlock.createBlockWithValuesFromKeyValueBlock(testValues);
        blockBuilder = TestMapBlock.createBlockBuilderWithValues(testValues);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 2, 4);
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 0, 4);
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 4, 4);
        block = TestMapBlock.createBlockWithValuesFromKeyValueBlock(testValues);
        blockBuilder = TestMapBlock.createBlockBuilderWithValues(testValues);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 4, 4);
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 2, 4);
        this.verifyBlockAndBuilderRegion(testValues, block, blockBuilder, 0, 4);
    }

    private void verifyBlockAndBuilderRegion(Map<String, Long>[] testValues, MapBlock block, BlockBuilder blockBuilder, int offset, int length) {
        this.verifyMapRegion(testValues, (AbstractMapBlock)block, blockBuilder, offset, length);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)blockBuilder;
        this.verifyMapRegion(testValues, (AbstractMapBlock)mapBlockBuilder, blockBuilder, offset, length);
    }

    private void verifyMapRegion(Map<String, Long>[] testValues, AbstractMapBlock block, BlockBuilder blockBuilder, int offset, int length) {
        boolean isHashTablePresent = block.isHashTablesPresent();
        MapBlock region = (MapBlock)block.getRegion(offset, length);
        Assert.assertEquals((boolean)region.isHashTablesPresent(), (boolean)isHashTablePresent);
        this.assertBlock((Block)region, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, offset, offset + length));
        Assert.assertTrue((boolean)region.isHashTablesPresent());
    }

    private static Map<String, Long>[] createTestMap(int ... entryCounts) {
        Map[] result = new Map[entryCounts.length];
        for (int rowNumber = 0; rowNumber < entryCounts.length; ++rowNumber) {
            int entryCount = entryCounts[rowNumber];
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (int entryNumber = 0; entryNumber < entryCount; ++entryNumber) {
                map.put("key" + entryNumber, entryNumber == 5 ? null : Long.valueOf((long)rowNumber * 100L + (long)entryNumber));
            }
            result[rowNumber] = map;
        }
        return result;
    }

    private void testWith(Map<String, Long>[] expectedValues) {
        BlockBuilder blockBuilder = TestMapBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        MapBlock block = TestMapBlock.createBlockWithValuesFromKeyValueBlock(expectedValues);
        this.assertBlock((Block)block, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Map<String, Long>[] expectedValuesWithNull = TestMapBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestMapBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        MapBlock blockWithNull = TestMapBlock.createBlockWithValuesFromKeyValueBlock(expectedValuesWithNull);
        this.assertBlock((Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    private static BlockBuilder createBlockBuilderWithValues(Map<String, Long>[] maps) {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        for (Map<String, Long> map : maps) {
            TestMapBlock.createBlockBuilderWithValues(map, mapBlockBuilder);
        }
        return mapBlockBuilder;
    }

    private static MapBlock createBlockWithValuesFromKeyValueBlock(Map<String, Long>[] maps) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Long> values = new ArrayList<Long>();
        int positionCount = maps.length;
        int[] offsets = new int[positionCount + 1];
        boolean[] mapIsNull = new boolean[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            Map<String, Long> map = maps[i];
            boolean bl = mapIsNull[i] = map == null;
            if (map == null) {
                offsets[i + 1] = offsets[i];
                continue;
            }
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            offsets[i + 1] = offsets[i] + map.size();
        }
        return (MapBlock)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT).createBlockFromKeyValue(positionCount, Optional.of(mapIsNull), offsets, BlockAssertions.createStringsBlock(keys), BlockAssertions.createLongsBlock(values));
    }

    private static void createBlockBuilderWithValues(Map<String, Long> map, BlockBuilder mapBlockBuilder) {
        if (map == null) {
            mapBlockBuilder.appendNull();
        } else {
            BlockBuilder elementBlockBuilder = mapBlockBuilder.beginBlockEntry();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, Slices.utf8Slice((String)entry.getKey()));
                if (entry.getValue() == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                BigintType.BIGINT.writeLong(elementBlockBuilder, entry.getValue().longValue());
            }
            mapBlockBuilder.closeEntry();
        }
    }

    @Override
    protected <T> void assertCheckedPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof Map) {
            TestMapBlock.assertValue(block, position, (Map)expectedValue);
            return;
        }
        super.assertCheckedPositionValue(block, position, expectedValue);
    }

    @Override
    protected <T> void assertPositionValueUnchecked(Block block, int internalPosition, T expectedValue) {
        if (expectedValue instanceof Map) {
            TestMapBlock.assertValueUnchecked(block, internalPosition, (Map)expectedValue);
            return;
        }
        super.assertPositionValueUnchecked(block, internalPosition, expectedValue);
    }

    private static void assertValue(Block mapBlock, int position, Map<String, Long> map) {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{VarcharType.VARCHAR});
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR});
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        Objects.requireNonNull(map, "map is null");
        Assert.assertFalse((boolean)mapBlock.isNull(position));
        SingleMapBlock elementBlock = (SingleMapBlock)mapType.getObject(mapBlock, position);
        Assert.assertEquals((int)elementBlock.getPositionCount(), (int)(map.size() * 2));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            int pos = elementBlock.seekKey((Object)Slices.utf8Slice((String)entry.getKey()), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
            Assert.assertNotEquals((Object)pos, (Object)-1);
            if (entry.getValue() == null) {
                Assert.assertTrue((boolean)elementBlock.isNull(pos));
                continue;
            }
            Assert.assertFalse((boolean)elementBlock.isNull(pos));
            Assert.assertEquals((long)BigintType.BIGINT.getLong((Block)elementBlock, pos), (long)entry.getValue());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((int)elementBlock.seekKey((Object)Slices.utf8Slice((String)("not-inserted-" + i)), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode), (int)-1);
        }
        for (i = 0; i < elementBlock.getPositionCount(); i += 2) {
            String actualKey = VarcharType.VARCHAR.getSlice((Block)elementBlock, i).toStringUtf8();
            Long actualValue = elementBlock.isNull(i + 1) ? null : Long.valueOf(BigintType.BIGINT.getLong((Block)elementBlock, i + 1));
            Assert.assertTrue((boolean)map.containsKey(actualKey));
            Assert.assertEquals((Object)actualValue, (Object)map.get(actualKey));
        }
    }

    private static void assertValueUnchecked(Block mapBlock, int internalPosition, Map<String, Long> map) {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{VarcharType.VARCHAR});
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR});
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)VarcharType.VARCHAR));
        Objects.requireNonNull(map, "map is null");
        Assert.assertFalse((boolean)mapBlock.isNullUnchecked(internalPosition));
        SingleMapBlock elementBlock = (SingleMapBlock)mapType.getBlockUnchecked(mapBlock, internalPosition);
        Assert.assertEquals((int)elementBlock.getPositionCount(), (int)(map.size() * 2));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            int pos = elementBlock.seekKey((Object)Slices.utf8Slice((String)entry.getKey()), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
            Assert.assertNotEquals((Object)pos, (Object)-1);
            if (entry.getValue() == null) {
                Assert.assertTrue((boolean)elementBlock.isNullUnchecked(pos + elementBlock.getOffsetBase()));
                continue;
            }
            Assert.assertFalse((boolean)elementBlock.isNullUnchecked(pos + elementBlock.getOffsetBase()));
            Assert.assertEquals((long)BigintType.BIGINT.getLongUnchecked((UncheckedBlock)elementBlock, pos + elementBlock.getOffsetBase()), (long)entry.getValue());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((int)elementBlock.seekKey((Object)Slices.utf8Slice((String)("not-inserted-" + i)), keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode), (int)-1);
        }
        for (i = 0; i < elementBlock.getPositionCount(); i += 2) {
            String actualKey = VarcharType.VARCHAR.getSliceUnchecked((Block)elementBlock, i + elementBlock.getOffset()).toStringUtf8();
            Long actualValue = elementBlock.isNullUnchecked(i + 1 + elementBlock.getOffset()) ? null : Long.valueOf(BigintType.BIGINT.getLongUnchecked((UncheckedBlock)elementBlock, i + 1 + elementBlock.getOffsetBase()));
            Assert.assertTrue((boolean)map.containsKey(actualKey));
            Assert.assertEquals((Object)actualValue, (Object)map.get(actualKey));
        }
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Map<String, Long>[] expectedValues = TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        BlockBuilder blockBuilder = TestMapBlock.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestMapBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(Map<String, Long> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            size += entry.getKey().length();
            size += entry.getValue() == null ? 0 : 8;
        }
        return size;
    }
}

