/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.testing.TestingEnvironment;
import java.lang.invoke.MethodHandle;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapBlockBuilder {
    private static final MethodHandle KEY_NATIVE_EQUALS = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_EQUALS = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_EQUALS, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
    private static final MethodHandle KEY_NATIVE_HASH_CODE = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{BigintType.BIGINT});
    private static final MethodHandle KEY_BLOCK_HASH_CODE = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_HASH_CODE, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
    private static final MethodHandle KEY_BLOCK_NATIVE_EQUALS = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_EQUALS, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
    private static final int MAP_POSITIONS = 100;

    @Test
    public void testMapBlockBuilderWithNullKeys() {
        MapBlockBuilder blockBuilder = this.createMapBlockBuilder();
        for (int i = 0; i < 100; ++i) {
            if (i % 10 == 0) {
                blockBuilder.appendNull();
            } else {
                SingleMapBlockWriter entryBuilder = blockBuilder.beginBlockEntry();
                for (int j = 0; j < i; ++j) {
                    if (j == 5) {
                        entryBuilder.appendNull();
                    } else {
                        BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)j);
                    }
                    BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
                }
                blockBuilder.closeEntry();
            }
            Assert.assertFalse((boolean)blockBuilder.isHashTablesPresent());
        }
        MapBlock mapBlock = (MapBlock)blockBuilder.build();
        Assert.assertFalse((boolean)mapBlock.isHashTablesPresent());
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)mapBlock);
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((boolean)columnarMap.isNull(i), (i % 10 == 0 ? 1 : 0) != 0);
            Block keysBlock = columnarMap.getKeysBlock();
            Block valuesBlock = columnarMap.getValuesBlock();
            if (columnarMap.isNull(i)) continue;
            int offset = columnarMap.getOffset(i);
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((boolean)keysBlock.isNull(offset + j), (j == 5 ? 1 : 0) != 0);
                if (!keysBlock.isNull(offset + j)) {
                    Assert.assertEquals((long)BigintType.BIGINT.getLong(keysBlock, offset + j), (long)j);
                }
                Assert.assertEquals((long)BigintType.BIGINT.getLong(valuesBlock, offset + j), (long)i);
            }
        }
        Assert.assertFalse((boolean)mapBlock.isHashTablesPresent());
        MapBlockBuilder anotherBuilder = (MapBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assert.assertFalse((boolean)anotherBuilder.isHashTablesPresent());
    }

    @Test
    public void testMapBlockSeek() {
        MapBlockBuilder blockBuilder = this.createMapBlockBuilder();
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter entryBuilder = blockBuilder.beginBlockEntry();
            for (int j = 0; j < i; ++j) {
                BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)j);
                BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
            }
            blockBuilder.closeEntry();
        }
        Assert.assertFalse((boolean)blockBuilder.isHashTablesPresent());
        MapBlock mapBlock = (MapBlock)blockBuilder.build();
        Assert.assertFalse((boolean)mapBlock.isHashTablesPresent());
        for (int i = 0; i < 100; ++i) {
            SingleMapBlock singleMapBlock = (SingleMapBlock)mapBlock.getBlock(i);
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((int)singleMapBlock.seekKeyExact((long)j, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)(j * 2 + 1));
            }
            Assert.assertEquals((boolean)mapBlock.isHashTablesPresent(), (i > 0 ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)blockBuilder.isHashTablesPresent());
    }

    @Test
    public void testCloseEntryStrict() throws Exception {
        int i;
        MapBlockBuilder mapBlockBuilder = this.createMapBlockBuilder();
        for (int i2 = 0; i2 < 100; ++i2) {
            this.appendSingleEntryMap(mapBlockBuilder, 1);
        }
        Assert.assertFalse((boolean)mapBlockBuilder.isHashTablesPresent());
        SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
        for (i = 0; i < 50; ++i) {
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        }
        mapBlockBuilder.closeEntryStrict(KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
        Assert.assertTrue((boolean)mapBlockBuilder.isHashTablesPresent());
        for (i = 0; i < 100; ++i) {
            SingleMapBlock block = (SingleMapBlock)mapBlockBuilder.getBlock(i);
            Assert.assertEquals((int)block.seekKeyExact(1L, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)1);
        }
        SingleMapBlock singleMapBlock = (SingleMapBlock)mapBlockBuilder.getBlock(100);
        for (int i3 = 0; i3 < 50; ++i3) {
            Assert.assertEquals((int)singleMapBlock.seekKeyExact((long)i3, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)(i3 * 2 + 1));
        }
        MapBlock mapBlock = (MapBlock)mapBlockBuilder.build();
        Assert.assertTrue((boolean)mapBlock.isHashTablesPresent());
    }

    @Test
    public void testMapBuilderSeekLoadsHashMap() {
        int i;
        MapBlockBuilder mapBlockBuilder = this.createMapBlockBuilder();
        for (i = 0; i < 100; ++i) {
            this.appendSingleEntryMap(mapBlockBuilder, i);
        }
        Assert.assertFalse((boolean)mapBlockBuilder.isHashTablesPresent());
        for (i = 0; i < 100; ++i) {
            SingleMapBlock block = (SingleMapBlock)mapBlockBuilder.getBlock(i);
            Assert.assertEquals((int)block.seekKeyExact((long)i, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)1);
            Assert.assertTrue((boolean)mapBlockBuilder.isHashTablesPresent());
        }
        for (i = 0; i < 100; ++i) {
            this.appendSingleEntryMap(mapBlockBuilder, i);
            this.verifyOnlyKeyInMap((AbstractMapBlock)mapBlockBuilder, 100 + i, i);
        }
        MapBlock mapBlock = (MapBlock)mapBlockBuilder.build();
        Assert.assertTrue((boolean)mapBlock.isHashTablesPresent());
        MapBlockBuilder anotherBuilder = (MapBlockBuilder)mapBlockBuilder.newBlockBuilderLike(null);
        Assert.assertTrue((boolean)anotherBuilder.isHashTablesPresent());
    }

    @Test
    public void testAppendStructureWithMissingHash() {
        int i;
        MapBlockBuilder mapBlockBuilder = this.createMapBlockBuilder();
        for (int i2 = 0; i2 < 100; ++i2) {
            this.appendSingleEntryMap(mapBlockBuilder, i2);
        }
        Assert.assertFalse((boolean)mapBlockBuilder.isHashTablesPresent());
        MapBlockBuilder anotherBuilder = this.createMapBlockBuilder();
        for (i = 0; i < 100; ++i) {
            SingleMapBlock block = (SingleMapBlock)mapBlockBuilder.getBlock(i);
            anotherBuilder.appendStructure((Block)block);
        }
        Assert.assertFalse((boolean)anotherBuilder.isHashTablesPresent());
        for (i = 0; i < 100; ++i) {
            this.verifyOnlyKeyInMap((AbstractMapBlock)anotherBuilder, i, i);
            Assert.assertTrue((boolean)anotherBuilder.isHashTablesPresent());
        }
    }

    @Test
    public void testAppendStructureWithHashPresent() {
        int i;
        MapBlockBuilder mapBlockBuilder = this.createMapBlockBuilder();
        for (int i2 = 0; i2 < 100; ++i2) {
            this.appendSingleEntryMap(mapBlockBuilder, i2);
        }
        Assert.assertFalse((boolean)mapBlockBuilder.isHashTablesPresent());
        MapBlockBuilder anotherBuilder = (MapBlockBuilder)mapBlockBuilder.newBlockBuilderLike(null);
        MapBlock mapBlock = (MapBlock)mapBlockBuilder.build();
        for (int i3 = 0; i3 < 100; ++i3) {
            anotherBuilder.appendStructureInternal((Block)mapBlock, i3);
        }
        SingleMapBlock singleMapBlock = (SingleMapBlock)mapBlock.getBlock(1);
        singleMapBlock.seekKeyExact(1L, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE);
        Assert.assertFalse((boolean)anotherBuilder.isHashTablesPresent());
        for (i = 0; i < 100; ++i) {
            anotherBuilder.appendStructureInternal((Block)mapBlock, i);
            Assert.assertTrue((boolean)anotherBuilder.isHashTablesPresent());
            this.verifyOnlyKeyInMap((AbstractMapBlock)anotherBuilder, 100 + i, i);
        }
        for (i = 0; i < 100; ++i) {
            this.verifyOnlyKeyInMap((AbstractMapBlock)anotherBuilder, i, i);
        }
    }

    @Test
    public void testDirectBlockEntry() {
        int element;
        MapType innerMapType = new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)innerMapType, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
        MapBlockBuilder blockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
        int numberOfOuterElements = 10;
        int numberOfInnerElements = 500;
        int outerKeyBase = 100;
        int keyBase = 1000;
        int valueBase = 1000000;
        for (element = 0; element < 100; ++element) {
            blockBuilder.beginDirectEntry();
            BlockBuilder outerKeyBuilder = blockBuilder.getKeyBlockBuilder();
            for (int outer = 0; outer < numberOfOuterElements; ++outer) {
                BigintType.BIGINT.writeLong(outerKeyBuilder, (long)(element * outerKeyBase + outer));
            }
            MapBlockBuilder outerValueBuilder = (MapBlockBuilder)blockBuilder.getValueBlockBuilder();
            for (int outer = 0; outer < numberOfOuterElements; ++outer) {
                outerValueBuilder.beginDirectEntry();
                BlockBuilder innerKeyBuilder = outerValueBuilder.getKeyBlockBuilder();
                for (int inner = 0; inner < numberOfInnerElements; ++inner) {
                    BigintType.BIGINT.writeLong(innerKeyBuilder, (long)(inner + outer * keyBase));
                }
                BlockBuilder innerValueBuilder = outerValueBuilder.getValueBlockBuilder();
                for (int inner = 0; inner < numberOfInnerElements; ++inner) {
                    BigintType.BIGINT.writeLong(innerValueBuilder, (long)(inner + outer * valueBase));
                }
                outerValueBuilder.closeEntry();
            }
            blockBuilder.closeEntry();
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)100);
        for (element = 0; element < blockBuilder.getPositionCount(); ++element) {
            SingleMapBlock outerBlock = (SingleMapBlock)blockBuilder.getBlock(element);
            Assert.assertEquals((int)outerBlock.getPositionCount(), (int)(numberOfOuterElements * 2));
            for (int outer = 0; outer < numberOfOuterElements; ++outer) {
                Assert.assertEquals((long)outerBlock.getLong(outer * 2), (long)((long)element * (long)outerKeyBase + (long)outer));
                SingleMapBlock innerValueBlock = (SingleMapBlock)outerBlock.getBlock(outer * 2 + 1);
                Assert.assertEquals((int)innerValueBlock.getPositionCount(), (int)(numberOfInnerElements * 2));
                for (int inner = 0; inner < numberOfInnerElements; ++inner) {
                    Assert.assertEquals((long)innerValueBlock.getLong(inner * 2), (long)((long)outer * (long)keyBase + (long)inner));
                    Assert.assertEquals((long)innerValueBlock.getLong(inner * 2 + 1), (long)((long)outer * (long)valueBase + (long)inner));
                }
            }
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMismatchedKeyValuePositionCountThrows() {
        MapBlockBuilder mapBlockBuilder = this.createMapBlockBuilder();
        mapBlockBuilder.beginDirectEntry();
        mapBlockBuilder.getKeyBlockBuilder().writeLong(1L);
        mapBlockBuilder.getKeyBlockBuilder().writeLong(2L);
        mapBlockBuilder.getValueBlockBuilder().writeLong(3L);
        mapBlockBuilder.getValueBlockBuilder().writeLong(4L);
        mapBlockBuilder.getValueBlockBuilder().writeLong(5L);
        mapBlockBuilder.closeEntry();
    }

    private void appendSingleEntryMap(MapBlockBuilder mapBlockBuilder, int i) {
        SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
        BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        mapBlockBuilder.closeEntry();
    }

    private void verifyOnlyKeyInMap(AbstractMapBlock block, int position, int key) {
        SingleMapBlock singleMapBlock = (SingleMapBlock)block.getBlock(position);
        Assert.assertEquals((int)singleMapBlock.seekKeyExact((long)key, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)1);
        int nonExistentKey = key + 1;
        Assert.assertEquals((int)singleMapBlock.seekKeyExact((long)nonExistentKey, KEY_NATIVE_HASH_CODE, KEY_BLOCK_NATIVE_EQUALS, KEY_BLOCK_HASH_CODE), (int)-1);
    }

    private MapBlockBuilder createMapBlockBuilder() {
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
        return (MapBlockBuilder)mapType.createBlockBuilder(null, 100);
    }
}

