/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ByteArrayBlockBuilder;
import com.facebook.presto.common.block.IntArrayBlockBuilder;
import com.facebook.presto.common.block.LongArrayBlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.ShortArrayBlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import io.airlift.slice.Slice;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRunLengthEncodedBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        for (int positionCount = 0; positionCount < 10; ++positionCount) {
            this.assertRleBlock(positionCount);
        }
    }

    private void assertRleBlock(int positionCount) {
        Slice expectedValue = TestRunLengthEncodedBlock.createExpectedValue(0);
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(TestRunLengthEncodedBlock.createSingleValueBlock(expectedValue), positionCount);
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = expectedValue;
        }
        this.assertBlock((Block)block, TestRunLengthEncodedBlock::createBlockBuilder, expectedValues);
    }

    private static Block createSingleValueBlock(Slice expectedValue) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, expectedValue.length());
        blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        return blockBuilder.build();
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 1, 1);
    }

    @Test
    public void testBuildingFromLongArrayBlockBuilder() {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
        Assert.assertEquals((String)blockBuilder.build().getEncodingName(), (String)"RLE");
    }

    @Test
    public void testBuildingFromIntArrayBlockBuilder() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
        Assert.assertEquals((String)blockBuilder.build().getEncodingName(), (String)"RLE");
    }

    @Test
    public void testBuildingFromShortArrayBlockBuilder() {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
        Assert.assertEquals((String)blockBuilder.build().getEncodingName(), (String)"RLE");
    }

    @Test
    public void testBuildingFromByteArrayBlockBuilder() {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, 100);
        this.populateNullValues((BlockBuilder)blockBuilder, 100);
        Assert.assertEquals((String)blockBuilder.build().getEncodingName(), (String)"RLE");
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        Slice expectedValue = TestRunLengthEncodedBlock.createExpectedValue(5);
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(TestRunLengthEncodedBlock.createSingleValueBlock(expectedValue), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(position), (long)expectedValue.length());
        }
    }

    private void populateNullValues(BlockBuilder blockBuilder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
    }
}

