/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        this.assertVariableWithValues(expectedValues);
        this.assertVariableWithValues(TestVariableWidthBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyRegion() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        Block block = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues).build();
        Block actual = block.copyRegion(10, 10);
        Block expected = TestVariableWidthBlock.createBlockBuilderWithValues(Arrays.copyOfRange(expectedValues, 10, 20)).build();
        Assert.assertEquals((int)actual.getPositionCount(), (int)expected.getPositionCount());
        Assert.assertEquals((long)actual.getSizeInBytes(), (long)expected.getSizeInBytes());
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestVariableWidthBlock.alternatingNullValues(TestVariableWidthBlock.createExpectedValues(100));
        BlockBuilder blockBuilder = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        VariableWidthBlockBuilder emptyBlockBuilder = new VariableWidthBlockBuilder(null, 0, 0);
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestVariableWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    private void testGetSizeInBytes() {
        int numEntries = 1000;
        VarcharType unboundedVarcharType = VarcharType.createUnboundedVarcharType();
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, numEntries, 20 * numEntries);
        for (int i = 0; i < numEntries; ++i) {
            unboundedVarcharType.writeString((BlockBuilder)blockBuilder, String.valueOf(ThreadLocalRandom.current().nextLong()));
        }
        Block block = blockBuilder.build();
        List<Block> splitQuarter = this.splitBlock(block, 4);
        long sizeInBytes = block.getSizeInBytes();
        long quarter1size = splitQuarter.get(0).getSizeInBytes();
        long quarter2size = splitQuarter.get(1).getSizeInBytes();
        long quarter3size = splitQuarter.get(2).getSizeInBytes();
        long quarter4size = splitQuarter.get(3).getSizeInBytes();
        double expectedQuarterSizeMin = (double)sizeInBytes * 0.2;
        double expectedQuarterSizeMax = (double)sizeInBytes * 0.3;
        Assert.assertTrue(((double)quarter1size > expectedQuarterSizeMin && (double)quarter1size < expectedQuarterSizeMax ? 1 : 0) != 0, (String)String.format("quarter1size is %s, should be between %s and %s", quarter1size, expectedQuarterSizeMin, expectedQuarterSizeMax));
        Assert.assertTrue(((double)quarter2size > expectedQuarterSizeMin && (double)quarter2size < expectedQuarterSizeMax ? 1 : 0) != 0, (String)String.format("quarter2size is %s, should be between %s and %s", quarter2size, expectedQuarterSizeMin, expectedQuarterSizeMax));
        Assert.assertTrue(((double)quarter3size > expectedQuarterSizeMin && (double)quarter3size < expectedQuarterSizeMax ? 1 : 0) != 0, (String)String.format("quarter3size is %s, should be between %s and %s", quarter3size, expectedQuarterSizeMin, expectedQuarterSizeMax));
        Assert.assertTrue(((double)quarter4size > expectedQuarterSizeMin && (double)quarter4size < expectedQuarterSizeMax ? 1 : 0) != 0, (String)String.format("quarter4size is %s, should be between %s and %s", quarter4size, expectedQuarterSizeMin, expectedQuarterSizeMax));
        Assert.assertEquals((long)(quarter1size + quarter2size + quarter3size + quarter4size), (long)sizeInBytes);
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        TestVariableWidthBlock.assertEstimatedDataSizeForStats(TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        Slice compactSlice = Slices.copyOf((Slice)TestVariableWidthBlock.createExpectedValue(16));
        Slice incompactSlice = Slices.copyOf((Slice)TestVariableWidthBlock.createExpectedValue(20)).slice(0, 16);
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestVariableWidthBlock.testCompactBlock((Block)new VariableWidthBlock(0, Slices.EMPTY_SLICE, new int[1], Optional.empty()));
        TestVariableWidthBlock.testCompactBlock((Block)new VariableWidthBlock(valueIsNull.length, compactSlice, offsets, Optional.of(valueIsNull)));
        TestVariableWidthBlock.testIncompactBlock((Block)new VariableWidthBlock(valueIsNull.length - 1, compactSlice, offsets, Optional.of(valueIsNull)));
        TestVariableWidthBlock.testIncompactBlock((Block)new VariableWidthBlock(valueIsNull.length, incompactSlice, offsets, Optional.of(valueIsNull)));
    }

    private void assertVariableWithValues(Slice[] expectedValues) {
        BlockBuilder blockBuilder = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        return TestVariableWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
    }

    private static BlockBuilder writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        }
        return blockBuilder;
    }
}

