/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.catalogserver;

import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.catalogserver.TestingCatalogServerClient;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTransactionHandle;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestCatalogServerResponse {
    private TestingCatalogServerClient testingCatalogServerClient;
    private ObjectMapper objectMapper;

    @BeforeTest
    public void setup() {
        this.testingCatalogServerClient = new TestingCatalogServerClient();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new HandleJsonModule()});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testSchemaExists() throws Exception {
        boolean schemaExists = this.testingCatalogServerClient.schemaExists(null, null, null);
        boolean actualSchemaExists = false;
        Assert.assertEquals((boolean)schemaExists, (boolean)actualSchemaExists);
    }

    @Test
    public void testCatalogExists() throws Exception {
        boolean catalogExists = this.testingCatalogServerClient.catalogExists(null, null, null);
        boolean actualCatalogExists = true;
        Assert.assertEquals((boolean)catalogExists, (boolean)actualCatalogExists);
    }

    @Test
    public void testListSchemaNames() throws Exception {
        String schemaNamesJson = this.testingCatalogServerClient.listSchemaNames(null, null, null);
        List schemaNames = (List)this.objectMapper.readValue(schemaNamesJson, (TypeReference)new TypeReference<List<String>>(){});
        ArrayList<String> actualSchemaNames = new ArrayList<String>(Arrays.asList("information_schema", "tiny", "sf1", "sf100", "sf300", "sf1000", "sf3000", "sf10000", "sf30000", "sf100000"));
        Assert.assertEquals((Collection)schemaNames, actualSchemaNames);
    }

    @Test
    public void testGetTableHandle() throws Exception {
        String tableHandleJson = this.testingCatalogServerClient.getTableHandle(null, null, null);
        TableHandle tableHandle = (TableHandle)this.objectMapper.readValue(tableHandleJson, TableHandle.class);
        ConnectorId connectorId = new ConnectorId("$info_schema@system");
        InformationSchemaTableHandle connectorHandle = new InformationSchemaTableHandle("system", "information_schema", "schemata");
        UUID uuid = UUID.fromString("ffe9ae3e-60de-4175-a0b5-d635767085fa");
        InformationSchemaTransactionHandle connectorTransactionHandle = new InformationSchemaTransactionHandle(new TransactionId(uuid));
        TableHandle actualTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)connectorHandle, (ConnectorTransactionHandle)connectorTransactionHandle, Optional.empty());
        Assert.assertEquals((Object)tableHandle, (Object)actualTableHandle);
    }

    @Test
    public void testListTables() throws Exception {
        String tableListJson = this.testingCatalogServerClient.listTables(null, null, null);
        List tableList = (List)this.objectMapper.readValue(tableListJson, (TypeReference)new TypeReference<List<QualifiedObjectName>>(){});
        ArrayList<QualifiedObjectName> actualTableList = new ArrayList<QualifiedObjectName>(Arrays.asList(new QualifiedObjectName("tpch", "sf1", "nation")));
        Assert.assertEquals((Collection)tableList, actualTableList);
    }

    @Test
    public void testListViews() throws Exception {
        String viewsListJson = this.testingCatalogServerClient.listViews(null, null, null);
        List viewsList = (List)this.objectMapper.readValue(viewsListJson, (TypeReference)new TypeReference<List<QualifiedObjectName>>(){});
        ArrayList<QualifiedObjectName> actualViewsList = new ArrayList<QualifiedObjectName>(Arrays.asList(new QualifiedObjectName("hive", "tpch", "eric"), new QualifiedObjectName("hive", "tpch", "eric2")));
        Assert.assertEquals((Collection)viewsList, actualViewsList);
    }

    @Test
    public void testGetViews() throws Exception {
        String viewsMapJson = this.testingCatalogServerClient.getViews(null, null, null);
        Map viewsMap = (Map)this.objectMapper.readValue(viewsMapJson, (TypeReference)new TypeReference<Map<QualifiedObjectName, ViewDefinition>>(){});
        HashMap<QualifiedObjectName, ViewDefinition> actualViewsMap = new HashMap<QualifiedObjectName, ViewDefinition>();
        QualifiedObjectName key = new QualifiedObjectName("hive", "tpch", "eric");
        actualViewsMap.put(key, new ViewDefinition("SELECT name\nFROM\n  tpch.sf1.nation\n", Optional.of("hive"), Optional.of("tpch"), new ArrayList(), Optional.of("ericn576"), false));
        Assert.assertEquals(viewsMap.keySet(), actualViewsMap.keySet());
        ViewDefinition viewDefinition = (ViewDefinition)viewsMap.get(key);
        ViewDefinition actualViewDefinition = (ViewDefinition)actualViewsMap.get(key);
        Assert.assertEquals((String)viewDefinition.getOriginalSql(), (String)actualViewDefinition.getOriginalSql());
        Assert.assertEquals((Object)viewDefinition.getCatalog(), (Object)actualViewDefinition.getCatalog());
        Assert.assertEquals((Object)viewDefinition.getSchema(), (Object)actualViewDefinition.getSchema());
        Assert.assertEquals((Object)viewDefinition.getOwner(), (Object)actualViewDefinition.getOwner());
    }

    @Test
    public void testGetView() throws Exception {
        String viewDefinitionJson = this.testingCatalogServerClient.getView(null, null, null);
        ViewDefinition viewDefinition = (ViewDefinition)this.objectMapper.readValue(viewDefinitionJson, ViewDefinition.class);
        ViewDefinition actualViewDefinition = new ViewDefinition("SELECT name\nFROM\n  tpch.sf1.nation\n", Optional.of("hive"), Optional.of("tpch"), new ArrayList(), Optional.of("ericn576"), false);
        Assert.assertEquals((String)viewDefinition.getOriginalSql(), (String)actualViewDefinition.getOriginalSql());
        Assert.assertEquals((Object)viewDefinition.getCatalog(), (Object)actualViewDefinition.getCatalog());
        Assert.assertEquals((Object)viewDefinition.getSchema(), (Object)actualViewDefinition.getSchema());
        Assert.assertEquals((Object)viewDefinition.getOwner(), (Object)actualViewDefinition.getOwner());
    }

    @Test
    public void testGetMaterializedView() throws Exception {
        String connectorMaterializedViewDefinitionJson = this.testingCatalogServerClient.getMaterializedView(null, null, null);
        MaterializedViewDefinition materializedViewDefinition = (MaterializedViewDefinition)this.objectMapper.readValue(connectorMaterializedViewDefinitionJson, MaterializedViewDefinition.class);
        String originalSql = "SELECT\n  name\n, nationkey\nFROM\n  test_customer_base\n";
        String schema = "tpch";
        String table = "eric";
        ArrayList<SchemaTableName> baseTables = new ArrayList<SchemaTableName>(Arrays.asList(new SchemaTableName("tpch", "test_customer_base")));
        Optional<String> owner = Optional.of("ericn576");
        ArrayList<MaterializedViewDefinition.ColumnMapping> columnMappings = new ArrayList<MaterializedViewDefinition.ColumnMapping>();
        MaterializedViewDefinition.TableColumn tableColumn = new MaterializedViewDefinition.TableColumn(new SchemaTableName("tpch", "eric"), "name", true);
        MaterializedViewDefinition.TableColumn listTableColumn = new MaterializedViewDefinition.TableColumn(new SchemaTableName("tpch", "test_customer_base"), "name", true);
        columnMappings.add(new MaterializedViewDefinition.ColumnMapping(tableColumn, new ArrayList<MaterializedViewDefinition.TableColumn>(Arrays.asList(listTableColumn))));
        ArrayList baseTablesOnOuterJoinSide = new ArrayList();
        Optional<ArrayList<String>> validRefreshColumns = Optional.of(new ArrayList<String>(Arrays.asList("nationkey")));
        MaterializedViewDefinition actualMaterializedViewDefinition = new MaterializedViewDefinition(originalSql, schema, table, baseTables, owner, columnMappings, baseTablesOnOuterJoinSide, validRefreshColumns);
        Assert.assertEquals((String)materializedViewDefinition.getOriginalSql(), (String)actualMaterializedViewDefinition.getOriginalSql());
        Assert.assertEquals((String)materializedViewDefinition.getSchema(), (String)actualMaterializedViewDefinition.getSchema());
        Assert.assertEquals((String)materializedViewDefinition.getTable(), (String)actualMaterializedViewDefinition.getTable());
        Assert.assertEquals((Collection)materializedViewDefinition.getBaseTables(), (Collection)actualMaterializedViewDefinition.getBaseTables());
        Assert.assertEquals((Object)materializedViewDefinition.getOwner(), (Object)actualMaterializedViewDefinition.getOwner());
        Assert.assertEquals((Map)materializedViewDefinition.getColumnMappingsAsMap(), (Map)actualMaterializedViewDefinition.getColumnMappingsAsMap());
        Assert.assertEquals((Collection)materializedViewDefinition.getBaseTablesOnOuterJoinSide(), (Collection)actualMaterializedViewDefinition.getBaseTablesOnOuterJoinSide());
        Assert.assertEquals((Object)materializedViewDefinition.getValidRefreshColumns(), (Object)actualMaterializedViewDefinition.getValidRefreshColumns());
    }

    @Test
    public void testGetReferencedMaterializedViews() throws Exception {
        String referencedMaterializedViewsListJson = this.testingCatalogServerClient.getReferencedMaterializedViews(null, null, null);
        List referencedMaterializedViewsList = (List)this.objectMapper.readValue(referencedMaterializedViewsListJson, (TypeReference)new TypeReference<List<QualifiedObjectName>>(){});
        ArrayList<QualifiedObjectName> actualReferencedMaterializedViewsList = new ArrayList<QualifiedObjectName>(Arrays.asList(new QualifiedObjectName("hive", "tpch", "test_customer_base")));
        Assert.assertEquals((Collection)referencedMaterializedViewsList, actualReferencedMaterializedViewsList);
    }
}

