/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.catalogserver;

import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.presto.catalogserver.RandomCatalogServerAddressSelector;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRandomCatalogServerAddressSelector {
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("dummy");

    @Test
    public void testAddressSelectionContextPresent() {
        InMemoryNodeManager internalNodeManager = new InMemoryNodeManager();
        RandomCatalogServerAddressSelector selector = new RandomCatalogServerAddressSelector((InternalNodeManager)internalNodeManager);
        HostAndPort hostAndPort = HostAndPort.fromParts((String)"abc", (int)123);
        Optional address = selector.selectAddress(Optional.of(hostAndPort.toString()));
        Assert.assertTrue((boolean)address.isPresent());
        Assert.assertEquals((Object)((SimpleAddressSelector.SimpleAddress)address.get()).getHostAndPort(), (Object)hostAndPort);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddressSelectionContextPresentWithInvalidAddress() {
        InMemoryNodeManager internalNodeManager = new InMemoryNodeManager();
        RandomCatalogServerAddressSelector selector = new RandomCatalogServerAddressSelector((InternalNodeManager)internalNodeManager);
        selector.selectAddress(Optional.of("host:123.456"));
    }

    @Test
    public void testAddressSelectionNoContext() {
        InMemoryNodeManager internalNodeManager = new InMemoryNodeManager();
        RandomCatalogServerAddressSelector selector = new RandomCatalogServerAddressSelector((InternalNodeManager)internalNodeManager, hostAndPorts -> Optional.of(hostAndPorts.get(0)));
        internalNodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("1", URI.create("local://localhost:123/1"), OptionalInt.empty(), "1", false, false, true)});
        internalNodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("2", URI.create("local://localhost:456/1"), OptionalInt.of(2), "1", false, false, true)});
        internalNodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("3", URI.create("local://localhost:789/2"), OptionalInt.of(3), "1", false, false, true)});
        Optional address = selector.selectAddress(Optional.empty());
        Assert.assertTrue((boolean)address.isPresent());
        Assert.assertEquals((Object)((SimpleAddressSelector.SimpleAddress)address.get()).getHostAndPort(), (Object)HostAndPort.fromParts((String)"localhost", (int)2));
    }
}

