/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSortNodeStats
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForSortNode() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.0).setHighValue(30.0).setDistinctValuesCount(20.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "b", (Type)DoubleType.DOUBLE), VariableStatsEstimate.builder().setNullsFraction(0.6).setLowValue(13.5).setHighValue(Double.POSITIVE_INFINITY).setDistinctValuesCount(40.0).build()).build();
        this.tester().assertStatsFor(pb -> pb.output(outputBuilder -> {
            VariableReferenceExpression a = pb.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = pb.variable("b", (Type)DoubleType.DOUBLE);
            outputBuilder.source((PlanNode)pb.values(a, b)).column(a, "a1").column(a, "a2").column(b, "b");
        })).withSourceStats(stats).check(outputStats -> outputStats.equalTo(stats));
    }
}

