/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestUnnestStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testUnnestStatsNotPopulatedForMultiRow() {
        this.tester().assertStatsFor(pb -> pb.unnest((PlanNode)pb.values(pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))), (List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)), (Object)ImmutableList.of((Object)pb.variable("key"), (Object)pb.variable("value"))), Optional.empty())).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(2.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)), VariableStatsEstimate.builder().setAverageRowSize(100.0).build()).build()).check(check -> check.equalTo(PlanNodeStatsEstimate.unknown()));
    }

    @Test
    public void testUnnestStatsPopulated() {
        this.tester().assertStatsFor(pb -> pb.unnest((PlanNode)pb.values(pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))), (List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)pb.variable("some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)), (Object)ImmutableList.of((Object)pb.variable("key", (Type)VarcharType.VARCHAR), (Object)pb.variable("value", (Type)VarcharType.VARCHAR))), Optional.empty())).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)), VariableStatsEstimate.builder().setAverageRowSize(100.0).build()).build()).check(check -> check.outputRowsCount(1.0).variableStats(new VariableReferenceExpression(Optional.empty(), "some_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)), assertion -> assertion.averageRowSize(100.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "key", (Type)VarcharType.VARCHAR), assertion -> assertion.averageRowSize(100.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "value", (Type)VarcharType.VARCHAR), assertion -> assertion.averageRowSize(100.0)));
    }
}

