/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.EstimateAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import java.util.Objects;
import org.testng.Assert;

public class VariableStatsAssertion {
    private final VariableStatsEstimate statistics;

    private VariableStatsAssertion(VariableStatsEstimate statistics) {
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public static VariableStatsAssertion assertThat(VariableStatsEstimate actual) {
        return new VariableStatsAssertion(actual);
    }

    public VariableStatsAssertion nullsFraction(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getNullsFraction(), expected, "nullsFraction mismatch", new Object[0]);
        return this;
    }

    public VariableStatsAssertion nullsFractionUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getNullsFraction()), (String)("expected unknown nullsFraction but got " + this.statistics.getNullsFraction()));
        return this;
    }

    public VariableStatsAssertion lowValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getLowValue(), expected, "lowValue mismatch", new Object[0]);
        return this;
    }

    public VariableStatsAssertion lowValueUnknown() {
        return this.lowValue(Double.NEGATIVE_INFINITY);
    }

    public VariableStatsAssertion highValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getHighValue(), expected, "highValue mismatch", new Object[0]);
        return this;
    }

    public VariableStatsAssertion highValueUnknown() {
        return this.highValue(Double.POSITIVE_INFINITY);
    }

    public void empty() {
        this.emptyRange().distinctValuesCount(0.0).nullsFraction(1.0);
    }

    public VariableStatsAssertion emptyRange() {
        Assert.assertTrue((Double.isNaN(this.statistics.getLowValue()) && Double.isNaN(this.statistics.getHighValue()) ? 1 : 0) != 0, (String)("expected empty range (NaN, NaN) but got (" + this.statistics.getLowValue() + ", " + this.statistics.getHighValue() + ") instead"));
        Assert.assertEquals((double)this.statistics.getDistinctValuesCount(), (double)0.0, (String)"expected no distinctValuesCount");
        Assert.assertEquals((double)this.statistics.getAverageRowSize(), (double)0.0, (String)"expected 0 average row size");
        Assert.assertEquals((double)this.statistics.getNullsFraction(), (double)1.0, (String)"expected all nulls");
        return this;
    }

    public VariableStatsAssertion unknownRange() {
        return this.lowValueUnknown().highValueUnknown();
    }

    public VariableStatsAssertion distinctValuesCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getDistinctValuesCount(), expected, "distinctValuesCount mismatch", new Object[0]);
        return this;
    }

    public VariableStatsAssertion distinctValuesCountUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getDistinctValuesCount()), (String)("expected unknown distinctValuesCount but got " + this.statistics.getDistinctValuesCount()));
        return this;
    }

    public VariableStatsAssertion averageRowSize(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getAverageRowSize(), expected, "average row size mismatch", new Object[0]);
        return this;
    }

    public VariableStatsAssertion dataSizeUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getAverageRowSize()), (String)("expected unknown dataSize but got " + this.statistics.getAverageRowSize()));
        return this;
    }

    public VariableStatsAssertion isEqualTo(VariableStatsEstimate expected) {
        return this.nullsFraction(expected.getNullsFraction()).lowValue(expected.getLowValue()).highValue(expected.getHighValue()).distinctValuesCount(expected.getDistinctValuesCount()).averageRowSize(expected.getAverageRowSize());
    }
}

